<?php
/**
 * @file
 * Default theme implementation to display a single Drupal page.
 *
 * The doctype, html, head and body tags are not in this template. Instead they
 * can be found in the html.tpl.php template in this directory.
 *
 * Available variables:
 *
 * Variables:
 * - $site_name: site name
 * - $questions: all available question of the test
 * - $test: all test data
 * - $question_number: questions number
 * - $time: test max time in minutes
 * - $seconds: test max time in seconds
 * - $next: next button text.
 *
 * @ingroup templates
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
// Build chart datalist

$data = [];
$cols = array_keys(get_object_vars($logs[0]));

foreach ($logs as $log) {
    foreach ($cols as $col) {
        if (!isset($data[$col])) {
            $data[$col] = [];
        }
        $data[$col][] = $log->$col;
    }
}

unset($data['id']);
unset($data['duid']);

//ddd($data);
?>

<!--<div class="">
    <button id="btnSave" class="btn btn-info">Save image</button>
</div>-->
<style>
</style>
<main id="dreams">
    <section id="">
        <div class="">
            <div class="container">

                <div class="row mt-30">
                    <div class="col-sm-12">
                        <div class="log-table" id="dreams-log-list-form">
                            <?php
//                                print render($form['uid']);
//                                print render($form['from']);
//                                print render($form['until']);
//                                print render($form['submit']);
//                                print render($form['options']['reset']);
//
                            ?>

                            <?php // print render($form['table']); ?>

                            <?php // print render($form['pager']); ?>
                        </div>
                    </div>
                </div>

                <div class="row mt-30">
                    <div class="col-sm-12">
                        <h2 class="text-center"><?php echo t('Dreams progress'); ?></h2>
                        <div class="bulk-actions text-center" >
                            <span class="btn btn-sm btn-outline-danger" id="closeAll"><?php echo t('Close all'); ?></span>
                            <span class="btn btn-sm btn-outline-primary" id="showAll"><?php echo t('Show all'); ?></span>
                        </div>
                        <br/>
                        <div class="log-chart" >
                            <canvas id="logBarChart" class="log-chart" width="700" height="300" ></canvas>
                        </div>
                    </div>
                </div>

                <div class="row mt-30">
                    <div class="col-sm-12">
                        <div class="log-table table-responsive" >
                            <table class="table">
                                <tr class="table-header">
                                    <th class="date-head"></th>
                                    <?php
                                    foreach ($data['created_at'] as $date) {
                                        echo '<th class="date-head">' . $date . '</th>';
                                    }
                                    ?>
                                </tr>
                                <?php
                                foreach ($categories as $key => $category) {
                                    $tr = '<tr class="">';
                                    $tr .= '<th class="label" style="background: #' . $category['color'] . ';">' . $category['label'] . '</th>';

                                    foreach ($data[$key] as $k => $log) {
                                        $diff = 0;
                                        if ($k > 0) {
                                            $diff = (float) $log - (float) $data[$key][$k - 1];
                                        }
                                        if ($diff > 0) {
                                            $color = $colors[1];
                                        } else if ($diff < 0) {
                                            $color = $colors[0];
                                        } else {
                                            $color = 'FFFFFF00';
                                        }
                                        $tr .= '<td class="value" style="background: #' . $color . ';">' . $log . '</th>';
                                    }

                                    $tr .= '</tr>';
                                    echo $tr;
                                }
                                ?>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="row mt-30">
                    <div class="col-sm-12">
                        <h2 style="text-center"><?php echo t('Business Life'); ?></h2>
                        <br/>
                        <div class="log-chart" >
                            <canvas id="logBusinessChart" class="log-chart" width="700" height="200" style="margin-bottom: 50px;" ></canvas>
                        </div>
                    </div>
                </div>

                <div class="row mt-30">
                    <div class="col-sm-12">
                        <h2 style="text-center"><?php echo t('Creative Life'); ?></h2>
                        <br/>
                        <div class="log-chart" >
                            <canvas id="logCreativeChart" class="log-chart" width="700" height="200" style="margin-bottom: 50px;" ></canvas>
                        </div>
                    </div>
                </div>

                <div class="row mt-30">
                    <div class="col-sm-12">
                        <h2 style="text-center"><?php echo t('Social Life'); ?></h2>
                        <br/>
                        <div class="log-chart" >
                            <canvas id="logSocialChart" class="log-chart" width="700" height="200" style="margin-bottom: 50px;" ></canvas>
                        </div>
                    </div>
                </div>

                <div class="row mt-30">
                    <div class="col-sm-12">
                        <h2 style="text-center"><?php echo t('Love Life'); ?></h2>
                        <br/>
                        <div class="log-chart" >
                            <canvas id="logLoveChart" class="log-chart" width="700" height="200" style="margin-bottom: 50px;" ></canvas>
                        </div>
                    </div>
                </div>

                <div class="row mt-30">
                    <div class="col-sm-12">
                        <h2 style="text-center"><?php echo t('Life Purpose'); ?></h2>
                        <br/>
                        <div class="log-chart" >
                            <canvas id="logPurposeChart" class="log-chart" width="700" height="200" style="margin-bottom: 50px;" ></canvas>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

</main>
<?php
//    crt_debug($eff);
//ddd($data);
?>

<!--<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.4.0/Chart.min.js"></script>-->

<script>

    (function ($) {
        var barInstance = new Chart(document.getElementById("logBarChart"), {
            "type": "bar",
            "data": {
                "labels": <?php echo json_encode($data['created_at']); ?>,
                "datasets": [
                    <?php
                    foreach ($data as $key => $value) {
                        if ($key != 'created_at') {
                            ?>
                        {
                        "label": '<?php echo $categories[$key]['label']; ?>',
                                "backgroundColor": '#<?php echo $categories[$key]['color'] ?>',
                                //                                "backgroundColor": 'transparent',
                                "borderColor": '#<?php echo $categories[$key]['color'] ?>',
                                "data": <?php echo json_encode($value); ?>
                        },
                            <?php
                        }
                    }
                    ?>
                ]
            },
            "options": {
                "aspectRatio": 2,
                "responsive": true,
                "legend": {
                    "display": true
                },
                "scales": {
                    "xAxes": [{
                        "stacked": true,
                        "ticks": {
                            "fontSize": 0,
                        }
                    }],
                    "yAxes": [{
                        "stacked": true
                    }],
//                    "xAxes": [{
//                            "type": 'time',
//                            "time": {
//                                "unit": 'day'
//                            }
//                        }]
                },
                "tooltips": {
                "mode": 'point'
                }
            }
    });
    
    $('#closeAll').on('click', function() {

        barInstance.data.datasets.forEach(function(dataset) {
            dataset.hidden = true;
        });
        barInstance.update();

    });

    $('#showAll').on('click', function() {

        barInstance.data.datasets.forEach(function(dataset) {
            dataset.hidden = false;
        });
        barInstance.update();

    });
    
    new Chart(document.getElementById("logBusinessChart"), {
    "type": "line",
            "data": {
            "labels": <?php echo json_encode($data['created_at']); ?>,
                    "datasets": [
<?php
foreach ($data as $key => $value) {
    if ($key == 'money' || $key == 'career') {
        ?>
                            {
                            "label": '<?php echo $categories[$key]['label']; ?>',
                                    "backgroundColor": 'transparent',
                                    "borderColor": '#<?php echo $categories[$key]['color'] ?>',
                                    "data": <?php echo json_encode($value); ?>,
                                    "lineTension": 0.1,
                            },
        <?php
    }
}
?>
                    ]
            },
            "options": {
            "aspectRatio": 2,
                    "responsive": true,
//                    "legend": {
//                    "position": 'left'
//                    },
                    "scales": {
                        "yAxes": [{
                            "ticks": {
                                "beginAtZero": true,
                                    "max": 10
                            }
                        }],
                        "xAxes": [{
                            "ticks": {
                                "fontSize": 0,
                            }
                        }]
    //                    "xAxes": [{
//                            "type": 'time',
//                            "time": {
//                                "unit": 'day'
//                            }
//                        }] 
                    },
                    "tooltips": {
                    "mode": 'point'
                    }
            }
    });
    new Chart(document.getElementById("logCreativeChart"), {
    "type": "line",
            "data": {
            "labels": <?php echo json_encode($data['created_at']); ?>,
                    "datasets": [
<?php
foreach ($data as $key => $value) {
    if ($key == 'health' || $key == 'fun') {
        ?>
                            {
                            "label": '<?php echo $categories[$key]['label']; ?>',
                                    "backgroundColor": 'transparent',
                                    "borderColor": '#<?php echo $categories[$key]['color'] ?>',
                                    "data": <?php echo json_encode($value); ?>,
                                    "lineTension": 0.1,
                            },
        <?php
    }
}
?>
                    ]
            },
            "options": {
            "aspectRatio": 2,
                    "responsive": true,
//                    "legend": {
//                    "position": 'left'
//                    },
                    "scales": {
                    "yAxes": [{
                    "ticks": {
                    "beginAtZero": true,
                            "max": 10
                    }
                    }],
                        "xAxes": [{
                            "ticks": {
                                "fontSize": 0,
                            }
                        }]
//                    "xAxes": [{
//                            "type": 'time',
//                            "time": {
//                                "unit": 'day'
//                            }
//                        }]
                    },
                    "tooltips": {
                    "mode": 'point'
                    }
            }
    });
    new Chart(document.getElementById("logSocialChart"), {
    "type": "line",
            "data": {
            "labels": <?php echo json_encode($data['created_at']); ?>,
                    "datasets": [
<?php
foreach ($data as $key => $value) {
    if ($key == 'enviroment' || $key == 'community') {
        ?>
                            {
                            "label": '<?php echo $categories[$key]['label']; ?>',
                                    "backgroundColor": 'transparent',
                                    "borderColor": '#<?php echo $categories[$key]['color'] ?>',
                                    "data": <?php echo json_encode($value); ?>,
                                    "lineTension": 0.1,
                            },
        <?php
    }
}
?>
                    ]
            },
            "options": {
            "aspectRatio": 2,
                    "responsive": true,
//                    "legend": {
//                    "position": 'left'
//                    },
                    "scales": {
                    "yAxes": [{
                    "ticks": {
                    "beginAtZero": true,
                            "max": 10
                    }
                    }],
                        "xAxes": [{
                            "ticks": {
                                "fontSize": 0,
                            }
                        }]
//                    "xAxes": [{
//                            "type": 'time',
//                            "time": {
//                                "unit": 'day'
//                            }
//                        }]
                    },
                    "tooltips": {
                    "mode": 'point'
                    }
            }
    });
    new Chart(document.getElementById("logLoveChart"), {
    "type": "line",
            "data": {
            "labels": <?php echo json_encode($data['created_at']); ?>,
                    "datasets": [
<?php
foreach ($data as $key => $value) {
    if ($key == 'family' || $key == 'love') {
        ?>
                            {
                            "label": '<?php echo $categories[$key]['label']; ?>',
                                    "backgroundColor": 'transparent',
                                    "borderColor": '#<?php echo $categories[$key]['color'] ?>',
                                    "data": <?php echo json_encode($value); ?>,
                                    "lineTension": 0.1,
                            },
        <?php
    }
}
?>
                    ]
            },
            "options": {
            "aspectRatio": 2,
                    "responsive": true,
//                    "legend": {
//                    "position": 'left'
//                    },
                    "scales": {
                    "yAxes": [{
                    "ticks": {
                    "beginAtZero": true,
                            "max": 10
                    }
                    }],
                        "xAxes": [{
                            "ticks": {
                                "fontSize": 0,
                            }
                        }]
//                    "xAxes": [{
//                            "type": 'time',
//                            "time": {
//                                "unit": 'day'
//                            }
//                        }]
                    },
                    "tooltips": {
                    "mode": 'point'
                    }
            }
    });
    new Chart(document.getElementById("logPurposeChart"), {
    "type": "line",
            "data": {
            "labels": <?php echo json_encode($data['created_at']); ?>,
                    "datasets": [
<?php
foreach ($data as $key => $value) {
    if ($key == 'learning' || $key == 'spirituality') {
        ?>
                            {
                            "label": '<?php echo $categories[$key]['label']; ?>',
                                    "backgroundColor": 'transparent',
                                    "borderColor": '#<?php echo $categories[$key]['color'] ?>',
                                    "data": <?php echo json_encode($value); ?>,
                                    "lineTension": 0.1,
                            },
        <?php
    }
}
?>
                    ]
            },
            "options": {
                "aspectRatio": 3,
                    "responsive": true,
//                    "legend": {
//                        "display": false
//                    },
                    "scales": {
                    "yAxes": [{
                    "ticks": {
                    "beginAtZero": true,
                            "max": 10
                    }
                    }],
                        "xAxes": [{
                            "ticks": {
                                "fontSize": 0,
                            }
                        }]
//                    "xAxes": [{
//                            "type": 'time',
//                            "time": {
//                                "unit": 'day'
//                            }
//                        }]
                    },
                    "tooltips": {
                    "mode": 'point'
                    }
            }
    });
    function rFactor() {
    return Math.round(Math.random() * 100);
    };
    })(jQuery);


</script>