<?php
/**
 * @file
 * Default theme implementation to display a single Drupal page.
 *
 * The doctype, html, head and body tags are not in this template. Instead they
 * can be found in the html.tpl.php template in this directory.
 *
 * Available variables:
 *
 * Variables:
 * - $site_name: site name
 * - $questions: all available question of the test
 * - $test: all test data
 * - $question_number: questions number
 * - $time: test max time in minutes
 * - $seconds: test max time in seconds
 * - $next: next button text.
 *
 * @ingroup templates
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
// Build chart datalist
$datasets = [];
$labels = [];
foreach ($goals as $key => $value) {
    foreach ($value['goals'] as $k => $v) {
        if (!isset($datasets[$k])) {
            $datasets[$k] = [
                "data" => [],
                "backgroundColor" => [],
                "borderColor" => [],
                "borderWidth" => [],
                "labels" => []
            ];
        }
        $datasets[$k]['data'][] = $v['percent'];
        $datasets[$k]['data'][] = 100 - $v['percent'];
        $datasets[$k]['backgroundColor'][] = '#' . $value['color'];
        $datasets[$k]['backgroundColor'][] = '#ffffff';
        $datasets[$k]['labels'][] = $v['goal'];
        $datasets[$k]['labels'][] = $v['goal'];
        $datasets[$k]['borderColor'][] = '#aaa';
        $datasets[$k]['borderColor'][] = '#aaa';
        $datasets[$k]['borderWidth'][] = 1;
        $datasets[$k]['borderWidth'][] = 1;
    }
    $labels[] = $value['label'];
    $labels[] = $value['label'] . t(' missing');
}
//ddd($datasets);
?>

<!--<div class="">
    <button id="btnSave" class="btn btn-info">Save image</button>
</div>-->
<style>
</style>
<main id="dreams">
    <section id="">
        <div class="">
            <div class="container">

                <div class="row mt-30">
                    <div class="col-sm-12">
                        <h2 class="text-center"><?php echo t('Goals progress'); ?></h2>
                        <div class="bulk-actions text-center" >
                            <span class="btn btn-sm btn-outline-danger" id="closeAll"><?php echo t('Close all'); ?></span>
                            <span class="btn btn-sm btn-outline-primary" id="showAll"><?php echo t('Show all'); ?></span>
                            <span class="btn btn-sm btn-outline-dark" id="hideMiss"><?php echo t('Hide missings'); ?></span>
                        </div>
                        <br/>
                        <div class="goal-chart" >
                            <canvas id="logGoalChart" class="goal-chart" width="700" height="300" ></canvas>
                        </div>
                    </div>
                </div>

                <div class="row mt-30">
                    <div class="col-sm-12">
                        <div class="goals-table table-responsive" >
                            <table class="table">
                                <thead>
                                    <tr class="table-header">
                                        <th class="date-head"><?php echo t('Area'); ?></th>
                                        <th class="date-head"><?php echo t('Category'); ?></th>
                                        <th class="date-head"><?php echo t('Goal'); ?></th>
                                        <th class="date-head"><?php echo t('%'); ?></th>
                                        <th class="date-head"><?php echo t('Next action'); ?></th>
                                        <th class="date-head"><?php echo t('Deadline'); ?></th>
                                        <th class="date-head"><?php echo t('Operations'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $c = 0;
                                    foreach ($goals as $key => $category) {
                                        foreach ($category['goals'] as $k => $v) {
                                            $complete = $v['percent'] == 100 ? 'success' : '';
                                            $tr = '<tr class="' . $complete . '">';
                                            if ($c % 6 == 0) {
                                                $tr .= '<th rowspan="6" class="label" style="background: #' . $sections[$category['section']]['color'] . ';">' . $sections[$category['section']]['label'] . '</th>';
                                            }
                                            if ($c % 3 == 0) {
                                                $tr .= '<th rowspan="3" class="label" style="background: #' . $category['color'] . ';">' . $category['label'] . '</th>';
                                            }

                                            $tr .= '<td class="goal">' . $v['goal'] . '</td>';
                                            $tr .= '<td class="percent">' . $v['percent'] . '</td>';
                                            $tr .= '<td class="action">' . $v['action'] . '</td>';
                                            $tr .= '<td class="deadline">' . $v['deadline'] . '</td>';
                                            $tr .= '<td class="operation"><small>' . l(t('Edit'), '/dreams/' . $duser->duid . '/goals/edit', array()) . '</small></td>';
                                            $tr .= '</tr>';
                                            echo $tr;
                                            $c++;
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

</main>
<?php
//    crt_debug($eff);
//ddd($data);
?>
<script>

    (function ($) {

        const options = {
                "cutoutPercentage": 20,
                "responsive": true,
                "legend": {
                    "position": 'right',
                },
                "title": {
                    "display": false,
                    "text": '<?php echo t('All goal progress chart'); ?>'
                },
                "animation": {
                    "animateScale": true,
                    "animateRotate": true
                },
                "tooltips": {
                    "callbacks": {
                        "label": function (tooltipItem, data) {
                            var label = data.labels[tooltipItem.index] || '';
                            var goal = data.datasets[tooltipItem.datasetIndex].labels[tooltipItem.index] || '';
                            var value = data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index] || '';

                            if (value) {
                                value += '%';
                            }

                            label = label + ': ' + value + ' - ' + goal;
                            return label;
                        }
                    }
                }
            };
        const initData = <?php echo json_encode($datasets); ?>;
            
        var chartInstance = new Chart(document.getElementById("logGoalChart"), {
            "type": 'doughnut',
            "data": {
                "datasets": initData,
                "labels": <?php echo json_encode($labels); ?>,
            },
            "options": options
        });
        
        $('#closeAll').on('click', function() {
				
            chartInstance.data.datasets.forEach(function(dataset) {
                let n = 0;
                let all = dataset.data.length;
                for (n = 0; n < all; n++) {
                    dataset._meta[0].data[n].hidden = true;
                };
            });
            chartInstance.update();

        });
        
        $('#showAll').on('click', function() {

            chartInstance.data.datasets.forEach(function(dataset) {
                let n = 0;
                let all = dataset.data.length;
                for (n = 0; n < all; n++) {
                    dataset._meta[0].data[n].hidden = false;
                };
            });
            chartInstance.update();

        });
        
        $('#hideMiss').on('click', function() {
					
            let n = 0;
            chartInstance.data.datasets.forEach(function(dataset) {
                n = 0;
                let all = dataset.data.length;
                for (n = 0; n < all; n++) {
                    if (n % 2 == 1) {
                        dataset._meta[0].data[n].hidden = true;
                    }
                };
            });
            chartInstance.update();

        });
        
        function rFactor() {
            return Math.round(Math.random() * 100);
        };
    })(jQuery);


</script>