<?php
/**
 * @file
 * Default theme implementation to display a single Drupal page.
 *
 * The doctype, html, head and body tags are not in this template. Instead they
 * can be found in the html.tpl.php template in this directory.
 *
 * Available variables:
 *
 * Variables:
 * - $site_name: site name
 * - $questions: all available question of the test
 * - $test: all test data
 * - $question_number: questions number
 * - $time: test max time in minutes
 * - $seconds: test max time in seconds
 * - $next: next button text.
 *
 * @ingroup templates
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
// Build chart datalist
//ddd($log);
$datasets = [
    "data" => [],
    "backgroundColor" => [],
    "hoverBackgroundColor" => [],
    "labels" => []
];
$labels = [];
unset($log->duid);
unset($log->id);
foreach ($log as $key => $value) {
    if ($key != 'created_at') {
        $datasets['data'][] = $value;
        $datasets['backgroundColor'][] = '#' . $categories[$key]['color'] . '80';
        $datasets['hoverBackgroundColor'][] = '#' . $categories[$key]['color'];
        $labels[] = $categories[$key]['label'];
    }
}
//ddd($datasets);
?>

<style>
</style>
<main id="dreams">
    <section id="">
        <div class="">
            <div class="container">

                <div class="row mt-30">
                    <div class="col-sm-12">
                        <h2 class="text-center"><?php echo t('Category balance'); ?></h2>
                        <br/>
                        <div class="goal-chart" >
                            <canvas id="logGoalChart" class="goal-chart" width="700" height="250" ></canvas>
                        </div>
                    </div>
                </div>

                <div class="row mt-30">
                    <div class="col-sm-12">
                        <div class="goals-table table-responsive" >
                            <table class="table table-bordered">
                                <thead>
                                    <tr class="table-header">
                                        <?php
                                        $tr = '<tr class="">';
                                        $c = 0;
                                        foreach ($categories as $key => $category) {
                                            if ($c % 2 == 0) {
                                                $tr .= '<th colspan="2" class="label" style="background: #' . $sections[$category['section']]['color'] . ';">' . $sections[$category['section']]['label'] . '</th>';
                                            }
                                            $c++;
                                        }
                                        $tr .= '</tr>';
                                        echo $tr;

                                        $tr = '<tr class="">';
                                        foreach ($categories as $key => $category) {
                                            $tr .= '<th class="label" style="background: #' . $category['color'] . ';">' . $category['label'] . '</th>';
                                        }
                                        $tr .= '</tr>';
                                        echo $tr;
                                        ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $c = 0;
                                    $tr = '<tr class="">';
                                    foreach ($categories as $key => $category) {
                                        $tr .= '<td class="value">' . $log->$key . '</td>';
                                        $c++;
                                    }
                                    $tr .= '</tr>';
                                    echo $tr;
                                    ?>
                                </tbody>
                            </table>
                            <div class="">
                                <p class="text-center"><?php echo t('Last dreams log') . ': ' . $log->created_at; ?></p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

</main>
<script>

    (function ($) {

        new Chart(document.getElementById("logGoalChart"), {
            "type": 'polarArea',
            "data": {
                "datasets": [<?php echo json_encode($datasets); ?>],
                "labels": <?php echo json_encode($labels); ?>,
            },
            "options": {
                "layout": {
                    "padding": {
                        "left": 0,
                        "right": 0,
                        "top": 20,
                        "bottom": 0
                    }
                },
                "responsive": true,
                "legend": {
                    "position": 'right',
                },
                "title": {
                    "display": false,
                    "text": '<?php echo t('All goal progress chart'); ?>'
                },
                "animation": {
                    "animateScale": true,
                    "animateRotate": true
                },
                "scale": {
                    "ticks": {
                        "beginAtZero": true,
                        "max": 10,
                        "fontSize": 16
                    }
                }
            }
        });
    })(jQuery);


</script>