<?php

/**
 * @file Dreams Dashboard settings.
 * @package Barion
 * @author Kulcsár Balázs
 */

/**
 * Creates the main settings form.
 * @param type $form
 * @param type $form_state
 * @return $form
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function dreams_settings_form($form, &$form_state) {

    global $base_url;
    $module_path = drupal_get_path('module', 'dreams');
    $assessments = dreams_base_categories();
    $sections = dreams_base_sections();

    $form = array();

    $form['overview'] = array(
        '#markup' => t('Admininstrators can set the main settings of the dreams system.'),
        '#prefix' => '<p>',
        '#suffix' => '</p>',
    );

    // Assessment settings
    $form['section'] = array(
        '#type' => 'fieldset',
        '#title' => t('Main life categories'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    foreach ($sections as $key => $value) {

        $form['section'][$key] = array(
            '#type' => 'fieldset',
            '#title' => $value['label'],
            '#collapsible' => TRUE,
            '#collapsed' => FALSE,
        );

        $form['section'][$key]['dreams_' . $key . '_label'] = array(
            '#title' => ucfirst($key) . ' ' . t('label'),
            '#type' => 'textfield',
            '#default_value' => variable_get('dreams_' . $key . '_label', $value['label']),
            '#required' => TRUE,
        );

        $form['section'][$key]['dreams_' . $key . '_color'] = array(
            '#title' => $value['label'] . ' ' . t('color'),
            '#description' => $value['label'] . ' ' . t('background color in lists.'),
            '#type' => 'textfield',
            '#default_value' => variable_get('dreams_' . $key . '_color', $value['color']),
            '#required' => TRUE,
            '#field_prefix' => '#',
            '#size' => 8,
        );
    }

    // Assessment settings
    $form['assessment'] = array(
        '#type' => 'fieldset',
        '#title' => t('Dreams assessment'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    foreach ($assessments as $key => $value) {
        $form['assessment'][$key . '_' . $value['section']] = array(
            '#type' => 'fieldset',
            '#title' => $value['label'] . ' (' . $sections[$value['section']]['label'] . ')',
            '#collapsible' => TRUE,
            '#collapsed' => TRUE,
        );

        $form['assessment'][$key . '_' . $value['section']]['dreams_' . $key . '_' . $value['section'] . '_label'] = array(
            '#title' => ucfirst($key) . ' ' . t('label'),
            '#type' => 'textfield',
            '#default_value' => variable_get('dreams_' . $key . '_' . $value['section'] . '_label', $value['label']),
            '#required' => TRUE,
        );

        $form['assessment'][$key . '_' . $value['section']]['dreams_' . $key . '_' . $value['section'] . '_color'] = array(
            '#title' => $value['label'] . ' ' . t('color'),
            '#description' => $value['label'] . ' ' . t('background color in lists.'),
            '#type' => 'textfield',
            '#default_value' => variable_get('dreams_' . $key . '_' . $value['section'] . '_color', $value['color']),
            '#required' => TRUE,
            '#field_prefix' => '#',
            '#size' => 8,
        );

        foreach ($value['questions'] as $k => $v) {
            $form['assessment'][$key . '_' . $value['section']]['dreams_' . $key . '_' . $value['section'] . '_' . $k] = array(
                '#title' => $k + 1 . '. ' . t('question'),
                '#type' => 'textfield',
                '#size' => 100,
                '#maxlength' => 1024,
                '#default_value' => variable_get('dreams_' . $key . '_' . $value['section'] . '_' . $k, $v),
                '#required' => TRUE,
            );
        }
    }

    return system_settings_form($form);
}

/**
 * After submit settings form merge emails into database and set all the variables.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
/*function dreams_settings_form_submit($form, &$form_state){

    // Save emails
    foreach($form['email']['emails'] as $k => $v){
        if(strpos($k, 'certify_mail') !== false){
            $subject = $k . '_subject';
            $body = $k . '_body';
            $fields = array(
                'variable' => $k,
                'subject'  => $form_state['values'][$subject],
                'body'     => $form_state['values'][$body]
            );
            db_merge('certify_default_emails')->key(array('variable' => $k))->fields($fields)->execute();
        }
    }
    // Exclude unnecessary elements.
    form_state_values_clean($form_state);

    // Set variables.
    certify_variable_set_from_form($form_state);

    // Save to watchdog.
    watchdog('certify', 'Settings and default emails has been refreshed.', array('certify_settings_form' => 'emails', WATCHDOG_NOTICE));
}
*/
