<?php

/**
 * @file Dreams Dashboard functions.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */

/**
 * Payment details function.
 * @params type array $paymentId All details of the order.
 * @return type array Complete response.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function dreams_payment_get_details($paymentId) {

    // Update token
    $response = db_select('dreams_transactions', 't')
            ->fields('t', array('response'))
            ->condition('payment', $paymentId)
            ->execute()
            ->fetchField();

    if (!empty($response)) {
        return unserialize($response);
    } else {
        return FALSE;
    }
}

/**
 * Payment process page before redirect.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function dreams_payment_thankyou_page() {
    global $_REQUEST;

    // Get paymentId
    if (isset($_REQUEST['paymentId'])) {
        $paymentId = check_plain($_REQUEST['paymentId']);
    } else {
        $paymentId = '';
    }

    // Get response
    $payment_response = dreams_payment_get_details($paymentId);

    // Print a message.
    drupal_set_message(t('Transaction <em>successed</em>.<br>Payment id: "%pid"', array('%pid' => $paymentId)));
    // Save to watchdog.
    watchdog('dreams', '"%uid" order is successed. Payment id: %pid', array('%uid' => $user->uid, '%pid' => $paymentId, WATCHDOG_NOTICE));
    // Return html
    return theme('dreams_thankyou', array(
        'payment' => $payment_response,
    ));
}

/**
 * Payment process page before redirect.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function dreams_log_report_chart($duid) {
    global $user;

    // Get dreams user
    $duser = dreams_get_user_by_duid(check_plain(trim($duid)));

    if ($duser == null) {
        $duser = dreams_get_user_by_uid($user->uid);
    }
    if ($duser == null) {
        drupal_set_message(t('You have no dreams data. Please fill base assessment, or goals form.'), 'error');
        dreams_redirect_to_base_assessment_form();
    }

    // Get user logs
    if ($duser != null) {
        $logs = dreams_get_user_logs($duid);
    }

    // Set colors
    $colors = ['FEBFC4', 'BEEDC9', 'ffffff00'];

    // Print a message.
//    drupal_set_message(t('Transaction <em>successed</em>.<br>Payment id: "%pid"', array('%pid' => $paymentId)));
    // Save to watchdog.
//    watchdog('dreams', '"%uid" order is successed. Payment id: %pid', array('%uid' => $user->uid, '%pid' => $paymentId, WATCHDOG_NOTICE));
    // Return html
    return theme('dreams_log_report', array(
        'duser' => $duser,
        'logs' => $logs,
        'colors' => $colors,
        'categories' => dreams_base_categories(),
    ));
}

/**
 * Basic life assessment form.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function dreams_life_assessment_form($form, &$form_state) {
    global $user;

    // Create a form.
    $intro = '<h1 class="text-center">' . t('Life Assessment') . '</h1>'
            . '<p class="text-center">' . t('Use the life assessment to see a visual representation of your progress in each category. Some questions may not be relevant to you. For the non relevant questions you can answer with a score of 10 as the life assessment is to help you identify and think about the gaps and areas of improvement. Remember to be 100% honest as this is just for your own benefit. The scores here DO NOT automatically update on the dashboard, they are to be used as a guide. ') . '</p><br>'
            . '<h4 class="text-center mb-5">' . t('Rate the following on a scale of 1 to 10, 1') . '<br>'
            . t('Being Least True and 10 Being Most True:') . '</h4>';

    $categories = dreams_base_categories();
    $duser = dreams_get_user_by_uid_assoc($user->uid);
    $assessment = unserialize($duser['assessment']);

    $form['overview'] = array(
        '#markup' => $intro,
        '#prefix' => '<div class="row mt-30 justify-content-center"><div class="col-sm-8 col-sm-offset-2 mb-5">',
        '#suffix' => ''
    );

    foreach ($categories as $key => $category) {


        $form[$key] = array(
            '#type' => 'fieldset',
        );

        $form[$key]['head'] = array(
            '#markup' => '<h5 style="background: #' . $category['color'] . ';">' . $category['label'] . '</h5>',
        );

        foreach ($category['questions'] as $k => $v) {
            $form[$key]['dreams_' . $key . '_' . $k] = array(
                '#title' => $v,
                '#type' => 'textfield',
                '#size' => 2,
                '#maxlength' => 5,
                '#element_validate' => array('dreams_element_validate_decimal'),
                '#required' => TRUE,
                '#default_value' => 0.0,
            );
            if ($duser != null) {
                $form[$key]['dreams_' . $key . '_' . $k]['#default_value'] = $assessment[$key]['questions'][$k];
            }
        }
    }

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Submit'),
        '#submit' => array('dreams_life_assessment_form_submit'),
        '#attributes' => array('class' => array('btn-success', 'mt-1')),
        '#prefix' => '<div class="text-center">',
        '#suffix' => '</div></div></div>'
    );

    return $form;
}

/**
 * Validates PIN in the Drupal Form API fields.
 * @param type $element
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function dreams_element_validate_decimal($element, &$form_state) {
    $value = check_plain(trim($element['#value']));
    if ($value < 0 || $value > 10 || !_dreams_is_float($value)) {
        form_error($element, t('%name must be decimal number beetween 0 and 10.', array('%name' => $element['#title'])));
    }
}

/**
 * Submit login form.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function dreams_life_assessment_form_submit($form, &$form_state) {
    // Get user
    global $user;

    $categories = dreams_base_categories();
    $log = array();

    foreach ($categories as $key => $category) {
        $categories[$key]['total'] = 0;

        foreach ($form_state['values'] as $k => $v) {
            $item = explode('_', $k);
            if ($item[0] == 'dreams') {
                $categories[$item[1]]['questions'][$item[2]] = (float) $v;
                if ($key == $item[1]) {
                    $categories[$key]['total'] = $categories[$key]['total'] + (float) $v;
                }
            }
        }

        $categories[$key]['average'] = $categories[$key]['total'] / count($categories[$key]['questions']);
        $log[$key] = $categories[$key]['average'];
    }
//    ddd($categories, true);

    $duser = dreams_get_user_by_uid_assoc($user->uid);

    if ($duser == null) {
        $duser['duid'] = null;
        $duser['uid'] = $user->uid;
        $duser['created_at'] = date('Y-m-d H:i:s');
    }
    $duser['assessment'] = serialize($categories);
    $duser['updated_at'] = date('Y-m-d H:i:s');

    // Merge database
    db_merge('dreams_user')
            ->key(array('duid' => $duser['duid']))
            ->fields($duser)
            ->execute();

    $duser = dreams_get_user_by_uid_assoc($user->uid);
    $log['duid'] = $duser['duid'];
    $log['created_at'] = date('Y-m-d H:i:s');

    // Insert base log
    db_insert('dreams_progress_log')
            ->fields($log)
            ->execute();

//    ddd($log, true);
    // Redirect after the save.
    $form_state['redirect'] = dreams_redirect_form_to_last_log($duser['duid']);
    // Print a message.
    drupal_set_message(t('Your base life assessment setting is successful.'));
    // Save to watchdog.
    watchdog('dreams', 'User base assessment merged: %duser.', array('%duser' => json_encode($duser), WATCHDOG_INFO));
}

/**
 * Basic life assessment form.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function dreams_goals_form($form, &$form_state, $duid) {
    global $user;

    // Create a form.
    $intro = '<h1 class="text-center">' . t('Life Goals') . '</h1>';

    $categories = dreams_base_categories();
    $duser = dreams_get_user_by_duid_assoc($duid);

    if ($duser == null) {
        $duser = dreams_get_user_by_uid($user->uid);
    }
    if ($duser == null) {
        drupal_set_message(t('You have no dreams data. Please fill base assessment, or goals form.'), 'error');
        dreams_redirect_to_base_assessment_form();
    }

    $goals = _dreams_is_serial($duser['goals']) ? unserialize($duser['goals']) : [];
//    ddd($goals);

    $form['overview'] = array(
        '#markup' => $intro,
        '#prefix' => '<div class="row mt-30 justify-content-center"><div class="col-sm-10 col-sm-offset-1 mb-5">',
        '#suffix' => ''
    );

    $c = 0;
    foreach ($categories as $key => $category) {

        $form[$key] = array(
            '#type' => 'fieldset',
        );

        $form[$key]['head'] = array(
            '#markup' => '<h5 style="background: #' . $category['color'] . ';">' . $category['label'] . ' ' . t('Goals') . '</h5>',
        );

        $i = 0;
        for ($i = 0; $i < 3; $i++) {

            $form[$key]['dreams_id_' . $key . '_' . $i] = array(
                '#markup' => $c + $i + 1,
                '#prefix' => '<div class="row m-0"><div class="col row-id">',
                '#suffix' => '</div>',
                '#size' => 1,
            );

            $form[$key]['dreams_goal_' . $key . '_' . $i] = array(
                '#type' => 'textfield',
                '#size' => 50,
                '#maxlength' => 1024,
                '#attributes' => array(
                    'placeholder' => t('Write goal...')
                ),
                '#required' => TRUE,
                '#default_value' => 'Egyszerű cél ' . ($c + $i + 1),
                '#prefix' => '<div class="col-sm-4">',
                '#suffix' => '</div>',
            );

            $form[$key]['dreams_percent_' . $key . '_' . $i] = array(
                '#type' => 'textfield',
                '#size' => 3,
                '#maxlength' => 3,
                '#attributes' => array(
                    'placeholder' => t('%'),
                    'title' => t('Percentage'),
                ),
                '#element_validate' => array('dreams_element_validate_percent'),
                '#required' => TRUE,
                '#default_value' => '0',
                '#prefix' => '<div class="col">',
                '#suffix' => '</div>',
            );

            $form[$key]['dreams_action_' . $key . '_' . $i] = array(
                '#type' => 'textfield',
                '#size' => 50,
                '#maxlength' => 1024,
                '#attributes' => array(
                    'placeholder' => t('Next action...')
                ),
                '#required' => FALSE,
                '#default_value' => 'Custom action',
                '#prefix' => '<div class="col-sm-4">',
                '#suffix' => '</div>',
            );

            $form[$key]['dreams_deadline_' . $key . '_' . $i] = array(
                '#type' => 'textfield',
                '#size' => 16,
                '#maxlength' => 16,
                '#attributes' => array(
                    'placeholder' => t('Deadline')
                ),
                '#required' => FALSE,
                '#default_value' => date('Y-m-d', strtotime('+1 month')),
                '#prefix' => '<div class="col">',
                '#suffix' => '</div></div>',
            );
        }
        $c = $c + $i;
    }

    foreach ($goals as $key => $goal) {
        $i = 0;
        foreach ($goal['goals'] as $k => $v) {
            $form[$key]['dreams_goal_' . $key . '_' . $i]['#default_value'] = $v['goal'];
            $form[$key]['dreams_percent_' . $key . '_' . $i]['#default_value'] = $v['percent'];
            $form[$key]['dreams_action_' . $key . '_' . $i]['#default_value'] = $v['action'];
            $form[$key]['dreams_deadline_' . $key . '_' . $i]['#default_value'] = $v['deadline'];
            $i++;
        }
    }

    $form['duid'] = array(
        '#type' => 'hidden',
        '#value' => $duid,
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Submit'),
        '#submit' => array('dreams_goals_form_submit'),
        '#attributes' => array('class' => array('btn-success', 'mt-1')),
        '#prefix' => '<div class="text-center">',
        '#suffix' => '</div></div></div>'
    );

    return $form;
}

/**
 * Validates PIN in the Drupal Form API fields.
 * @param type $element
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function dreams_element_validate_percent($element, &$form_state) {
    $value = check_plain(trim($element['#value']));
    if ($value < 0 || $value > 100 || !_dreams_is_int($value)) {
        form_error($element, t('%name must be integer beetween 0 and 100.', array('%name' => $element['#title'])));
    }
}

/**
 * Submit login form.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function dreams_goals_form_submit($form, &$form_state) {
    // Get user
    global $user;

    $categories = dreams_base_categories();
    $goals = [];

//    ddd($form_state['values'], true);

    foreach ($categories as $key => $category) {
        $goals[$key] = [];
        $goals[$key]['section'] = $category['section'];
        $goals[$key]['category'] = $key;
        $goals[$key]['label'] = $category['label'];
        $goals[$key]['color'] = $category['color'];

        foreach ($form_state['values'] as $k => $v) {
            $item = explode('_', $k);
            if ($item[0] == 'dreams') {
                if (!isset($goals[$key]['goals'][$item[3]])) {
                    $goals[$key]['goals'][$item[3]] = [];
                }
                if ($key == $item[2]) {
                    $goals[$key]['goals'][$item[3]][$item[1]] = $v;
                }
            }
        }
    }
//    ddd($goals, true);

    $duser = dreams_get_user_by_duid_assoc($form_state['values']['duid']);

    if ($duser == null) {
        $duser['uid'] = $user->uid;
        $duser['created_at'] = date('Y-m-d H:i:s');
    }
    $duser['goals'] = serialize($goals);
    $duser['updated_at'] = date('Y-m-d H:i:s');

    // Merge database
    db_merge('dreams_user')
            ->key(array('duid' => $duser['duid']))
            ->fields($duser)
            ->execute();

    // Redirect after the save.
    $form_state['redirect'] = dreams_redirect_form_to_goals($duser['duid']);
    // Print a message.
    drupal_set_message(t('Your goals updated successful.'));
    // Save to watchdog.
    watchdog('dreams', 'User goals merged: %duser.', array('%duser' => json_encode($duser), WATCHDOG_INFO));
}

/**
 * List user goals.
 * @param type $duid
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function dreams_goals_dashboard($duid) {
    global $user;

    $duser = dreams_get_user_by_duid(check_plain($duid));

    if ($duser == null) {
        $duser = dreams_get_user_by_uid($user->uid);
    }
    if ($duser == null) {
        drupal_set_message(t('You have no dreams data. Please fill base assessment, or goals form.'), 'error');
        dreams_redirect_to_base_assessment_form();
    }

    $goals = _dreams_is_serial($duser->goals) ? unserialize($duser->goals) : [];
    
    if (empty($goals)) {
        dreams_redirect_to_goals_edit($duid);
    }

    return theme('dreams_goals_dashboard', array(
        'duser' => $duser,
        'sections' => dreams_base_sections(),
        'categories' => dreams_base_categories(),
        'goals' => $goals,
    ));
}

/**
 * List user goals.
 * @param type $duid
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function dreams_life_assessment_log($duid) {
    global $user;

    $duser = dreams_get_user_by_duid(check_plain($duid));

    if ($duser == null) {
        $duser = dreams_get_user_by_uid($user->uid);
    }
    if ($duser == null) {
        drupal_set_message(t('You have no dreams data. Please fill base assessment, or goals form.'), 'error');
        dreams_redirect_to_base_assessment_form();
    }

    $assessment = _dreams_is_serial($duser->assessment) ? unserialize($duser->assessment) : [];
    $log = dreams_get_user_last_log($duser->duid);
    
    return theme('dreams_assessment_log', array(
        'duser' => $duser,
        'sections' => dreams_base_sections(),
        'categories' => dreams_base_categories(),
        'assessment' => $assessment,
        'log' => $log,
    ));
}

/**
 * Journal form.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function dreams_journal_form($form, &$form_state) {
    global $user;

    // Create a form.
    $intro = '<h1 class="text-center">' . t('Journal') . '</h1>'
            . '<p class="text-center">' . t('How do you feel today?') . '</p>';

    $duser = dreams_get_user_by_uid_assoc($user->uid);

    if (empty($duser)) {
        drupal_set_message(t('You have no dreams data. Please fill base assessment, or goals form.'), 'error');
        dreams_redirect_to_base_assessment_form();
    }

    $form['overview'] = array(
        '#markup' => $intro,
        '#prefix' => '<div class="row mt-30 justify-content-center"><div class="col-sm-8 col-sm-offset-2 mb-5">',
        '#suffix' => ''
    );

    $form['journal'] = array(
        '#title' => t('I am...'),
        '#type' => 'textarea',
        '#attributes' => array('rows' => 10),
        '#rows' => 10,
        '#required' => TRUE,
        '#default_value' => '',
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Save'),
        '#submit' => array('dreams_journal_form_submit'),
        '#attributes' => array('class' => array('btn-success', 'mt-1')),
        '#prefix' => '<div class="text-center">',
        '#suffix' => '</div></div></div>'
    );

    return $form;
}

/**
 * Submit login form.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function dreams_journal_form_submit($form, &$form_state) {
    // Get user
    global $user;

    $duser = dreams_get_user_by_uid($user->uid);

    $fields = [
        'duid' => $duser->duid,
        'journal' => $form_state['values']['journal'],
        'created_at' => date('Y-m-d H:i:s')
    ];

    // Insert database
    db_insert('dreams_journal')
            ->fields($fields)
            ->execute();

    // Redirect after the save.
    $form_state['redirect'] = dreams_redirect_form_to_journal($duser->duid);
    // Print a message.
    drupal_set_message(t('Your journal is created successful.'));
    // Save to watchdog.
    watchdog('dreams', 'User journal created: %duser.', array('%duser' => json_encode($fields), WATCHDOG_INFO));
}

/**
 * Habits form.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function dreams_habits_form($form, &$form_state, $duid) {
    global $user;

    // Create a form.
    $week = date('W');
    $intro = '<h1 class = "text-center">' . t('Habits') . '</h1>'
            . '<p class = "text-center">' . $week . '. ' . t('Week') . '</p>';

    $duser = dreams_get_user_by_duid($duid);

    if ($duser == null) {
        $duser = dreams_get_user_by_uid($user->uid);
    }
    if ($duser == null) {
        drupal_set_message(t('You have no dreams data. Please fill base assessment, or goals form.'), 'error');
        dreams_redirect_to_base_assessment_form();
    }

    $week = dreams_get_user_last_habits($duid);
    $journals = dreams_get_user_journals($duid);
    $habits = !empty($week) && _dreams_is_serial($week->habits) ? unserialize($week->habits) : [];

    $prefix = '<div class = "row mt-30 justify-content-center">'
            . '<div class = "col-sm-10 col-sm-offset-1 mb-5 habit-table table-responsive">';
    $suffix = '<table class = "table">'
            . '<thead class = "table-header">'
            . '<th class = "date-head">' . t('Habit') . '</th>'
            . '<th class = "date-head">' . drupal_ucfirst(t('Monday')) . '</th>'
            . '<th class = "date-head">' . drupal_ucfirst(t('Tuesday')) . '</th>'
            . '<th class = "date-head">' . drupal_ucfirst(t('Wednesday')) . '</th>'
            . '<th class = "date-head">' . drupal_ucfirst(t('Thursday')) . '</th>'
            . '<th class = "date-head">' . drupal_ucfirst(t('Friday')) . '</th>'
            . '<th class = "date-head">' . drupal_ucfirst(t('Saturday')) . '</th>'
            . '<th class = "date-head">' . drupal_ucfirst(t('Sunday')) . '</th>'
            . '<th class = "date-head">' . t('%') . '</th>'
            . '</thead>'
            . '<tbody>';

    $form['overview'] = array(
        '#markup' => $intro,
        '#prefix' => $prefix,
        '#suffix' => $suffix
    );

    $i = 0;
    $sum = 0; // Sum of used habit percents
    $c = 0; // Counts of used habits
    for ($i = 0; $i < 5; $i++) {

        $form['dreams_habit_' . $i . '_habit'] = array(
            '#type' => 'textfield',
            '#size' => 50,
            '#maxlength' => 1024,
            '#attributes' => array(
                'placeholder' => t('Write a habit...'),
                'class' => array('habit-text'),
            ),
            '#required' => FALSE,
            '#default_value' => '',
            '#prefix' => '<tr><td>',
            '#suffix' => '</td>',
        );

        $d = 1;
        for ($d = 1; $d < 8; $d++) {

            $form['dreams_habit_' . $i . '_' . $d] = array(
                '#type' => 'select',
                '#options' => array(
                    '' => '',
                    -1 => t('✘'),
                    0 => t('-'),
                    1 => t('✓'),
                ),
                '#attributes' => array(
                    'class' => array('custom-select', 'habit-value'),
                ),
                '#default_value' => "",
                '#prefix' => '<td>',
                '#suffix' => '</td>',
            );

            if (!empty($habits)) {
                if ($week->week == date('W')) {
                    $habits['habits'][$i]['habit'] != '' && $form['dreams_habit_' . $i . '_habit']['#default_value'] == '' ? $c++ : '';
                    $form['dreams_habit_' . $i . '_' . $d]['#default_value'] = $habits['habits'][$i][$d];
                }
                $form['dreams_habit_' . $i . '_habit']['#default_value'] = $habits['habits'][$i]['habit'];
            }
        }

        $form['dreams_habit_' . $i . '_percent'] = array(
            '#default_value' => '0',
            '#prefix' => '<td class="habit-percent">%',
            '#suffix' => '</td></tr>',
        );
        if (!empty($habits) && $week->week == date('W')) {
            $form['dreams_habit_' . $i . '_percent']['#prefix'] = '<td class="habit-percent">' . round(((float) $habits['habits'][$i]['percent'] * 100), 1) . '%';
            $sum = $sum + ((float) $habits['habits'][$i]['percent'] * 100);
        }
    }

    if ($c == 0) {
        $c = 1;
    }
    $footer = '<td class="habit-percent"></th>'
            . '<td class="habit-percent">' . (!empty($habits) && $week->week == date('W') ? round(((float) $habits['days'][1]['percent'] * 100), 1) : '') . t('%') . '</th>'
            . '<td class="habit-percent">' . (!empty($habits) && $week->week == date('W') ? round(((float) $habits['days'][2]['percent'] * 100), 1) : '') . t('%') . '</th>'
            . '<td class="habit-percent">' . (!empty($habits) && $week->week == date('W') ? round(((float) $habits['days'][3]['percent'] * 100), 1) : '') . t('%') . '</th>'
            . '<td class="habit-percent">' . (!empty($habits) && $week->week == date('W') ? round(((float) $habits['days'][4]['percent'] * 100), 1) : '') . t('%') . '</th>'
            . '<td class="habit-percent">' . (!empty($habits) && $week->week == date('W') ? round(((float) $habits['days'][5]['percent'] * 100), 1) : '') . t('%') . '</th>'
            . '<td class="habit-percent">' . (!empty($habits) && $week->week == date('W') ? round(((float) $habits['days'][6]['percent'] * 100), 1) : '') . t('%') . '</th>'
            . '<td class="habit-percent">' . (!empty($habits) && $week->week == date('W') ? round(((float) $habits['days'][7]['percent'] * 100), 1) : '') . t('%') . '</th>'
            . '<td class="habit-percent">' . (!empty($habits) && $week->week == date('W') ? round($sum / $c, 1) : '') . t('%') . '</th>';

    $script = '<script>(function ($) {'
            . '$(document).ready(function(){'
            . 'console.log("run");
    $(".habit-table select").each(function(){
        console.log($(this));
        if ($(this).val() == "-1") {
            $(this).addClass("select-dark");
            $(this).removeClass("select-success");
        } else if ($(this).val() == "1") {
            $(this).addClass("select-success");
            $(this).removeClass("select-dark");
        } else {
            $(this).removeClass("select-dark");
            $(this).removeClass("select-success");
        }
    });
    $(".habit-table select").change(function(){
        console.log($(this));
        if ($(this).val() == "-1") {
            $(this).addClass("select-dark");
            $(this).removeClass("select-success");
        } else if ($(this).val() == "1") {
            $(this).addClass("select-success");
            $(this).removeClass("select-dark");
        } else {
            $(this).removeClass("select-dark");
            $(this).removeClass("select-success");
        }
    });'
            . '});})(jQuery);'
            . '</script>';

    $form['footer'] = array(
        '#markup' => $footer,
        '#prefix' => '<tr>',
        '#suffix' => '</tr></tbody></table>' . $script,
    );

    $form['duid'] = array(
        '#type' => 'hidden',
        '#value' => $duser->duid,
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Update'),
        '#submit' => array('dreams_habits_form_submit'),
        '#attributes' => array('class' => array('btn-primary', 'mt-1')),
        '#prefix' => '<div class="text-center">',
        '#suffix' => '</div></div><div class="col-sm-10 col-sm-offset-1 mb-5">'
    );

    // Journal table

    $form['journal'] = array(
        '#markup' => '<h2 class="text-center">' . t('Journals') . '</h2>'
        . '<p class="text-center"><a href="/dreams/journal/add">' . t('Add new journal >>') . '</a></p>',
    );

    $header = array(
        array('data' => t('Day'), 'field' => 'created_at', 'sort' => 'desc'),
        array('data' => t('Journal'), 'field' => 'journal',),
    );

    $query = db_select('dreams_journal', 'j');
    $query->fields('j')
            ->condition('j.duid', $duid);
    $journals = $query->extend('PagerDefault')
            ->limit(10)
            ->extend('TableSort')
            ->orderByHeader($header)
            ->execute();

    $rows = array();

    foreach ($journals as $value) {
        $rows[] = array(
            'data' => array(
                '<div class="text-center">' . drupal_ucfirst(date('l', strtotime($value->created_at))) . '<br><small>(' . $value->created_at . ')</small></div>',
                $value->journal,
            )
        );
    }

    $form['table'] = array(
        '#theme' => 'table',
        '#header' => $header,
        '#rows' => $rows,
        '#empty' => t('There is no journal.'),
        '#attributes' => array('class' => array('mt-2 table table-striped table-bordered'))
    );
    $form['pager'] = array('#markup' => theme('pager'));

    $form['close'] = array(
        '#suffix' => '</div></div>',
    );

    return $form;
}

/**
 * Submit login form.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function dreams_habits_form_submit($form, &$form_state) {
    // Get user
    global $user;

    $duser = dreams_get_user_by_duid($form_state['values']['duid']);

    $habits = [
        'habits' => [],
        'days' => [],
    ];

    $days_percent = 0;
    $days_count = 0;
    $habits_percent = 0;
    $habits_count = 0;
    foreach ($form_state['values'] as $key => $value) {
        $item = explode('_', $key);
        if ($item[0] == 'dreams') {
            // Set habits list
            if (!isset($habits['habits'][$item[2]])) {
                $habits['habits'][$item[2]] = [
                    'percent' => 0,
                    'count' => 0,
                    'value' => 0
                ];
            }
            $habits['habits'][$item[2]][$item[3]] = $value;

            // Set days list
            if (!isset($habits['days'][$item[3]])) {
                $habits['days'][$item[3]] = [
                    'percent' => 0,
                    'count' => 0,
                    'value' => 0
                ];
            }
            if ($item[3] != 'habit') {
                $habits['days'][$item[3]][$item[2]] = $value;
            }

//            if ($value === '0' || $value === '1') {
            if ($value === '1') {
                $habits['habits'][$item[2]]['count'] ++;
                $habits['habits'][$item[2]]['value'] ++;
                if ($item[3] != 'habit') {
                    $habits['days'][$item[3]]['count'] ++;
                    $habits['days'][$item[3]]['value'] ++;
                }
            } else if ($value === '-1') {
                $habits['habits'][$item[2]]['count'] ++;
                if ($item[3] != 'habit') {
                    $habits['days'][$item[3]]['count'] ++;
                }
            }
            $habits['habits'][$item[2]]['percent'] = $habits['habits'][$item[2]]['value'] / ($habits['habits'][$item[2]]['count'] > 0 ? $habits['habits'][$item[2]]['count'] : 1);
            $habits['days'][$item[3]]['percent'] = $habits['days'][$item[3]]['value'] / ($habits['days'][$item[3]]['count'] > 0 ? $habits['days'][$item[3]]['count'] : 1);
        }
    }

    $fields = [
        'duid' => $duser->duid,
        'habits' => serialize($habits),
        'week' => date('W'),
        'year' => date('Y'),
        'created_at' => date('Y-m-d H:i:s')
    ];

    // Merge database
    db_merge('dreams_habits')
            ->key(array('duid' => $duser->duid, 'week' => $fields['week'], 'year' => $fields['year']))
            ->fields($fields)
            ->execute();

    // Redirect after the save.
    $form_state['redirect'] = dreams_redirect_form_to_journal($duser->duid);
    // Print a message.
    drupal_set_message(t('Your habits is updated successful.'));
    // Save to watchdog.
    watchdog('dreams', 'User habits merged: %duser.', array('%duser' => json_encode($fields), WATCHDOG_INFO));
}
