<?php

function callin_stat_form($form, &$form_state) {
    $products = db_query('SELECT pid, name FROM {membership_products}')->fetchAllKeyed();
    $callers = _callin_get_callers();

// Get params
    (isset($_GET['from'])) ? $from = $_GET['from'] : $from = '1970-01-01 00:00:00';
    (isset($_GET['to'])) ? $to = $_GET['to'] : $to = date('Y-m-d H:i:s');
    (isset($_GET['caller'])) ? $caller = $_GET['caller'] : $caller = '';

// Creating the search form.
    $form = array();

    $form['from'] = array(
        '#type' => 'textfield',
        '#title' => t('From date'),
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 254,
        '#prefix' => '<table><tr><td>',
        '#suffix' => '</td>',
        '#default_value' => $from,
    );

    $form['to'] = array(
        '#type' => 'textfield',
        '#title' => t('To date'),
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 254,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $to,
    );

    $form['caller'] = array(
        '#type' => 'select',
        '#title' => t('Caller'),
        '#options' => $callers,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $caller,
    );

    $form['submit'] = array(
        '#prefix' => '<td>',
        '#suffix' => '</td></tr></table>',
        '#type' => 'submit',
        '#value' => t('Search'),
    );

    $form['css'] = array(
        '#type' => 'item',
        '#markup' => '<style>table tr td:not(:first-child){text-align: right;}</style>'
    );


    // Creating the table
    $columns = array(
        array('data' => t('Caller'), 'field' => 'name', 'sort' => 'asc'),
        array('data' => t('Orders sum'), 'field' => 'sales',),
        array('data' => t('Pending orders')),
        array('data' => t('Paid orders'), 'field' => 'paid_orders',),
        array('data' => t('Orders/payed'), 'field' => 'paid_rate',),
        array('data' => t('Payments sum')),
        array('data' => t('Pending payments'), 'field' => 'pending_payments',),
        array('data' => t('Paid payments'), 'field' => 'paid_payments',),
        array('data' => t('Payments/payed'), 'field' => 'payment_rate',),
        array('data' => t('Orders Count'), 'field' => 'orders',),
        array('data' => t('Notes'), 'field' => 'notes',),
        array('data' => t('Average Order / Call'), 'field' => 'average_order',),
        array('data' => t('Income/Notes'), 'field' => 'income',),
    );

    $start_time = strtotime($from);
    $end_time = strtotime($to);


    $query = db_select('callin_orders', 'c');
    $query->join('users', 'u', 'c.calleruid = u.uid');
    $query->join('membership_orders', 'o', 'o.oid = c.oid');
    $query->condition('c.created', array($start_time, $end_time), 'BETWEEN');
    $query->groupBy('u.uid');
    $query->fields('u', array('uid', 'name'));
    $query->fields('o', array('price'));
    $query->addExpression('SUM(price)', 'sales');
    $query->addExpression('COUNT(price)', 'calls');
    if ($caller != 0) {
        $query->condition('calleruid', $caller);
    }
    $query = $query->extend('PagerDefault')
            ->limit(500)
            ->extend('TableSort')
            ->orderByHeader($columns);
    $users = $query->execute();


    $query = db_select('callin_orders', 'c');
    $query->join('users', 'u', 'c.calleruid = u.uid');
    $query->join('membership_orders', 'o', 'o.oid = c.oid');
    $query->condition('o.is_activated', 0, '!=');
    $query->groupBy('u.uid');
    $query->groupBy('o.pid');
    $query->fields('u', array('uid', 'name'));
    $query->fields('o', array('pid'));
    $query->addExpression('SUM(price)', 'income');
    $query->addExpression('SUM(commission)', 'commission');
    $query = $query->extend('PagerDefault')
            ->limit(50)
            ->extend('TableSort')
            ->orderByHeader($columns);
    $commissions = $query->execute()->fetchAll();

    $payments = [];
    foreach ($commissions as $commission) {
        if (!isset($payments[$commission->uid])) {
            $payments[$commission->uid] = [
                'uid' => $commission->uid,
                'name' => $commission->name,
                'income' => floatval($commission->commission)
//                'income' => (floatval($commission->income) * (floatval(variable_get('callin_product_commission_amount_' . $commission->pid)) / 100))
            ];
        } else {
            $payments[$commission->uid]['income'] = $payments[$commission->uid]['income'] + floatval($commission->commission);
        }
    }

    $datarows = array();

    foreach ($users as $value) {
        $paid_orders = db_query(''
                . 'SELECT '
                . 'SUM(o.price) AS sum_paid, '
                . 'COUNT(o.price) AS count_paid '
                . 'FROM {callin_orders} AS c '
                . 'JOIN {membership_orders} AS o '
                . 'ON o.oid = c.oid '
                . 'WHERE o.is_activated !=0 '
                . 'AND c.calleruid = :uid '
                . 'AND o.created < :end '
                . '', array(':uid' => $value->uid, ':end' => $end_time,))->fetchObject();

        $notes = db_query(''
                . 'SELECT '
                . 'COUNT(cnid) '
                . 'FROM {callin_notes} '
                . 'WHERE calleruid = :uid '
                . 'AND created BETWEEN :start AND :end'
                . '', array(':uid' => $value->uid, ':start' => $start_time, ':end' => $end_time,))->fetchField();

        $notes == 0 ? $notes = 1 : '';
        $value->calls == 0 ? $value->calls = 1 : '';

        if (!isset($payments[$value->uid])) {
            $payments[$value->uid] = [
                'uid' => $value->uid,
                'name' => $value->name,
                'income' => 0
            ];
        }

        $paid_payments = _callin_sum_payments($value->uid);
        $orders_pending_sum = $value->sales - $paid_orders->sum_paid < 0 ? 0 : $value->sales - $paid_orders->sum_paid;
        $orders_paid_sum = $value->sales - $paid_orders->sum_paid < 0 ? $value->sales : $paid_orders->sum_paid;

        $datarows[] = array(
            $value->name,
            _callin_price_nospace($value->sales),
            _callin_price_nospace($orders_pending_sum),
            _callin_price_nospace($orders_paid_sum),
            number_format($orders_paid_sum / $value->sales * 100, 0, ',', ' ') . '%',
            _callin_price_nospace($payments[$value->uid]['income']),
            _callin_price_nospace($payments[$value->uid]['income'] - $paid_payments < 0 ? 0 : $payments[$value->uid]['income'] - $paid_payments),
            _callin_price_nospace($paid_payments),
            $payments[$value->uid]['income'] == 0 ? number_format(0 * 100, 0, ',', ' ') . '%' : number_format($paid_payments / $payments[$value->uid]['income'] * 100, 0, ',', ' ') . '%',
            $value->calls,
            $notes,
            _callin_price_nospace($value->sales / $value->calls),
            _callin_price_nospace($orders_paid_sum / $notes),
        );
    }

    // Creating datatable
    // DataTable settings.
    $attributes['datatable_options'] = array(
        'bFilter' => TRUE,
        'bInfo' => TRUE,
        'aaSorting' => [[1, 'desc']],
        'sPaginationType' => "full_numbers",
        'bProcessing' => TRUE,
        "iDisplayLength" => 50,
        "sDom" => 'lfrtip',
        "aoColumns" => [
            null,
            ["sType" => "numeric-comma"],
            ["sType" => "numeric-comma"],
            ["sType" => "numeric-comma"],
            ["sType" => "numeric-comma"],
            ["sType" => "numeric-comma"],
            ["sType" => "numeric-comma"],
            ["sType" => "numeric-comma"],
            ["sType" => "numeric-comma"],
            ["sType" => "numeric-comma"],
            ["sType" => "numeric-comma"],
            ["sType" => "numeric-comma"],
            ["sType" => "numeric-comma"]
        ],
        "oLanguage" => [
            "sLengthMenu" => t("Show %menu rows per page", ['%menu' => '_MENU_']),
            "sZeroRecords" => t("Nothing found - sorry"),
            "sInfo" => t("Showing %start to %end of %total records", ['%start' => '_START_', '%end' => '_END_', '%total' => '_TOTAL_']),
            "sInfoEmpty" => t("Showing 0 to 0 of 0 records"),
            "sInfoFiltered" => t("(filtered from %max total records)", ['%max' => '_MAX_']),
            'oPaginate' => [
                'sFirst' => t('First'),
                'sLast' => t('Last'),
                'sNext' => t('Next'),
                'sPrevious' => t('Previous'),
            ],
            'sSearch' => t('Search:'),
        ]
    );

    drupal_add_js(base_path() . libraries_get_path('datatables') . '/plugins/sorting/numeric-comma.js', array(
        'type' => 'external',
        'scope' => 'header',
        'weight' => -1,
    ));
    // Define table columns
    $header = array();
    foreach ($columns as $col) {
        $col['datatable_options'] = array('bSortable' => TRUE, 'bSearchable' => TRUE,);
        unset($col['field']);
        if ($col['data'] == t('Operations')) {
            $col['datatable_options'] = array('bSortable' => FALSE, 'bSearchable' => FALSE,);
        }
        $header[] = $col;
    }

    // Render using Drupal's render API.
    if (empty($datarows)) {
        $datarows = [[]];
    }
    $form['datatable'] = array(
        '#theme' => 'datatable',
        '#header' => $header,
        '#rows' => $datarows,
        '#attributes' => $attributes,
    );

    return $form;
}

function callin_stat_form_submit($form, &$form_state) {
    // Save lots of typing
    $v = $form_state['values'];
    $form_state['redirect'] = array('admin/config/callin/stat',
        array('query' => array(
                'from' => $v['from'],
                'to' => $v['to'],
                'caller' => $v['caller'],
            ),
            'fragment' => '',),
    );
}
