<?php

function callin_orders_form($form, &$form_state) {
// Get all products.
    $products = db_query('SELECT pid, name FROM {membership_products}')->fetchAllKeyed();
    $filter_products = _callin_get_filtered_products();
    $filter_products[0] = t('Choose');
    ksort($filter_products);
    $filter_products['all'] = t('All');
    $all_products = db_query('SELECT pid FROM {membership_products}')->fetchCol();
    $callers = _callin_get_callers();

// Get params
    (isset($_GET['uid'])) ? $uid = $_GET['uid'] : $uid = '';
    (isset($_GET['caller'])) ? $caller = $_GET['caller'] : $caller = '';
    (isset($_GET['has_product'])) ? $has_product = $_GET['has_product'] : $has_product = '';
    (isset($_GET['not_has_product'])) ? $not_has_product = $_GET['not_has_product'] : $not_has_product = '';
    (isset($_GET['search'])) ? $search = check_plain($_GET['search']) : $search = '';

// Creating the search form.
    $form = array();

    $form['uid'] = array(
        '#type' => 'textfield',
        '#title' => t('User id'),
        '#prefix' => '<table><tr><td>',
        '#suffix' => '</td>',
        '#size' => 8,
        '#default_value' => $uid,
    );

    $form['search'] = array(
        '#type' => 'textfield',
        '#title' => t('Search'),
        '#attributes' => array('placeholder' => 'Name, email, phone'),
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#size' => 40,
        '#default_value' => $search,
    );

    $form['has_product'] = array(
        '#type' => 'select',
        '#title' => t('Has product'),
        '#options' => $filter_products,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $has_product,
    );

    $form['not_has_product'] = array(
        '#type' => 'select',
        '#title' => t('Not has product'),
        '#options' => $filter_products,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $not_has_product,
    );

    $form['caller'] = array(
        '#type' => 'select',
        '#title' => t('Caller'),
        '#options' => $callers,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $caller,
    );

    $form['submit'] = array(
        '#prefix' => '<td>',
        '#suffix' => '</td></tr></table>',
        '#type' => 'submit',
        '#value' => t('Search'),
    );

    $form['css'] = array(
        '#type' => 'item',
        '#markup' => '<style>table tr td:nth-child(7){text-align: right;}</style>'
    );

// Creating the table
    $columns = array(
        array('data' => t('User Id'), 'field' => 'id',),
        array('data' => t('Last name'), 'field' => 'lastname',),
        array('data' => t('First name'), 'field' => 'firstname',),
        array('data' => t('E-mail'), 'field' => 'email',),
        array('data' => t('Phone'), 'field' => 'phone',),
        array('data' => t('Products'), 'field' => 'product',),
        array('data' => t('Life time value (Ft)'), 'field' => 'sum',),
        array('data' => t('Last order date'), 'field' => 'created', 'sort' => 'desc'),
        array('data' => t('Last call')),
        array('data' => t('Last login')),
        array('data' => t('Operations')),
    );

// Build filter search where condition
    $where_vars = array();
    $where = '( 1=1 ';
    if ($caller != '' && $caller != 0 && $caller != 'none') {
        if (strlen($where) > 1) {
            $where .= ' AND ';
        }
        $where .= '(SELECT calleruid FROM {callin_notes} WHERE id = u.id ORDER BY created DESC LIMIT 0,1) LIKE :calleruid ';
        $where_vars[':calleruid'] = $caller;
    }
    if ($caller == 'none') {
        if (strlen($where) > 1) {
            $where .= ' AND ';
        }
        $where .= '(SELECT calleruid FROM {callin_notes} WHERE id = u.id ORDER BY created DESC LIMIT 0,1) IS NULL ';
    }
    if ($has_product != '' && $has_product != '0' && $has_product != 'all') {
        if (strlen($where) > 1) {
            $where .= ' AND ';
        }
        $where .= 'o.pids LIKE :has_products ';
        $where_vars[':has_products'] = '%' . $has_product . '%';
    }
    if ($has_product == 'all') {
        if (strlen($where) > 1) {
            $where .= ' AND ';
        }
        $where .= 'o.pids LIKE :has_products ';
        $where_vars[':has_products'] = '%' . implode($all_products, ',') . '%';
    }
    if ($not_has_product != '' && $not_has_product != '0' && $not_has_product != 'all') {
        if (strlen($where) > 1) {
            $where .= ' AND ';
        }
        $where .= 'o.pids NOT LIKE :not_has_product OR o.pids IS NULL ';
        $where_vars[':not_has_product'] = '%' . $not_has_product . '%';
    }
    if ($not_has_product == 'all') {
        if (strlen($where) > 1) {
            $where .= ' AND ';
        }
        $where .= 'o.pids IS NULL ';
    }
    if ($uid != '') {
        if (strlen($where) > 1) {
            $where .= ' AND ';
        }
        $where .= 'o.id LIKE :uid ';
        $where_vars[':uid'] = '%' . $uid . '%';
    }
    if ($search != '') {
        if (strlen($where) > 1) {
            $where .= ' AND ';
        }
        $where .= '( u.lastname LIKE :search OR u.firstname LIKE :search OR email LIKE :search OR phone LIKE :search ) ';
        $where_vars[':search'] = '%' . $search . '%';
    }
    $where .= ' )';

    $user_products = db_select('membership_orders', 'o');
    $user_products->condition('o.is_activated', '0', '!=');
    $user_products->groupBy('o.id');
    $user_products->fields('o', array('id'));
    $user_products->addExpression('CONCAT(GROUP_CONCAT(DISTINCT o.pid ORDER BY o.pid ASC SEPARATOR :sep), :sep)', 'pids', array(':sep' => ','));
    $user_products->addExpression('SUM(price)', 'sum');

    $query = db_select('membership_users', 'u')
            ->fields('u', array('id', 'uid', 'lastname', 'firstname', 'email', 'phone'));
    $query->leftJoin($user_products, 'o', '(u.id = o.id)', array());
    $query->fields('o', array('pids', 'sum'));
    $query->addExpression('(SELECT calleruid FROM {callin_notes} WHERE id = u.id ORDER BY created DESC LIMIT 0,1)', 'calleruid', array());
    $query = $query->extend('PagerDefault')
            ->limit(20)
            ->extend('TableSort')
            ->orderByHeader($columns)
            ->where($where, $where_vars);
    $users = $query->execute();
//    mdd($users->fetchAll());
//    mdd($users);

    $datarows = array();

    foreach ($users as $value) {
        $user_orders = _callin_get_user_orders($value->id);
        $last_login = _callin_get_last_login_date($value->uid);
        $last_call = _callin_get_last_call($value->id);

        $links = l(t('Own data'), 'sajat-adatok', array('query' => array('id' => $value->id), 'attributes' => array('target' => '_blank'))) . '&nbsp;|&nbsp;' .
                l(t('Call'), "admin/config/callin/$value->id/user", array('attributes' => array('target' => '_blank')));

        $datarows[] = array(
            $value->id,
            $value->lastname,
            $value->firstname,
            $value->email,
            $value->phone,
            _callin_format_user_orders($user_orders, $products),
            _callin_price($value->sum),
            end($user_orders) != null ? date('Y-m-d', end($user_orders)->created) : '',
            $last_call,
            ($last_login != 0) ? date('Y-m-d', $last_login) : 'Never logged in',
            $links,
        );
    }

    $form['table'] = array(
        '#theme' => 'table',
        '#header' => $columns,
        '#rows' => $datarows,
        '#empty' => t('Nincsenek találatok.'),
        '#attributes' => array('class' => array('table table-striped table-bordered table-condensed'))
    );
    $form['pager'] = array('#markup' => theme('pager'));

    return $form;
}

function callin_orders_form_submit($form, &$form_state) {
// Save lots of typing
    $v = $form_state['values'];
    $form_state['redirect'] = array('admin/config/callin/orders',
        array('query' => array(
                'caller' => $v['caller'],
                'has_product' => $v['has_product'],
                'not_has_product' => $v['not_has_product'],
                'uid' => $v['uid'],
                'search' => $v['search'],
            ),
            'fragment' => '',),
    );
}

function callin_follow_form($form, &$form_state) {
    $callers = _callin_get_callers();

// Get params
    (isset($_GET['uid'])) ? $uid = $_GET['uid'] : $uid = '';
    (isset($_GET['caller'])) ? $caller = $_GET['caller'] : $caller = '';
    (isset($_GET['search'])) ? $search = $_GET['search'] : $search = '';

// Creating the search form.
    $form = array();

    $form['uid'] = array(
        '#type' => 'textfield',
        '#title' => t('User id'),
        '#prefix' => '<table><tr><td>',
        '#suffix' => '</td>',
        '#size' => 8,
        '#default_value' => $uid,
    );

    $form['search'] = array(
        '#type' => 'textfield',
        '#title' => t('Search'),
        '#attributes' => array('placeholder' => 'Name, email, phone'),
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#size' => 40,
        '#default_value' => $search,
    );

    $form['caller'] = array(
        '#type' => 'select',
        '#title' => t('Caller'),
        '#options' => $callers,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $caller,
    );


    $form['submit'] = array(
        '#prefix' => '<td>',
        '#suffix' => '</td></tr></table>',
        '#type' => 'submit',
        '#value' => t('Search'),
    );

// Creating the table
    $columns = array(
        array('data' => t('User Id'), 'field' => 'id',),
        array('data' => t('Last name'), 'field' => 'lastname',),
        array('data' => t('First name'), 'field' => 'firstname',),
        array('data' => t('E-mail'), 'field' => 'email',),
        array('data' => t('Phone'), 'field' => 'phone',),
        array('data' => t('Follow up'), 'field' => 'followup', 'sort' => 'asc'),
        array('data' => t('Caller'), 'field' => 'callerid',),
        array('data' => t('Notes'), 'field' => 'note',),
        array('data' => t('Operations')),
    );

// Build filter search where condition
    $where_vars = array();
    $where = '(';
    if ($caller != '' && $caller != 0 && $caller != 'none') {
        $where .= '(SELECT calleruid FROM {callin_notes} WHERE id = u.id ORDER BY created DESC LIMIT 0,1) LIKE :calleruid ';
        $where_vars[':calleruid'] = $caller;
    }
    if ($caller == 'none') {
        if (strlen($where) > 1) {
            $where .= ' AND ';
        }
        $where .= '(SELECT calleruid FROM {callin_notes} WHERE id = u.id ORDER BY created DESC LIMIT 0,1) IS NULL ';
    }
    if ($uid != '') {
        if (strlen($where) > 1) {
            $where .= ' AND ';
        }
        $where .= 'o.id LIKE :uid ';
        $where_vars[':uid'] = '%' . $uid . '%';
    }
    if ($search != '') {
        if (strlen($where) > 1) {
            $where .= ' AND ';
        }
        $where .= '( u.lastname LIKE :search OR u.firstname LIKE :search OR email LIKE :search OR phone LIKE :search ) ';
        $where_vars[':search'] = '%' . $search . '%';
    }
    if (strlen($where) > 1) {
        $where .= ' AND ';
    }
    $where .= ' (SELECT c.cnid FROM {callin_notes} c WHERE c.id = u.id ORDER BY c.cnid DESC LIMIT 1) IS NOT NULL ';
    $where .= ' AND (SELECT c.followup FROM {callin_notes} c WHERE c.id = u.id ORDER BY c.cnid DESC LIMIT 1) != 0) ';


// Ide az utolsó followupok kellenek az adott megrendelőknél
    $query = db_select('membership_users', 'u')
            ->fields('u', array('id', 'lastname', 'firstname', 'email', 'phone'));
    $query->addExpression('(SELECT c.cnid FROM {callin_notes} c WHERE c.id = u.id ORDER BY c.cnid DESC LIMIT 1)', 'cnid', array());
    $query->addExpression('(SELECT c.followup FROM {callin_notes} c WHERE c.id = u.id ORDER BY c.cnid DESC LIMIT 1)', 'followup', array());
    $query->addExpression('(SELECT c.calleruid FROM {callin_notes} c WHERE c.id = u.id ORDER BY c.cnid DESC LIMIT 1)', 'calleruid', array());
    $query->addExpression('(SELECT c.note FROM {callin_notes} c WHERE c.id = u.id ORDER BY c.cnid DESC LIMIT 1)', 'note', array());
//    $query->leftJoin('callin_notes', 'cn', '(cn.id = u.id)');
//    $query->fields('cn', array('created'));
    $query->where($where, $where_vars);
    $query = $query->extend('PagerDefault')
            ->limit(20)
            ->extend('TableSort')
            ->orderByHeader($columns);
    $records = $query->execute();
//    cdd($records->fetchAll());

    $datarows = array();

    foreach ($records as $value) {
        if ($value->cnid != NULL && $value->followup != 0) {
            if ($caller != '' && $caller != 0) {
                if ($caller == $value->calleruid) {
                    $links = l(t('Own data'), 'sajat-adatok', array('query' => array('id' => $value->id))) . '&nbsp;|&nbsp;' . l(t('Call'), "admin/config/callin/$value->id/user");
                    $today_start = strtotime('00:00:00');
                    $today_end = strtotime('23:59:59');
                    $color = 'blue';
                    if ($value->followup > $today_end) {
                        $color = 'green';
                    }
                    if ($value->followup < $today_start) {
                        $color = 'red';
                    }

// if ($value->followup != 0) {
                    $datarows[] = array(
                        $value->id,
                        $value->lastname,
                        $value->firstname,
                        $value->email,
                        $value->phone,
                        '<span style="color: ' . $color . '" data-end="' . $today_end . '" data-start="' . $today_start . '" data-value="' . $value->followup . '" >' . date('Y-m-d H:i', $value->followup) . '</span>',
                        user_load($value->calleruid)->name,
                        $value->note,
                        $links,
                    );
//}
                }
            } else {
                $links = l(t('Own data'), 'sajat-adatok', array('query' => array('id' => $value->id))) . '&nbsp;|&nbsp;' . l(t('Call'), "admin/config/callin/$value->id/user");
                $today_start = strtotime('00:00:00');
                $today_end = strtotime('23:59:59');
                $color = 'blue';
                if ($value->followup > $today_end) {
                    $color = 'green';
                }
                if ($value->followup < $today_start) {
                    $color = 'red';
                }

// if ($value->followup != 0) {
                $datarows[] = array(
                    $value->id,
                    $value->lastname,
                    $value->firstname,
                    $value->email,
                    $value->phone,
                    '<span style="color: ' . $color . '" data-end="' . $today_end . '" data-start="' . $today_start . '" data-value="' . $value->followup . '" >' . date('Y-m-d H:i', $value->followup) . '</span>',
                    user_load($value->calleruid)->name,
                    $value->note,
                    $links,
                );
//}
            }
        }
    }

// Render using Drupal's render API.
    if (empty($datarows)) {
        $datarows = [[]];
    }

//    cdd($datarows);

    $form['table'] = array(
        '#theme' => 'table',
        '#header' => $columns,
        '#rows' => $datarows,
        '#empty' => t('Nincsenek találatok.'),
        '#attributes' => array('class' => array('table table-striped table-bordered table-condensed'))
    );
    $form['pager'] = array('#markup' => theme('pager'));

    return $form;
}

function callin_follow_form_submit($form, &$form_state) {
// Save lots of typing
    $v = $form_state['values'];
    $form_state['redirect'] = array('admin/config/callin/follow',
        array('query' => array(
                'uid' => $v['uid'],
//                'lastname' => $v['lastname'],
//                'firstname' => $v['firstname'],
//                'email' => $v['email'],
                'search' => $v['search'],
                'caller' => $v['caller'],
            ),
            'fragment' => '',),
    );
}
