<?php

/**
 * @file The global functions for the Certify module.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */

/**
 * Validate form element to a positive number.
 * @param type $element
 * @param type $form_state
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function callin_element_validate_positive_number($element, &$form_state) {
    if ($element['#value'] == '' || $element['#value'] < 0 || !_callin_is_int($element['#value'])) {
        form_error($element, t('%name mezőnek pozitív számnak kell lennie.', array('%name' => $element['#title'])));
    }
}

/**
 * Validate form element to a date value.
 * @param type $element
 * @param type $form_state
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function _callin_validate_date($element, &$form_state) {
    if (false === strtotime($element['#value']) && !empty($element['#value'])) {
        form_error($element, t('Invalid date!'));
    }
}

/**
 * @todo It must filter if the users givin chars not numbers.
 * @param type $element
 * @param type $form_state
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function _callin_validate_price($element, &$form_state) {
    $price = $element['#value'];
    if (!_callin_is_int($price) && $price != 0) {
        form_error($element, t('The price must be integer or zero.'));
    }
}

/**
 * Validate form element to percentage.
 * @param type $element
 * @param type $form_state
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function _callin_validate_commission($element, &$form_state) {
    $amount = $element['#value'];
    if (!empty($amount) && (!_callin_is_int(abs($amount)) || $amount < 1 || $amount > 100)) {
        form_error($element, t('The commission amount must be a positive integer between 1 and 100.'));
    }
}

/**
 * Validate payment form element.
 * @param type $element
 * @param type $form_state
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function callin_credit_amount_validate($element, &$form_state) {
    $amount = $element['#value'];
    if (!isset($amount) || $amount == 0 || !_callin_is_int(abs($amount))) {
        form_error($element, t('The amount must be an integer which is more or less then 0.'));
    }
}
