<?php

/**
 * @file The global functions for the Certify module.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */

/**
 * Easy look debug function.
 * @params type $var array.
 * @params type $json boolean flag.
 * @return string Formatted array tree.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function cdd($var, $json = FALSE) {
    if ($json) {
        header('Content-Type: application/json');
        echo drupal_json_output($var);
        exit();
    } else {
        echo '<pre>';
        print_r($var);
        echo '</pre>';
    }
}

function _callin_price($price) {
    return number_format($price, 0, ',', ' ') . ' Ft';
}

function _callin_price_nospace($price) {
    return number_format($price, 0, ',', '') . ' Ft';
}

function _callin_float_right($text) {
    return '<span style="float: right;">' . $text . '</span>';
}

/**
 * Check if a value is an integer.
 * @param mixed $variable The value.
 * @return boolean Returns TRUE if the value is an integer else returns FALSE.
 */
function _callin_is_int($variable) {
    return ctype_digit(strval($variable));
}

/**
 * Ha valódi az IP cím visszaadja, különben üres stringet kapunk.
 *
 * @return string
 * A visszadott ip cím, vagy üres string.
 *
 */
function _callin_get_real_ip() {
    $ip = $_SERVER['REMOTE_ADDR'];
    $ip = ip2long($ip);
    if ($ip !== false && $ip !== -1 && $ip !== 0) {
        $ip = long2ip($ip);
    } else {
        $ip = '';
    }
    return $ip;
}

function _callin_get_callers() {
    // Get all different user name and iud.
    $callers = db_query('SELECT uid, name FROM {users} AS u LEFT JOIN {callin_notes} AS c ON u.uid = c.calleruid WHERE c.calleruid IS NOT NULL')->fetchAllKeyed();
    $callers[0] = t('All');
    $callers['none'] = t('Not yet called');
    ksort($callers);
    return $callers;
}

function _callin_get_products() {
    $p = db_query('SELECT pid, name, price FROM {membership_products}')->fetchAll();
    foreach ($p as $v) {
        $products[$v->pid] = $v->name . ' (' . number_format($v->price, 0, ',', ' ') . ' Ft)';
    }
    return $products;
}

function _callin_get_products_list() {
    $products = db_select('membership_products', 'p')
            ->fields('p', ['pid', 'name'])
            ->execute()
            ->fetchAllKeyed();

    return $products;
}

function _callin_get_caller_name($uid) {
    return db_query_range('SELECT name FROM {users} WHERE uid = :uid', 0, 1, array(':uid' => $uid))->fetchField();
}

function _callin_get_user_orders($uid) {
    $orders = db_select('membership_orders', 'o')
            ->fields('o', ['pid', 'created', 'price', 'is_activated'])
            ->condition('id', $uid)
            ->execute()
            ->fetchAll();
    return $orders;
}

function _callin_get_user_has_products($uid) {
    $products = db_select('membership_orders', 'o')
            ->fields('o', ['pid'])
            ->condition('o.id', $uid)
            ->condition('o.is_activated', '0', '!=')
            ->execute()
            ->fetchCol();
    return $products;
}

//function _callin_get_user_has_products($uid) {
//    $products = db_select('membership_orders', 'o')
//            ->fields('o', ['pid'])
//            ->condition('o.id', $uid)
//            ->condition('o.is_activated', '0', '!=')
//            ->execute()
//            ->fetchCol();
//    return $products;
//}

function _callin_get_user_notes($uid) {
//    db_query('SELECT cnid, id, calleruid, created, note, followup FROM {callin_notes} WHERE id = :id ORDER BY created ASC', array(':id' => $id))->fetchAll();
    $notes = db_select('callin_notes', 'n')
            ->fields('n', ['cnid', 'id', 'calleruid', 'created', 'note', 'followup'])
            ->condition('id', $uid)
            ->orderBy('n.created')
            ->execute()
            ->fetchAll();
    return $notes;
}

function _callin_format_user_orders($user_orders, $products) {
    $html = '<small>' . PHP_EOL;
    foreach ($user_orders as $value) {
        if ($value->is_activated != 0) {
            $color = 'green';
            $date = ' @ ' . date('Y-m-d', $value->is_activated);
        } else {
            $color = 'red';
            $date = ' @ ' . date('Y-m-d', $value->created);
        }
        if (isset($products[$value->pid])) {
            $html .= "<span style=\"color: $color\">- " . $products[$value->pid] . " <span style=\"float: right;\">$value->price&nbsp;Ft <em>$date</em></span></span><br/>" . PHP_EOL;
        } else {
            $html .= "<span style=\"color: $color\">- " . t('Deleted product') . " <span style=\"float: right;\">$value->price&nbsp;Ft <em>$date</em></span></span><br/>" . PHP_EOL;
        }
    }
    $html .= '</small>';

    return $html;
}

function _callin_get_user_data_object($uid) {
//    $user = db_query_range('SELECT lastname, firstname, email, phone, zip, city, address, hash FROM {membership_users} WHERE id = :id', 0, 1, array(':id' => $id))->fetchObject();
    $user = db_select('membership_users', 'u')
            ->fields('u', ['lastname', 'firstname', 'email', 'phone', 'zip', 'city', 'address', 'hash'])
            ->condition('id', $uid)
            ->execute()
            ->fetchObject();
    return $user;
}

function _callin_get_user_header($id) {
    $products = _callin_get_products_list();
    $user_orders = _callin_get_user_orders($id);
    $user = _callin_get_user_data_object($id);
    $html = "<h1>$user->lastname $user->firstname <span style=\"color:grey; font-size:75%;\"><br>$user->phone<br>$user->email</span></h1><hr>";
    $html .= _callin_format_user_orders($user_orders, $products) . '<hr><hr>';
    return $html;
}

function _callin_get_caller_header($id) {
    $account = user_load($id);
    $html = "<h1>$account->name <span style=\"color:grey; font-size:75%;\"><br>$account->mail</span></h1><hr>";
    return $html;
}

function _callin_get_filtered_products() {
    $show_product = variable_get('callin_show_products', array());

    $p = db_query('SELECT pid, name, price FROM {membership_products}')->fetchAll();
    foreach ($p as $v) {
        if ($show_product[$v->pid] != 0) {
            $products[$v->pid] = $v->name . ' (' . number_format($v->price, 0, ',', ' ') . ' Ft)';
        }
    }
    return $products;
}

function _callin_get_last_order_date($user_orders) {
    $min = 0;
    foreach ($user_orders as $value) {
        if ($min = 0 || $min > $value->created) {
            $min = $value->created;
        }
    }
    return $min;
}

function _callin_get_last_login_date($uid) {
    return db_query_range('SELECT login FROM {users} WHERE uid = :uid', 0, 1, array(':uid' => $uid))->fetchField();
}

function _callin_get_last_call($id) {
    $last_call = db_query_range(''
            . 'SELECT c.calleruid, c.created, u.name '
            . 'FROM {callin_notes} AS c '
            . 'JOIN {users} AS u '
            . 'ON c.calleruid = u.uid '
            . 'WHERE c.id = :id '
            . 'ORDER BY c.created DESC'
            , 0, 1, array(':id' => $id))->fetchObject();
    if (empty($last_call)) {
        $text = t('Not yet called');
    } else {
        $text = $last_call->name . ' <span style=\"float: right;\"><em>@ ' . date('Y-m-d') . '</em></span>';
    }
    return $text;
}

function _callin_get_last_caller($id) {
    $last_call = db_query_range(''
            . 'SELECT c.calleruid, c.created, u.name '
            . 'FROM {callin_notes} AS c '
            . 'JOIN {users} AS u '
            . 'ON c.calleruid = u.uid '
            . 'WHERE c.id = :id '
            . 'ORDER BY c.created DESC'
            , 0, 1, array(':id' => $id))->fetchObject();
    return $last_call;
}

function _callin_get_last_caller_formatter($last_call) {
    if (empty($last_call)) {
        $text = t('Not yet called');
    } else {
        $text = $last_call->name . ' <span style=\"float: right;\"><em>@ ' . date('Y-m-d') . '</em></span>';
    }
    return $text;
}

function _callin_sum_user_orders($user_orders) {
    $sum = 0;
    foreach ($user_orders as $value) {
        if ($value->is_activated != 0) {
            $sum = $sum + $value->price;
        }
    }
    return $sum;
}

function _callin_sum_payments($uid) {
    return db_query('SELECT SUM(amount) FROM {callin_payments} WHERE calleruid = :uid', array(':uid' => $uid))->fetchField();
}

function callin_email_send($name, $email, $product_name, $proforma_link, $sign) {
    $subject = 'Telefonbeszélgetés';
    $message = 'Szia,' . PHP_EOL . PHP_EOL;
    $message .= 'Jó volt beszélni veled telefonon!' . PHP_EOL . PHP_EOL;
    $message .= 'Ahogy megbeszéltük, leadtam egy megrendelést neked.' . PHP_EOL . PHP_EOL;
    $message .= 'A fizetési adatokat a díjbekérő levélen találod, amit ezen a' . PHP_EOL;
    $message .= 'linken érsz el:' . PHP_EOL;
    $message .= $proforma_link . PHP_EOL . PHP_EOL;
    $message .= 'Kérlek, a közleményben feltétlenül tüntesd fel a díjbekérő levél' . PHP_EOL;
    $message .= 'alján található azonosítót. Ezzel nagyon megkönnyíted a munkánkat.' . PHP_EOL . PHP_EOL;
    $message .= 'Ha bármilyen kérdésed vagy nehézséged van, válaszolj erre az e-mailre,' . PHP_EOL;
    $message .= 'nagyon szívesen válaszolunk a kérdéseidre.' . PHP_EOL . PHP_EOL;
    $message .= 'Találkozunk az oldalon! :)' . PHP_EOL . PHP_EOL;
    $message .= 'Üdv, ' . $sign . PHP_EOL . PHP_EOL;

    $settings_mail_from_name = variable_get('membership_mail_from_name');
    $settings_mail_from_email = variable_get('membership_mail_from_email');

    $to = '"' . '=?UTF-8?B?' . base64_encode($name) . '?=' . '" <' . $email . '>';

    $header = 'MIME-Version: 1.0' . PHP_EOL;
    $header .= 'Content-type: text/plain; format=flowed; charset="UTF-8"' . PHP_EOL;
    $header .= 'Content-Transfer-Encoding: 8bit' . PHP_EOL;
    $header .= 'From: "' . '=?UTF-8?B?' . base64_encode($settings_mail_from_name) . '?=' . '" <' . $settings_mail_from_email . '>' . PHP_EOL;
    $header .= 'Reply-To: ' . $settings_mail_from_email . PHP_EOL;
    $header .= 'Return-Path: ' . $settings_mail_from_email . PHP_EOL;
    $header .= 'X-Mailer: PHP-' . phpversion() . PHP_EOL;

    mail($to, '=?UTF-8?B?' . base64_encode($subject) . '?=', $message, $header);
}
