<?php

/**
 * @file
 * A horoszkóp listázó nézet.
 */

function astro_table_search_form_create($form, &$form_state) {
    
    // A paraméterek beolvasása.
    if (isset($_GET['id']))        $id        = $_GET['id'];        else $id=''; 
    if (isset($_GET['name']))      $name      = $_GET['name'];      else $name='';
    if (isset($_GET['city']))      $city      = $_GET['city'];      else $city=''; 
    if (isset($_GET['from']))      $from      = $_GET['from'];      else $from='';
    if (isset($_GET['to']))        $to        = $_GET['to'];        else $to='';
    if (isset($_GET['status']))    $status    = $_GET['status'];    else $status='';
    if (isset($_GET['type']))      $type      = $_GET['type'];      else $type='';

    // Státuszlista
    $states = [
        ''=> t('All'),
        '0' => t('In progress'),
        '1' => t('Ready'),
        '2' => t('Ready, email sent')
    ];
    
    // Típus lista
    $types = [
        ''=> t('All'),
        'natal' => t('Natal'),
        'synastry' => t('Synastry'),
        'transit' => t('Progression')
    ];

    $form = array();

    $form['id'] = array(
      '#type'        => 'textfield',
      '#title'       => 'ID',
      '#required'    => FALSE,
      '#size'        => 16,
      '#maxlength'   => 10, 
      '#prefix'      => '<table><tr><td>',
      '#suffix'      => '</td>',
      '#default_value' => $id,
    );

    $form['name'] = array(
      '#type'        => 'textfield',
      '#title'       => t('Name'),
      '#required'    => FALSE,
      '#size'        => 16,
      '#maxlength'   => 254,
      '#prefix'      => '<td>',
      '#suffix'      => '</td>',
      '#default_value' => $name,
    );

    $form['city'] = array(
      '#type'        => 'textfield',
      '#title'       => t('City'),
      '#required'    => FALSE,
      '#size'        => 16,
      '#maxlength'   => 254,
      '#prefix'      => '<td>',
      '#suffix'      => '</td>',
      '#default_value' => $city,
    );

//    $form['from'] = array(
//      '#type'        => 'textfield',
//      '#title'       => t('Ettől a dátumtól'),
//      '#required'    => FALSE,
//      '#size'        => 16,
//      '#maxlength'   => 64,
//      '#prefix'      => '<td>',
//      '#suffix'      => '</td>',
//      '#default_value' => $from,
//    );
//
//    $form['to'] = array(
//      '#type'        => 'textfield',
//      '#title'       => t('Eddig a dátumig'),
//      '#required'    => FALSE,
//      '#size'        => 16,
//      '#maxlength'   => 64,
//      '#prefix'      => '<td>',
//      '#suffix'      => '</td>',
//      '#default_value' => $to,
//    );

    $form['type'] = array(
      '#type'    => 'select',
      '#title'   => t('Type'),
      '#prefix'  => '<td>',
      '#suffix'  => '</td>',
      '#options' => $types,
      '#default_value' => $type,
    );

    $form['status'] = array(
      '#type'    => 'select',
      '#title'   => t('Status'),
      '#prefix'  => '<td>',
      '#suffix'  => '</td>',
      '#options' => $states,
      '#default_value' => $status,
    );
    
    return $form;
}

/**
 * A megrendelők listázása.
 */
function astro_natal_list_form($form, &$form_state) {
    global $user;
    
    // A paraméterek beolvasása.
    if (isset($_GET['id']))        $id        = $_GET['id'];        else $id=''; 
    if (isset($_GET['name']))      $name      = $_GET['name'];      else $name='';
    if (isset($_GET['city']))      $city      = $_GET['city'];      else $city=''; 
    if (isset($_GET['from']))      $from      = $_GET['from'];      else $from='';
    if (isset($_GET['to']))        $to        = $_GET['to'];        else $to='';
    if (isset($_GET['status']))    $status    = $_GET['status'];    else $status='';

    // Beolvassa a termékek listáját
    $states = [
        ''=> t('All'),
        '0' => t('In progress'),
        '1' => t('Ready'),
        '2' => t('Ready, email sent')
    ];

    $form = astro_table_search_form_create($form, $form_state);

    $form['submit'] = array(
        '#prefix'     => '<td><div style="margin: 36px auto auto 15px;">',
        '#suffix'     => '</div></td></tr></table>',
        '#type'       => 'submit',
        '#value'      => t('Search'),
    );

    // Tábla elkészítése
    $header = array(
      array('data' => t('ID'), 'field' => 'id',),
      array('data' => t('OID'), 'field' => 'oid',),
      array('data' => t('Name'), 'field' => 'name',),
      array('data' => t('City'), 'field' => 'city',),
      array('data' => t('Birthdate'), 'field' => 'datetime','sort' => 'desc'),
      array('data' => t('Status'), 'field' => 'status',),
      array('data' => t('Operations')),
    );

    $tsfrom = strtotime($from);
    $tsto   = strtotime($to);

    $muser = membership_user_details_object_by_uid($user->uid);

    $query = db_select('membership_orders', 'o')
          ->fields('o', ['oid', 'is_activated'])
          ->condition('id', $muser->id)
          ->condition('is_activated', 0, '>');
    $query->join('astro_natal','n', 'n.oid = o.oid');
    $query->fields('n');
    $query->join('astro_horoscope','h', 'h.hid = n.hid');
    $query->fields('h');
    if ($id!='') {
        $query->condition('n.nid', "%$id%", 'LIKE');
    }
    if ($name!='') {
        $query->condition('h.name', "%$name%", 'LIKE');
    }
    if ($city!='') {
        $query->condition('h.city', "%$city%", 'LIKE');
    }
//    if ($from!='') {
//      $query->condition('o.created', $tsfrom, '<');
//    }
//    if ($to!='') {
//      $query->condition('o.created', $tsto, '>');
//    }
    if ($status!='') {
      $query->condition('n.status', $status, '=');
    }
    
//    add(strtr($query->__toString(), $query->arguments()), true);
    
    $natals = $query->extend('PagerDefault')
      ->limit(variable_get('membership_list_limit_users'))
      ->extend('TableSort')
      ->orderByHeader($header)
      ->execute();

    $page = _astro_get_page();
    $rows = array();

    foreach ($natals as $value) {
      $links = l(t('Megtekintés'), 'astro/natal/view/' . $value->nid, array('query'=>array('oid' => $value->oid)));

//      switch ($value->is_sent) {
//        case 0:
//          //$is_sent = 'Kiküldésre vár';
//          $is_sent = l(t('Kiküldésre vár'), 'admin/config/membership/change_check',array('query'=>array('id' => $value->id, 'page' => $page)));
//          break;
//        case 1:
//          //$is_sent = 'Kiküldve';
//          $is_sent = l(t('Kiküldve'), 'admin/config/membership/change_check',array('query'=>array('id' => $value->id, 'page' => $page)));
//          break;
//        case 3:
//          $is_sent = 'Nem csekkes';
//          break;
//      }
      $rows[]= array(
        'data' => array(
          $value->nid,
          $value->oid,
          $value->name,
          $value->city,
          $value->datetime,
          $states[$value->status],
          $links,
        )
      );
    }  

    $form['table'] = array(
      '#theme' => 'table',
      '#header' => $header,
      '#rows' => $rows,
      '#empty' => t('Nincsenek találatok.'),
      '#attributes' => array('class' => array('table table-striped table-bordered table-condensed'))
    );
    $form['pager'] = array('#markup' => theme('pager'));

    return $form;
}

function astro_natal_list_form_submit($form, &$form_state) {
    $form_state['redirect'] = array('astro/natal/list',
        array('query' => array(
            'id' => $form_state['values']['id'],
            'name' => $form_state['values']['name'],
            'city' => $form_state['values']['city'],
//            'from' => $form_state['values']['from'],
//            'to' => $form_state['values']['to'],
            'status' => $form_state['values']['status'],
        ),
        'fragment' => '',),
    );
}


/**
 * Az összes horoszkóp rendelés listázása
 */
function astro_all_list_form($form, &$form_state) {
    global $user;
    
    $natalProducts = variable_get('astro_natal_product_ids');
    $synastryProducts = variable_get('astro_synastry_product_ids');
    $transitProducts = variable_get('astro_transit_product_ids');
    
    // A paraméterek beolvasása.
    if (isset($_GET['id']))        $id        = $_GET['id'];        else $id=''; 
    if (isset($_GET['hid']))       $hid       = $_GET['hid'];       else $hid=''; 
    if (isset($_GET['name']))      $name      = $_GET['name'];      else $name='';
    if (isset($_GET['city']))      $city      = $_GET['city'];      else $city=''; 
    if (isset($_GET['from']))      $from      = $_GET['from'];      else $from='';
    if (isset($_GET['to']))        $to        = $_GET['to'];        else $to='';
    if (isset($_GET['status']))    $status    = $_GET['status'];    else $status='';
    if (isset($_GET['type']))      $type      = $_GET['type'];      else $type='';

    // Beolvassa a termékek listáját
    $states = [
        ''=> t('All'),
        '0' => t('In progress'),
        '1' => t('Ready'),
        '2' => t('Ready, email sent')
    ];
    
    // Típus lista
    $types = [
        ''=> t('All'),
        'natal' => t('Natal'),
        'synastry' => t('Synastry'),
        'transit' => t('Progression')
    ];

    $form = astro_table_search_form_create($form, $form_state);

    $form['submit'] = array(
        '#prefix'     => '<td><div style="margin: 36px auto auto 15px;">',
        '#suffix'     => '</div></td></tr></table>',
        '#type'       => 'submit',
        '#value'      => t('Search'),
    );

    // Tábla elkészítése
    $header = array(
      array('data' => t('OID'), 'field' => 'oid'),
      array('data' => t('ID'), 'field' => 'id','sort' => 'desc'),
      array('data' => t('Name'), 'field' => 'name',),
      array('data' => t('City'), 'field' => 'city',),
      array('data' => t('Birthdate'), 'field' => 'birth',),
      array('data' => t('Type'), 'field' => 'type',),
      array('data' => t('Status'), 'field' => 'status',),
      array('data' => t('Operations')),
    );

    $tsfrom = strtotime($from);
    $tsto   = strtotime($to);

    $query = db_select('astro_horoscope_orders', 'o')
          ->fields('o')
          ->condition('o.uid', $user->uid);
    if ($id!='') {
        $query->condition('o.id', "%$id%", 'LIKE');
    }
    if ($hid!='') {
        $query->condition('o.hid', "%$hid%", 'LIKE');
    }
    if ($name!='') {
        $query->condition('o.name', "%$name%", 'LIKE');
    }
    if ($city!='') {
        $query->condition('o.city', "%$city%", 'LIKE');
    }
    if ($type!='') {
      $query->condition('o.type', $type, '=');
    }
    if ($status!='') {
//        $or = db_or();
//        $or->condition('o.nstatus', $status, '=');
//        $or->condition('o.sstatus', $status, '=');
//        $or->condition('o.tstatus', $status, '=');
//        $query->condition($or);
        $query->condition('o.status', $status, '=');
    }
    
    $natals = $query->extend('PagerDefault')
      ->limit(variable_get('membership_list_limit_users'))
      ->extend('TableSort')
      ->orderByHeader($header)
      ->execute();

    $page = _astro_get_page();
    $rows = array();

    foreach ($natals as $value) {
        
      if ($value->id != null) {
        $links = l(t('View'), 'astro/' . $value->type . '/view/' . $value->id, array('query'=>array('oid' => $value->oid)));
      } else {
//        $links = l(t('Horoscope'), 'astro/horoscope/create', array('query'=>array('oid' => $value->oid))) . '&nbsp;|&nbsp;';
//        $links .= l(t('Sysanstry'), 'astro/synastry/create', array('query'=>array('oid' => $value->oid))) . '&nbsp;|&nbsp;';
//        $links .= l(t('Progression'), 'astro/transit/create', array('query'=>array('oid' => $value->oid)));
        
        switch ($value->pid) {
            case in_array($value->pid, array_values($natalProducts)):
              $links = l(t('Create Horoscope'), 'astro/horoscope/create', array('query'=>array('oid' => $value->oid)));
              break;
            case in_array($value->pid, array_values($synastryProducts)):
              $links = l(t('Create Sysanstry'), 'astro/synastry/create', array('query'=>array('oid' => $value->oid)));
              break;
            case in_array($value->pid, array_values($transitProducts)):
              $links = l(t('Create Progression'), 'astro/transit/create', array('query'=>array('oid' => $value->oid)));
              break;
        }
      }      
              
      $rows[]= array(
        'data' => array(
          $value->oid,
          $value->id == null ? '-' : $value->id,
          $value->name == null ? '-' : $value->name,
          $value->city == null ? '-' : $value->city,
          $value->birth == null ? '-' : $value->birth,
          $value->type == null ? '-' : $types[$value->type],
          $value->status == null ? '-' : $states[$value->status],
          $links,
        )
      );
    }  

    $form['table'] = array(
      '#theme' => 'table',
      '#header' => $header,
      '#rows' => $rows,
      '#empty' => t('Nincsenek találatok.'),
      '#attributes' => array('class' => array('table table-striped table-bordered table-condensed'))
    );
    $form['pager'] = array('#markup' => theme('pager'));

    return $form;
}

function astro_all_list_form_submit($form, &$form_state) {
    $form_state['redirect'] = array('astro/orders/list',
        array('query' => array(
            'id' => $form_state['values']['id'],
            'name' => $form_state['values']['name'],
            'city' => $form_state['values']['city'],
            'status' => $form_state['values']['status'],
            'type' => $form_state['values']['type'],
        ),
        'fragment' => '',),
    );
}

/**
 * Az összes horoszkóp rendelés listázása
 */
function astro_horoscope_list_form($form, &$form_state) {
    global $user;
    
    // A paraméterek beolvasása.
    if (isset($_GET['hid']))       $hid       = $_GET['hid'];       else $hid=''; 
    if (isset($_GET['name']))      $name      = $_GET['name'];      else $name='';
    if (isset($_GET['city']))      $city      = $_GET['city'];      else $city=''; 
    if (isset($_GET['from']))      $from      = $_GET['from'];      else $from='';
    if (isset($_GET['to']))        $to        = $_GET['to'];        else $to='';

    $form = astro_table_search_form_create($form, $form_state);
    
    unset($form['type']);
    unset($form['state']);

    $form['submit'] = array(
        '#prefix'     => '<td><div style="margin: 36px auto auto 15px;">',
        '#suffix'     => '</div></td></tr></table>',
        '#type'       => 'submit',
        '#value'      => t('Search'),
    );

    // Tábla elkészítése
    $header = array(
      array('data' => t('HID'), 'field' => 'hid','sort' => 'asc'),
      array('data' => t('Name'), 'field' => 'name',),
      array('data' => t('City'), 'field' => 'city',),
      array('data' => t('Birthdate'), 'field' => 'datetime',),
      array('data' => t('Operations')),
    );

    $tsfrom = strtotime($from);
    $tsto   = strtotime($to);

    $query = db_select('astro_horoscope', 'h')
          ->fields('h')
          ->condition('h.uid', $user->uid);
    if ($hid!='') {
        $query->condition('h.hid', "%$hid%", 'LIKE');
    }
    if ($name!='') {
        $query->condition('h.name', "%$name%", 'LIKE');
    }
    if ($city!='') {
        $query->condition('h.city', "%$city%", 'LIKE');
    }
    if ($from!='') {
      $query->condition('h.datatime', $tsfrom, '<');
    }
    if ($to!='') {
      $query->condition('h.datatime', $tsto, '>');
    }
    
    $persons = $query->extend('PagerDefault')
      ->limit(variable_get('membership_list_limit_users'))
      ->extend('TableSort')
      ->orderByHeader($header)
      ->execute();

    $page = _astro_get_page();
    $rows = array();

    foreach ($persons as $value) {
        
      if ($value->hid != null) {
        $links = l(t('Horoscopes'), 'astro/orders/list', array('query'=>array('hid' => $value->hid)));
      } else {
        $links = l(t('Horoscope'), 'astro/horoscope/create', array('query'=>array('oid' => $value->oid))) . '&nbsp;|&nbsp;';
        $links .= l(t('Sysanstry'), 'astro/synastry/create', array('query'=>array('oid' => $value->oid))) . '&nbsp;|&nbsp;';
        $links .= l(t('Progression'), 'astro/transit/create', array('query'=>array('oid' => $value->oid)));
      }      
              
      $rows[]= array(
        'data' => array(
          $value->hid,
          $value->name,
          $value->city,
          $value->datetime,
          $links,
        )
      );
    }  

    $form['table'] = array(
      '#theme' => 'table',
      '#header' => $header,
      '#rows' => $rows,
      '#empty' => t('Nincsenek találatok.'),
      '#attributes' => array('class' => array('table table-striped table-bordered table-condensed'))
    );
    $form['pager'] = array('#markup' => theme('pager'));

    return $form;
}

function astro_horoscope_list_form_submit($form, &$form_state) {
    $form_state['redirect'] = array('astro/orders/list',
        array('query' => array(
            'id' => $form_state['values']['id'],
            'name' => $form_state['values']['name'],
            'city' => $form_state['values']['city'],
            'from' => $form_state['values']['from'],
            'to' => $form_state['values']['to']
        ),
        'fragment' => '',),
    );
}