<?php

/**
 * @file
 * A horoszkóp adatokat begyűjtő funkciók.
 */

function astro_create_form($form, &$form_state, $prefix = '') {
    global $user;
    
    $form = [];
    $countries = [];
    
    if (module_exists('countries')) {
        $countries = db_select('countries_country', 'cc')
                ->fields('cc')
                ->execute()
                ->fetchAllKeyed(2, 3);
    }

    $text = '';
    
    $form[$prefix . 'description'] = array(
        '#type' => 'item',
        '#markup' => $text,
    );

    $form['oid'] = array(
        '#type' => 'hidden',
        '#value' => isset($_GET['oid']) ? check_plain(trim($_GET['oid'])) : 0,
    );

    $form['uid'] = array(
        '#type' => 'hidden',
        '#value' => $user->uid,
    );

    $form[$prefix . 'name'] = array(
        '#title' => t('Teljes név'),
        '#type' => 'textfield',
        '#required' => TRUE,
    );
    
    $form[$prefix . 'datetime'] = array(
        '#title' => t('Születési dátum'),
        '#description' => t('Mikor születtél év, hónap, nap, óra, perc?'),
        '#type'        => 'date_popup',
        '#date_format' => 'Y-m-d H:i',
        '#timepicker'  => 'timepicker',
        '#timepicker_options' => array(
          'rows' => 4,
          'minutes' => array(
            'starts' => 0,
            'ends' => 55,
            'interval' => 5,
          ),
          'showCloseButton' => TRUE,
          'closeButtonText' => t('Close'),
          'showNowButton'   => t('Now'),
          'atPosition'      => 'left bottom',
          'showPeriodLabels'=> FALSE
        ),
        '#required'    => TRUE,
        '#default_value' => date('Y-m-d H:i')
    );

    $form[$prefix . 'country'] = array(
        '#title' => t('Születési ország'),
        '#type' => 'select',
        '#options' => $countries,
        '#required' => TRUE,
        '#default_value' => 'HUN',
    );

    $form[$prefix . 'city'] = array(
        '#title' => t('Város'),
        '#type' => 'textfield',
        '#required' => TRUE,
        '#default_value' => '',
    );

    $form[$prefix . 'clearfix'] = array(
        '#type' => 'item',
        '#markup' => '',
    );

    return $form;
}

function astro_natal_form($form, &$form_state) {
    global $user;
    
    $form = astro_create_form($form, $form_state);

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => 'Beküldés',
        '#validate' => array('astro_natal_form_validate'),
        '#submit' => array('astro_natal_form_submit'),
    );

    return $form;
}

function astro_natal_form_validate($form, &$form_state) {
//    $price = trim($form_state['values']['price']);
//    if (!is_numeric($price) || $price < 0 || $price != round($price)) {
//      // Ha nem pozitív egész hibaüzenetet adunk vissza.
//      form_set_error('price', t('A fizetendő összegnek pozitív egész számnak kell lennie.'));
//    }
    
    $country = trim($form_state['values']['country']);
    $city = trim($form_state['values']['city']);
    
    // Get coords
    $countries = db_select('countries_country', 'cc')->fields('cc')->execute()->fetchAllKeyed(2, 3);
    $geo = geocoder('openstreetmap_nominatim', $countries[$country] . ' ' . $city);
    if ($geo == null) {
        // Ha nincs koordináta
        form_set_error('city', t('Az ország és város párosításához nem található koordináta.'));
    }
}

function astro_natal_form_submit($form, &$form_state) {
    $uid = trim(check_plain($form_state['values']['uid']));
    $oid = trim(check_plain($form_state['values']['oid']));
    
    $hid = astro_merge_horoscope($form_state);
    
    $natal = [
        'oid' => $oid,
        'uid' => $uid,
        'hid' => $hid,
        'created' => date('Y-m-d H:i:s'),
    ];
    $result = db_insert('astro_natal')
            ->fields($natal)
            ->execute();
    
//    $data = astro_addCoordinatesToPost($data, $gps);
  
//    add([$query->arguments(), $gps, $hid, $form_state['values'], $data, $natal], true);

    // Redirect.
     $form_state['redirect'] = array('astro/horoscope/create', array('query' => array(),'fragment' => '',),);
    // Print a message.
    drupal_set_message(t('Horoszkóp adatok rögzítve. Amint elkészült értesítünk emailben.'));
    // Save to watchdog.
    watchdog('astro', 'Horoszkóp és natal adatok rögzítve %user által.', array('%user' => $uid, WATCHDOG_NOTICE));
}

function astro_transit_form($form, &$form_state) {
    global $user;
    
    $form = astro_create_form($form, $form_state);
    
    $form['transit_date'] = array(
        '#title' => t('Vizsgálati dátum'),
        '#description' => t('Év, hónap, nap, óra, perc.'),
        '#type'        => 'date_popup',
        '#date_format' => 'Y-m-d H:i',
        '#timepicker'  => 'timepicker',
        '#timepicker_options' => array(
          'rows' => 4,
          'minutes' => array(
            'starts' => 0,
            'ends' => 55,
            'interval' => 5,
          ),
          'showCloseButton' => TRUE,
          'closeButtonText' => t('Close'),
          'showNowButton'   => t('Now'),
          'atPosition'      => 'left bottom',
          'showPeriodLabels'=> FALSE
        ),
        '#required'    => TRUE,
        '#default_value' => date('Y-m-d H:i')
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => 'Beküldés',
        '#validate' => array('astro_transit_form_validate'),
        '#submit' => array('astro_transit_form_submit'),
    );

    return $form;
}

function astro_transit_form_validate($form, &$form_state) {
    $country = trim($form_state['values']['country']);
    $city = trim($form_state['values']['city']);
    
    // Get coords
    $countries = db_select('countries_country', 'cc')->fields('cc')->execute()->fetchAllKeyed(2, 3);
    $geo = geocoder('openstreetmap_nominatim', $countries[$country] . ' ' . $city);
    if ($geo == null) {
        // Ha nincs koordináta
        form_set_error('city', t('Az ország és város párosításához nem található koordináta.'));
    }
}

function astro_transit_form_submit($form, &$form_state) {
    $uid = trim(check_plain($form_state['values']['uid']));
    $oid = trim(check_plain($form_state['values']['oid']));
    
    $hid = astro_merge_horoscope($form_state);
    
    $transit = [
        'oid' => $oid,
        'uid' => $uid,
        'hid' => $hid,
        'datetime' => $form_state['values']['transit_date'] . ':00',
        'created' => date('Y-m-d H:i:s'),
    ];
    $result = db_insert('astro_transit')
            ->fields($transit)
            ->execute();
    
//    $data = astro_addCoordinatesToPost($data, $gps);
  
//    add([$query->arguments(), $gps, $hid, $form_state['values'], $data, $natal], true);

    // Redirect.
     $form_state['redirect'] = array('astro/transit/create', array('query' => array(),'fragment' => '',),);
    // Print a message.
    drupal_set_message(t('Horoszkóp adatok rögzítve. Amint elkészült értesítünk emailben.'));
    // Save to watchdog.
    watchdog('astro', 'Horoszkóp és natal adatok rögzítve %user által.', array('%user' => $uid, WATCHDOG_NOTICE));
}

function astro_synastry_form($form, &$form_state) {
    global $user;
    
    $form = astro_create_form($form, $form_state, 'p1_');
    
    $form = array_merge($form, astro_create_form($form, $form_state, 'p2_'));
    
    $form['p1_description']['#markup'] = '<h2>' . t('Első személy adatai:') . '</h2>';
    $form['p2_description']['#markup'] = '<h2>' . t('Második személy adatai:') . '</h2>';
    
    $form['p1_description']['#prefix'] = '<div class="row"><div class="col-sm-6">';
    $form['p1_clearfix']['#suffix'] = '</div>';
    $form['p2_description']['#prefix'] = '<div class="col-sm-6">';
    $form['p2_clearfix']['#suffix'] = '</div></div>';

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => 'Beküldés',
        '#validate' => array('astro_synastry_form_validate'),
        '#submit' => array('astro_synastry_form_submit'),
    );

    return $form;
}

function astro_synastry_form_validate($form, &$form_state) {
    $country1 = trim($form_state['values']['p1_country']);
    $city1 = trim($form_state['values']['p1_city']);
    
    $country2 = trim($form_state['values']['p2_country']);
    $city2 = trim($form_state['values']['p2_city']);
    
    // Get coords
    $countries = db_select('countries_country', 'cc')->fields('cc')->execute()->fetchAllKeyed(2, 3);
    $geo1 = geocoder('openstreetmap_nominatim', $countries[$country1] . ' ' . $city1);
    if ($geo1 == null) {
        // Ha nincs koordináta
        form_set_error('p1_city', t('Az ország és város párosításához nem található koordináta.'));
    }
    
    $geo2 = geocoder('openstreetmap_nominatim', $countries[$country2] . ' ' . $city2);
    if ($geo2 == null) {
        // Ha nincs koordináta
        form_set_error('p2_city', t('Az ország és város párosításához nem található koordináta.'));
    }
    
//    add([$geo1, $geo2], true);
}

function astro_synastry_form_submit($form, &$form_state) {
    $uid = trim(check_plain($form_state['values']['uid']));
    $oid = trim(check_plain($form_state['values']['oid']));
    
    $hid1 = astro_merge_horoscope($form_state, 'p1_');
    $hid2 = astro_merge_horoscope($form_state, 'p2_');
    
    $synastry = [
        'oid' => $oid,
        'uid' => $uid,
        'hid1' => $hid1,
        'hid2' => $hid2,
        'created' => date('Y-m-d H:i:s'),
    ];
    $result = db_insert('astro_synastry')
            ->fields($synastry)
            ->execute();
    
//    $data = astro_addCoordinatesToPost($data, $gps);
  
//    add([$query->arguments(), $gps, $hid, $form_state['values'], $data, $natal], true);

    // Redirect.
     $form_state['redirect'] = array('astro/synastry/create', array('query' => array(),'fragment' => '',),);
    // Print a message.
    drupal_set_message(t('Horoszkóp adatok rögzítve. Amint elkészült értesítünk emailben.'));
    // Save to watchdog.
    watchdog('astro', 'Horoszkóp és natal adatok rögzítve %user által.', array('%user' => $uid, WATCHDOG_NOTICE));
}

function astro_merge_horoscope($form_state, $prefix = '') {
    $uid = trim(check_plain($form_state['values']['uid']));
    $name = trim(check_plain($form_state['values'][$prefix . 'name']));
    $country = trim(check_plain($form_state['values'][$prefix . 'country']));
    $city = trim(check_plain($form_state['values'][$prefix . 'city']));
        
    // Get coords
    $countries = db_select('countries_country', 'cc')->fields('cc')->execute()->fetchAllKeyed(2, 3);
    $geo = geocoder('openstreetmap_nominatim', $countries[$country] . ' ' . $city);
    $gps = [
        'latitude' => $geo->coords[0],
        'longitude' => $geo->coords[1]
    ];
    // Get timezone
    $timezone = astro_getTimezoneByGPS($gps);
    
    $data = [
        'uid' => $uid,
        'name' => $name,
        'datetime' => $form_state['values'][$prefix . 'datetime'] . ':00',
        'country' => $country,
        'district' => null,
        'city' => $city,
        'lat' => (string) $gps['latitude'],
        'lng' => (string) $gps['longitude'],
        'timezone' => $timezone,
    ];
    
    db_merge('astro_horoscope')
        ->key($data)
        ->fields($data)
        ->execute();
    
    $query = db_select('astro_horoscope', 'h')->fields('h', ['hid']);
    $query->condition('h.uid', $data['uid']);
    $query->condition('h.name', (string) $data['name']);
    $query->condition('h.datetime', (string) $data['datetime']);
    $query->condition('h.country', (string) $data['country']);
    $query->condition('h.lat', $data['lat']);
    $query->condition('h.lng', $data['lng']);
    $query->condition('h.timezone', $data['timezone']);
    $hid = $query->execute()
            ->fetchField();
    
    return $hid;
}