<?php
  $months = array (0 => 'Choose month', 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
  $my_error = "";

  // check if the form has been submitted
  if (isset($_POST['submitted']))
  {
    // get all variables from form
    $month = safeEscapeString($_POST["month"]);
    $day = safeEscapeString($_POST["day"]);
    $year = safeEscapeString($_POST["year"]);

    $timezone = safeEscapeString($_POST["timezone"]);

    $long_deg = safeEscapeString($_POST["long_deg"]);
    $long_min = safeEscapeString($_POST["long_min"]);
    $ew = safeEscapeString($_POST["ew"]);

    $lat_deg = safeEscapeString($_POST["lat_deg"]);
    $lat_min = safeEscapeString($_POST["lat_min"]);
    $ns = safeEscapeString($_POST["ns"]);

    include(astro_getScriptPath() . "validation_class.php");

    //error check
    $my_form = new Validate_fields;

    $my_form->check_4html = true;

    $my_form->add_text_field("Month", $month, "text", "y", 2);
    $my_form->add_text_field("Day", $day, "text", "y", 2);
    $my_form->add_text_field("Year", $year, "text", "y", 4);

    $my_form->add_text_field("Time zone", $timezone, "text", "y", 4);

    $my_form->add_text_field("Longitude degree", $long_deg, "text", "y", 3);
    $my_form->add_text_field("Longitude minute", $long_min, "text", "y", 2);
    $my_form->add_text_field("Longitude E/W", $ew, "text", "y", 2);

    $my_form->add_text_field("Latitude degree", $lat_deg, "text", "y", 2);
    $my_form->add_text_field("Latitude minute", $lat_min, "text", "y", 2);
    $my_form->add_text_field("Latitude N/S", $ns, "text", "y", 2);

    // additional error checks on user-entered data
    if ($month == 0)
    {
      $my_error .= "Please enter a month.<br>";
    }

    if ($month != "" And $day != "" And $year != "")
    {
      if (!$date = checkdate(settype ($month, "integer"), settype ($day, "integer"), settype ($year, "integer")))
      {
        $my_error .= "The date you entered is not valid.<br>";
      }
    }

    if (($year < 1900) Or ($year >= 2100))
    {
      $my_error .= "Please enter a year between 1900 and 2099.<br>";
    }

    if (($long_deg < 0) Or ($long_deg > 179))
    {
      $my_error .= "Longitude degrees must be between 0 and 179.<br>";
    }

    if (($long_min < 0) Or ($long_min > 59))
    {
      $my_error .= "Longitude minutes must be between 0 and 59.<br>";
    }

    if (($lat_deg < 0) Or ($lat_deg > 65))
    {
      $my_error .= "Latitude degrees must be between 0 and 65.<br>";
    }

    if (($lat_min < 0) Or ($lat_min > 59))
    {
      $my_error .= "Latitude minutes must be between 0 and 59.<br>";
    }

    if (($ew == '-1') And ($timezone > 2))
    {
      $my_error .= "You have marked West longitude but set an east time zone.<br>";
    }

    if (($ew == '1') And ($timezone < 0))
    {
      $my_error .= "You have marked East longitude but set a west time zone.<br>";
    }

    if ($ew < 0)
    {
      $ew_txt = "w";
    }
    else
    {
      $ew_txt = "e";
    }

    if ($ns > 0)
    {
      $ns_txt = "n";
    }
    else
    {
      $ns_txt = "s";
    }

    $validation_error = $my_form->validation();

    if ((!$validation_error) || ($my_error != ""))
    {
      $error = $my_form->create_msg();
      echo "<TABLE align='center' WIDTH='98%' BORDER='0' CELLSPACING='15' CELLPADDING='0'><tr><td><center><b>";
      echo "<font color='#ff0000' size=+2>Error! - The following error(s) occurred:</font><br>";

      if ($error)
      {
        echo $error . $my_error;
      }
      else
      {
        echo $error . "<br>" . $my_error;
      }

      echo "</font>";
      echo "<font color='#c020c0'";
      echo "<br>PLEASE RE-ENTER YOUR TIME ZONE DATA. THANK YOU.<br><br>";
      echo "</font>";
      echo "</b></center></td></tr></table>";
    }
    else
    {
      // no errors in filling out form, so process form
      // calculate astronomic data
      $swephsrc = astro_getScriptPath() . 'sweph';
      $sweph = astro_getScriptPath() . 'sweph';

      unset($PATH, $ruling_pl, $pl_hour);

      putenv("PATH=$PATH:$swephsrc");

      $my_longitude = $ew * ($long_deg + ($long_min / 60));
      $my_latitude = $ns * ($lat_deg + ($lat_min / 60));

      $starting_JD = gregoriantojd($month, $day, $year) + ($ew * 0.25);
      
      $command = astro_getScriptPath() . "swetest -edir$sweph -bj$starting_JD -eswe -geopos$my_longitude,$my_latitude,400 -rise";
      $result = exec($command);

      include(astro_getScriptPath() . "constants.php");			// this is here because of the email address


//FOR DEBUG
//echo $result . "<br><br>";

      $first_colon = strpos($result, ":") + 1;
      $rise_hour = mid($result, $first_colon - 2, 2) + $timezone;
      if ($rise_hour >= 24)
      {
        $rise_hour = $rise_hour - 24;
      }
      $rise_minute = mid($result, $first_colon + 1, 2);

      $second_colon = strpos($result, ":", $first_colon + 1) + 1;
      $rise_seconds = mid($result, $second_colon + 1, 2);

      $third_colon = strpos($result, ":", $second_colon + 1) + 1;
      $set_hour = mid($result, $third_colon - 2, 2) + $timezone;
      if ($set_hour < 0)
      {
        $set_hour = $set_hour + 24;
      }
      $set_minute = mid($result, $third_colon + 1, 2);

      $fourth_colon = strpos($result, ":", $third_colon + 1) + 1;
      $set_seconds = mid($result, $fourth_colon + 1, 2);

      echo "<center>";
      if ($timezone < 0)
      {
        $tz = $timezone;
      }
      else
      {
        $tz = "+" . $timezone;
      }

      echo '<font size="2"><b>For ' . strftime("%A, %B %d, %Y<br>JD used = $starting_JD<br>(time zone = GMT $tz hours)</b></font><br />\n", mktime($hour, $minute, 0, $month, $day, $year));
      echo "<font size = '-1'><b>" . $long_deg . $ew_txt . $long_min . ", " . $lat_deg . $ns_txt . $lat_min . "</b></font><br /><br />";
      echo "</center><br>";

      $pl_name[0] = "Sun";
      $pl_name[1] = "Moon";
      $pl_name[2] = "Mars";
      $pl_name[3] = "Mercury";
      $pl_name[4] = "Jupiter";
      $pl_name[5] = "Venus";
      $pl_name[6] = "Saturn";

      $day_of_week = jddayofweek($starting_JD + 0.5);		//0 = Sunday, 6 = Saturday

//FOR DEBUG
//echo $starting_JD . "<br />";
//echo $day_of_week . "<br />";

      $sunset_time = $set_hour * 3600 + $set_minute * 60 + $set_seconds;			//in numbers of seconds
      $sunrise_time = $rise_hour * 3600 + $rise_minute * 60 + $rise_seconds;		//in numbers of seconds

      $length_of_day = $sunset_time - $sunrise_time;
      $length_of_night = 86400 - $length_of_day;

      $day_interval = $length_of_day / 12;							//in seconds
      $night_interval = $length_of_night / 12;						//in seconds

      $time_now = $sunrise_time - $day_interval;
      $ruler_now = $day_of_week +2;
      for ($i = 0; $i < 12; $i++)
      {
        $time_now = $time_now + $day_interval;				//time of next planetary hour
        $ruler_now = $ruler_now - 2;
        if ($ruler_now < 0)
        {
          $ruler_now = $ruler_now + 7;
        }
        $ruling_pl[$i] = $pl_name[$ruler_now];
        $pl_hour[$i] = $time_now;
      }

      $time_now = $sunset_time - $night_interval;
      for ($i = 0; $i < 12; $i++)
      {
        $time_now = $time_now + $night_interval;			//time of next planetary hour
        $ruler_now = $ruler_now - 2;
        if ($ruler_now < 0)
        {
          $ruler_now = $ruler_now + 7;
        }
        $ruling_pl[$i + 12] = $pl_name[$ruler_now];
        $pl_hour[$i + 12] = $time_now;
      }

ob_start();

      echo '<center><table width="30%" cellpadding="0" cellspacing="0" border="0">',"\n";

      echo '<tr>';
      echo "<td><font color='#0000ff'><b> Planet </b></font></td>";
      echo "<td><font color='#0000ff'><b> Time </b></font></td>";
      echo "<td><font color='#0000ff'><b> Planet </b></font></td>";
      echo "<td><font color='#0000ff'><b> Time </b></font></td>";
      echo '</tr>';

      for ($i = 0; $i <= 11; $i++)
      {
        echo '<tr>';
        echo "<td>" . $ruling_pl[$i] . "</td>";
        echo "<td>" . strftime("%X", mktime(0, 0, $pl_hour[$i], $month, $day, $year)) . "</td>";
        echo "<td>" . $ruling_pl[$i + 12] . "</td>";
        echo "<td>" . strftime("%X", mktime(0, 0, $pl_hour[$i + 12], $month, $day, $year)) . "</td>";
        echo '</tr>';
      }

      echo '</table></center>',"\n";

$astroResponse["data"] = ob_get_clean();

    }
  }
  else
  {
 
  }

Function mid($midstring, $midstart, $midlength)
{
  return(substr($midstring, $midstart-1, $midlength));
}


Function safeEscapeString($string)
{
// replace HTML tags '<>' with '[]'
  $temp1 = str_replace("<", "[", $string);
  $temp2 = str_replace(">", "]", $temp1);

// but keep <br> or <br />
// turn <br> into <br /> so later it will be turned into ""
// using just <br> will add extra blank lines
  $temp1 = str_replace("[br]", "<br />", $temp2);
  $temp2 = str_replace("[br /]", "<br />", $temp1);

  if (get_magic_quotes_gpc())
  {
    return $temp2;
  }
  else
  {
    return mysql_escape_string($temp2);
  }
}

?>
