<?php

/**
 * @file Here can test the module units.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
//require_once drupal_get_path('module', 'astro') . '/astro.email.inc';

/**
 * Unit test runner function.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function astro_unit_test() {
    global $language;
    
    // View creation
    $check = db_table_exists('astro_horoscope_orders');
    
    if (!$check) {
    $create = db_query("CREATE VIEW `astro_horoscope_orders` AS SELECT
            (CASE
                WHEN `an`.`nid` IS NOT NULL THEN `an`.`nid`
                WHEN `as`.`sid` IS NOT NULL THEN `as`.`sid`
                WHEN `at`.`tid` IS NOT NULL THEN `at`.`tid`
                ELSE NULL
            END) as id,
            (CASE
                WHEN `an`.`nid` IS NOT NULL THEN 'natal'
                WHEN `as`.`sid` IS NOT NULL THEN 'synastry'
                WHEN `at`.`tid` IS NOT NULL THEN 'transit'
                ELSE NULL
            END) as type,
            (CASE
                WHEN `an`.`nid` IS NOT NULL THEN `an`.`status`
                WHEN `as`.`sid` IS NOT NULL THEN `as`.`status`
                WHEN `at`.`tid` IS NOT NULL THEN `at`.`status`
                ELSE NULL
            END) as status,
            `o`.`oid` AS oid,
            `o`.`id` AS muid,
            `u`.`uid` AS uid,
            `o`.`created` AS created,
            `o`.`pid` AS pid,
            `p`.`pgid` AS pgid,
            `h`.`uid` AS huid,
            `h`.`datetime` AS birth,
            `h`.`country` AS country,
            `h`.`city` AS city,
            `h`.`name` AS name,
            `h`.`lng` AS lng,
            `h`.`lat` AS lat,
            (CASE
                WHEN `an`.`nid` IS NOT NULL THEN `an`.`hid`
                WHEN `as`.`sid` IS NOT NULL THEN `as`.`hid1`
                WHEN `at`.`tid` IS NOT NULL THEN `at`.`hid`
                ELSE NULL
            END) as hid,
            (CASE
                WHEN `as`.`sid` IS NOT NULL THEN `as`.`hid2`
                ELSE NULL
            END) as hid2
        FROM
            (
                `membership_orders` `o`
            LEFT JOIN `membership_products` `p` ON
                p.pid = o.pid
            LEFT JOIN `membership_users` `u` ON
                u.id = o.id
            LEFT JOIN `astro_natal` `an` ON
                `an`.`oid` = o.oid
            LEFT JOIN `astro_synastry` `as` ON
                `as`.`oid` = o.oid
            LEFT JOIN `astro_transit` `at` ON
                `at`.`oid` = o.oid
            LEFT JOIN `astro_horoscope` `h` ON
                (
                    `h`.`hid` = `an`.`hid` OR `h`.`hid` = `as`.`hid1` OR `h`.`hid` = `at`.`hid`
                )
            )
        WHERE
            o.is_activated > 0");
    }
    
    $rechecked = db_table_exists('astro_horoscope_orders');
    
    add([$create, $check, $rechecked], true);
    
////    $countries = countries_get_countries();
//    $countries = db_select('countries_country', 'cc')->fields('cc')->execute()->fetchAllKeyed(2, 3);
//    
//    $geo = geocoder('openstreetmap_nominatim', 'HUN Dabas');
//    if ($geo == null) {
//        $geo = false;
//    }
////    $geo = geocoder_handler_info();
//    
//    add($geo, true);
    
//    http://autocomplete.geocoder.api.here.com/6.2/suggest.json?app_id=z4bFkrOIqnVTzQ5kGi7T&app_code=6Jl9YpjpKHpstrVFW_FR_Q&query=Budapest
    
    // Get here city list
//    $default_params = [
//      'app_id' => variable_get('astro_here_app_id'),
//      'app_code' => variable_get('astro_here_app_code'),
//      'country' => 'HUN',
//      'language' => $language->language,
////      'resultType' => 'postalCode', // areas or postalCode
//      'query' => 'Buda',
//      'maxresults' => 100
//    ];
//    
//    $url = 'http://autocomplete.geocoder.api.here.com/6.2/suggest.json';
//    
//    $data = json_decode(_astro_curl_get($url, $default_params));
//    $data = $language;

//    _new_user_email_send('Proposeasy', 'cs.kubapages@gmail.com', 'kbalazs', 'eclick1122');
//    $payment = 3;
//    _order_email_send('Proposeasy', 'cs.kubapages@gmail.com', '$product_name név', $payment, '$proforma_link/1236547');
//    _activate_email_send('Proposeasy', 'cs.kubapages@gmail.com', 'Terméknév');
//    $invoice = astro_invoice_get(1);
//    _invoice_send(1, $invoice->hash, 'cs.kubapages@gmail.com', 'Proposeasy');
//
    // Run some function
//    $data = [$period_count, $actions, $duplicates, $deletes, $periods];
    add($data, true);
}
