<?php

/**
 * @file All company functions.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function astro_token_info() {

    // Add two different token types. The first is the generic text format. The
    // second is the user's default text format, which is itself a 'format' token
    // type so it can be used directly.
    $info['types']['astro'] = array(
        'name' => t('Membership'),
        'description' => t('Tokens related to Membership.'),
    );

    // Tokens for the text format token type.
    $info['tokens']['astro']['product_name'] = array(// Kész
        'name' => t('Product name'),
        'description' => t("Product name."),
    );
    $info['tokens']['astro']['proforma_link'] = array(// Kész
        'name' => t('Proforma link'),
        'description' => t("Proforma download link."),
    );
    $info['tokens']['astro']['invoice_link'] = array(// Kész
        'name' => t('Invoice link'),
        'description' => t("Invoice link."),
    );
    $info['tokens']['astro']['invoice_link:?:?'] = array(// Kész
        'name' => t('Invoice id'),
        'description' => t("Invoice iid."),
    );
    $info['tokens']['astro']['user_name'] = array(// Kész
        'name' => t('Generated username'),
        'description' => t("Recent created user's name."),
    );
    $info['tokens']['astro']['user_password'] = array(// Kész
        'name' => t('Generated password'),
        'description' => t("Recent created user's password."),
    );

    return $info;
}

function astro_tokens($type, $tokens, array $data = array(), array $options = array()) {
    $replacements = array();
    $sanitize = !empty($options['sanitize']);
    global $base_url;

    // Text format tokens.
    if ($type == 'astro' && !empty($data['astro'])) {
        $format = $data['astro'];
        foreach ($tokens as $name => $original) {

            $name_parts = explode(':', $name);

            switch ($name_parts[0]) {
                case 'product_name':
                    $replacements[$original] = '$product_name';
                    break;

                case 'proforma_link':
                    $replacements[$original] = '$proforma_link';
                    break;

                case 'invoice_link':
                    if (isset($name_parts[1]) && isset($name_parts[2])) {
                        $oid = $name_parts[1];
                        $type = $name_parts[2];
                        $invoice = astro_invoice_get_object($oid, $type);
                        $iid = !empty($invoice) ? $invoice->iid : '';
                        $hash = !empty($invoice) ? $invoice->hash : '';
                        // /szamla?iid=$iid&hash=$hash
                        $replacements[$original] = $base_url . "/szamla?iid=$iid&hash=$hash";
                    }
                    break;

                case 'user_name':
                    $replacements[$original] = '$username';
                    break;
                case 'user_password':
                    $replacements[$original] = '$password';
                    break;
            }
        }
    }

    return $replacements;
}
