<?php

/**
 * @file Astro settings.
 * @package Astro
 * @author Kulcsár Balázs
 */

/**
 * Creates the main settings form.
 * @param type $form
 * @param type $form_state
 * @return $form
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function astro_settings_form($form, &$form_state) {

    global $base_url;
    $module_path = drupal_get_path('module', 'astro');
    $membership_products = [];
    if(db_table_exists('membership_products')) {
        $membership_products = db_query("SELECT pid, name FROM {membership_products}")->fetchAllKeyed();
    }

    $form = array();

    $form['overview'] = array(
        '#markup' => t('Admininstrators can set the main settings of the astro system.'),
        '#prefix' => '<p>',
        '#suffix' => '</p>',
    );

    // Company settings
    $form['customer'] = array(
        '#type' => 'fieldset',
        '#title' => t('Customer side settings'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['customer']['astro_sender_email'] = array(
        '#title' => t('Küldő email címe'),
        '#description' => t('Erről az email címről küldi a rendszer a címzettnek a 3 levelet.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('astro_sender_email', ''),
//        '#required' => TRUE,
        '#element_validate' => array('astro_element_validate_email'),
    );

    $form['customer']['astro_sender_name'] = array(
        '#title' => t('Küldő neve'),
        '#description' => t('Ez a név lesz csatolva a küldő email címhez.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('astro_sender_name', ''),
//        '#required' => TRUE,
    );

    $form['customer']['astro_gdpr_text'] = array(
        '#title' => t('GDPR szöveg'),
        '#type' => 'text_format',
        '#format' => variable_get('astro_gdpr_text', array('format' => 'plain'))['format'],
        '#rows' => 10,
        '#default_value' => variable_get('astro_gdpr_text')['value'],
//        '#required' => TRUE,
    );

    // Company settings
    $form['apis'] = array(
        '#type' => 'fieldset',
        '#title' => t('API keys'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );
    
    $form['apis']['heremap'] = array(
        '#type' => 'fieldset',
        '#title' => t('Heremap API'),
        '#collapsible' => TRUE,
        '#collapsed' => FALSE,
    );
    
    $form['apis']['heremap']['astro_here_app_id'] = array(
        '#title' => t('REST App id'),
        '#description' => t('Heremap API app id. (Legacy)'),
        '#type' => 'textfield',
        '#default_value' => variable_get('astro_here_app_id', ''),
        '#required' => FALSE,
    );
    $form['apis']['heremap']['astro_here_app_code'] = array(
        '#title' => t('REST App code'),
        '#description' => t('Heremap API app code. (Legacy)'),
        '#type' => 'textfield',
        '#default_value' => variable_get('astro_here_app_code', ''),
        '#required' => FALSE,
    );
//    $form['apis']['heremap']['astro_here_api_key'] = array(
//        '#title' => t('API key'),
//        '#description' => t('Heremap API key.'),
//        '#type' => 'textfield',
//        '#default_value' => variable_get('astro_here_api_key', ''),
//        '#required' => FALSE,
//    );

    // Product settings
    $form['products'] = array(
        '#type' => 'fieldset',
        '#title' => t('Membership products'),
        '#collapsible' => TRUE,
        '#collapsed' => FALSE,
    );
    
    $form['products']['astro_natal_product_ids'] = array(
        '#title' => t('Natal product ids'),
        '#description' => t('You can choose multiple, but not same with products of other horoscope types.<br>If there is any overlap, first horoscope type will be dedicated to the pid.'),
        '#type' => 'checkboxes',
        '#multiple' => TRUE,
        '#options' => $membership_products,
        '#default_value' => variable_get('astro_natal_product_ids', ''),
        '#required' => TRUE,
    );
    
    $form['products']['astro_synastry_product_ids'] = array(
        '#title' => t('Synastry product ids'),
        '#description' => t('You can choose multiple, but not same with products of other horoscope types.<br>If there is any overlap, first horoscope type will be dedicated to the pid.'),
        '#type' => 'checkboxes',
        '#multiple' => TRUE,
        '#options' => $membership_products,
        '#default_value' => variable_get('astro_synastry_product_ids', ''),
        '#required' => TRUE,
    );
    
    $form['products']['astro_transit_product_ids'] = array(
        '#title' => t('Progression product ids'),
        '#description' => t('You can choose multiple, but not same with products of other horoscope types.<br>If there is any overlap, first horoscope type will be dedicated to the pid.'),
        '#type' => 'checkboxes',
        '#multiple' => TRUE,
        '#options' => $membership_products,
        '#default_value' => variable_get('astro_transit_product_ids', ''),
        '#required' => TRUE,
    );
    
    return system_settings_form($form);
}

/**
 * After submit settings form merge emails into database and set all the variables.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
/*function astro_settings_form_submit($form, &$form_state){

    // Save emails
    foreach($form['email']['emails'] as $k => $v){
        if(strpos($k, 'certify_mail') !== false){
            $subject = $k . '_subject';
            $body = $k . '_body';
            $fields = array(
                'variable' => $k,
                'subject'  => $form_state['values'][$subject],
                'body'     => $form_state['values'][$body]
            );
            db_merge('certify_default_emails')->key(array('variable' => $k))->fields($fields)->execute();
        }
    }
    // Exclude unnecessary elements.
    form_state_values_clean($form_state);

    // Set variables.
    certify_variable_set_from_form($form_state);

    // Save to watchdog.
    watchdog('certify', 'Settings and default emails has been refreshed.', array('certify_settings_form' => 'emails', WATCHDOG_NOTICE));
}
*/
