<?php

function asztro_block_info() {
	$blocks['asztro'] = array(
		'info' => t('Asztrology module'),
		'cache' => DRUPAL_CACHE_PER_ROLE
	);
	return $blocks;
}

function astro_getScriptPath() {
	return DRUPAL_ROOT . '/sites/all/modules/astro/external/';
}

function astro_getScriptURL() {
	return 'http://astroinfo.hu/sites/all/modules/astro/external/';
}

function astro_getGPSByCity($city) {
	$sql = "
		SELECT latitude, longitude
		FROM cities
		WHERE accentCity = :city
		ORDER BY population DESC
		LIMIT 1
	";

	$result = db_query($sql, array(":city" => $city))->fetchAssoc();
	return $result;
}

function astro_DECtoDMSlat($coord) {
    $isnorth = $coord >= 0;
    $coord = abs($coord);
    $deg = floor($coord);
    $coord = ($coord - $deg) * 60;
    $min = floor($coord);
    $sec = floor(($coord - $min) * 60);
    return array($deg, $min, $sec, $isnorth ? 'N' : 'S');
}

function astro_DECtoDMSlon($coord) {
    $isnorth = $coord >= 0;
    $coord = abs($coord);
    $deg = floor($coord);
    $coord = ($coord - $deg) * 60;
    $min = floor($coord);
    $sec = floor(($coord - $min) * 60);
    return array($deg, $min, $sec, $isnorth ? 'E' : 'W');
}

function astro_addCoordinatesToPost($post, $gps, $postfix = '') {
	$lon = astro_DECtoDMSlon($gps["longitude"]);
	$lat = astro_DECtoDMSlat($gps["latitude"]);

	$post['long_deg' . $postfix] = $lon[0];
	$post['long_min' . $postfix] = $lon[1];
	$post['ew' . $postfix] = $lon[3] == 'E' ? 1 : -1;
	$post['lat_deg' . $postfix] = $lat[0];
	$post['lat_min' . $postfix] = $lat[1];
	$post['ns' . $postfix] = $lat[3] == 'N' ? 1 : -1;

	return $post;
}

function astro_getTimezone($city, $gps) {
	$sql = "
		SELECT country, timezone
		FROM cities
		WHERE accentCity = :city
		ORDER BY population DESC
		LIMIT 1
	";

	$result = db_query($sql, array(":city" => $city))->fetchAssoc();
	$country = $result["country"];

	$fixTimezones = array(
		'af' => 4.5, 'al' => 1, 'dz' => 1, 'ad' => 1, 'ao' => 1, 'ag' => -4, 'ar' => -3, 'am' => 4, 'at' => 1, 'az' => 4, 'bs' => -5, 'bh' => 3, 'bd' => 6, 'bb' => -4, 'by' => 3, 'be' => 1, 'bz' => -6, 'bj' => 1, 'bt' => 6, 'bo' => -4, 'ba' => 1, 'bw' => 2, 'bn' => 8, 'bg' => 2, 'bf' => 0, 'bi' => 2, 'kh' => 7, 'cm' => 1, 'cv' => -1, 'cf' => 1, 'td' => 1, 'cn' => 8, 'co' => -5, 'km' => 3, 'cd' => 1, 'cr' => -6, 'ci' => 0, 'hr' => 1, 'cu' => -5, 'cy' => 2, 'cz' => 1, 'dj' => 3, 'dm' => -4, 'do' => -4, 'tl' => 9, 'eg' => 2, 'sv' => -6, 'gq' => 1, 'er' => 3, 'ee' => 2, 'et' => 3, 'fj' => 12, 'fi' => 2, 'ga' => 1, 'gm' => 0, 'ge' => 4, 'de' => 1, 'gh' => 0, 'gr' => 2, 'gd' => -4, 'gt' => -6, 'gn' => 0, 'gw' => 0, 'gy' => -4, 'ht' => -5, 'hn' => -6, 'hk' => 8, 'hu' => 1, 'is' => 0, 'in' => 5.5, 'ir' => 3.5, 'iq' => 3, 'ie' => 0, 'il' => 2, 'it' => 1, 'jm' => -5, 'jp' => 9, 'jo' => 3, 'ke' => 3, 'kp' => 9, 'kr' => 9, 'kw' => 3, 'kg' => 6, 'la' => 7, 'lv' => 2, 'lb' => 2, 'ls' => 2, 'lr' => 0, 'ly' => 1, 'li' => 1, 'lt' => 2, 'lu' => 1, 'mo' => 8, 'mk' => 1, 'mg' => 3, 'mw' => 2, 'my' => 8, 'mv' => 5, 'ml' => 0, 'mt' => 1, 'mh' => 12, 'mr' => 0, 'mu' => 4, 'md' => 2, 'mc' => 1, 'me' => 1, 'ma' => 0, 'mz' => 2, 'mm' => 6.5, 'na' => 1, 'nr' => 12, 'np' => 5.5, 'ni' => -6, 'ne' => 1, 'ng' => 1, 'no' => 1, 'om' => 4, 'pk' => 5, 'pw' => 9, 'pa' => -5, 'pg' => 10, 'py' => -4, 'pe' => -5, 'ph' => 8, 'pl' => 1, 'qa' => 3, 'ro' => 2, 'rw' => 2, 'kn' => -4, 'lc' => -4, 'vc' => -4, 'ws' => 13, 'sm' => 1, 'st' => 0, 'sa' => 3, 'sn' => 0, 'rs' => 1, 'sc' => 4, 'sl' => 0, 'sg' => 8, 'sk' => 1, 'si' => 1, 'sb' => 11, 'so' => 3, 'za' => 2, 'ss' => 3, 'lk' => 5.5, 'sd' => 3, 'sr' => -3, 'sz' => 2, 'se' => 1, 'ch' => 1, 'sy' => 2, 'tw' => 8, 'tj' => 5, 'tz' => 3, 'th' => 7, 'tg' => 0, 'to' => 13, 'tt' => -4, 'tn' => 1, 'tr' => 2, 'tm' => 5, 'tv' => 12, 'ug' => 3, 'ua' => 2, 'ae' => 4, 'uy' => -3, 'uz' => 5, 'vu' => 11, 'va' => 1, 've' => -4, 'vn' => 7, 'ye' => 3, 'zm' => 2, 'zw' => 2
	);

	// ha az országhoz egyetlen időzóna tartozik, akkor nem indítunk lekérést, hanem azt az egyet fixen visszaadjuk:
	if (array_key_exists($country, $fixTimezones)) return $fixTimezones[$country];

	// ha több, akkor megnézzük, hogy megvan-e db-ben letárolva az időzóna az adott városhoz
	if ($result["timezone"] !== NULL) return $result["timezone"];

	// ha nincs, akkor lekérjük GPS alapján az időzónát, és eltároljuk db-be az adott városhoz a kapott értéket
	$timezone = astro_getTimezoneByGPS($gps);

	$sql = "
		UPDATE cities
		SET timezone = $timezone
		WHERE accentCity = :city
			AND country = '" . $result["country"] . "'
	";
	db_query($sql, array(":city" => $city));

	return $timezone;
}

function astro_getTimezoneByGPS($gps) {
	$options = array(
		'method' => 'GET'
	);

	$lat = $gps["latitude"];
	$lon = $gps["longitude"];
        
        // http://new.earthtools.org/timezone/19.3229242/47.1729302

//	$url = "http://www.earthtools.org/timezone/$lat/$lon";
	$url = "http://new.earthtools.org/timezone/$lat/$lon";
	$result = drupal_http_request($url, $options);
	$xml = simplexml_load_string($result->data);

	$timezone = (int)$xml->offset;
	return $timezone;
}

function astro_errorMissingParameter($p) {
	return array(
		"status" => "error",
		"reason" => "missing parameter: " . $p
	);
}

function astro_errorInvalidParameterValue($v) {
	return array(
		"status" => "error",
		"reason" => "invalid parameter value: " . $v
	);
}

function astro_makePostData($p1, $p2 = false) {
	$post = array();
	$post["submitted"] = 'TRUE';

	if ($p2 === false) {
		$post['name'] = $p1['name'];
		$post['year'] = substr($p1['birthDate'], 0, 4);
		$post['month'] = substr($p1['birthDate'], 5, 2);
		$post['day'] = substr($p1['birthDate'], 8, 2);
		$post['hour'] = substr($p1["birthTime"], 0, 2);
		$post['minute'] = substr($p1["birthTime"], 3, 2);

		$gps = astro_getGPSByCity($p1["city"]);
		$post = astro_addCoordinatesToPost($post, $gps);

		$post['timezone'] = isset($p1["timezone"]) ? $p1["timezone"] : astro_getTimezone($p1["city"], $gps);
	}
	else {
		$post['name1'] = $p1['name'];
		$post['year1'] = substr($p1['birthDate'], 0, 4);
		$post['month1'] = substr($p1['birthDate'], 5, 2);
		$post['day1'] = substr($p1['birthDate'], 8, 2);
		$post['hour1'] = substr($p1["birthTime"], 0, 2);
		$post['minute1'] = substr($p1["birthTime"], 3, 2);

		$gps1 = astro_getGPSByCity($p1["city"]);
		$post = astro_addCoordinatesToPost($post, $gps1, '1');

		$post['timezone1'] = isset($p1["timezone"]) ? $p1["timezone"] : astro_getTimezone($p1["city"], $gps1);

		$post['name2'] = $p2['name'];
		$post['year2'] = substr($p2['birthDate'], 0, 4);
		$post['month2'] = substr($p2['birthDate'], 5, 2);
		$post['day2'] = substr($p2['birthDate'], 8, 2);
		$post['hour2'] = substr($p2["birthTime"], 0, 2);
		$post['minute2'] = substr($p2["birthTime"], 3, 2);

		$gps2 = astro_getGPSByCity($p2["city"]);
		$post = astro_addCoordinatesToPost($post, $gps2, '2');

		$post['timezone2'] = isset($p2["timezone"]) ? $p2["timezone"] : astro_getTimezone($p2["city"], $gps2);
	}

	return $post;
}

function astro_callScript($name) {
	$astroResponse = array();

	$scriptPath = astro_getScriptPath() . $name . '.php';

	ob_start();
	@include($scriptPath);
	ob_end_clean();

	return $astroResponse;
}

/**
 * FUNCTION 1: Your natal chart (including its interpretation)
 * 
 * @param	array 	person properties
 *			char	sys (p, k, r, c, b, o, m, a, t, v)
 *
 * @return
 * 		natal_wheel_src
 *		natal_aspect_grid_src
 * 		natal_wheel_img
 *		natal_aspect_grid_img
 *		natalData
 *		natalDataAspectTable
 *		text
 */
function astro_natalChart($params, $sys = 'p') {
	// validation
	$requiredParams = array("name", "birthDate", "birthTime", "city");
	foreach ($requiredParams as $p) if (!isset($params[$p]) || trim($params[$p]) == '') return astro_errorMissingParameter($p);
	if (astro_getGPSByCity($params["city"]) === false) return astro_errorInvalidParameterValue($params["city"]);

	// make post data
	$_POST = astro_makePostData($params);
	$_POST["h_sys"] = $sys;

	// call external script and get response
	$response = astro_callScript('natal_form_wheel_2_14');

	// returned array with complete html and separated data
	return array(
		"status" => "success",
		"data" => $response,
		"html" => 	$response["natal_wheel_img"] .
					$response["natal_aspect_grid_img"] .
					$response["natalData"] .
					$response["natalDataAspectTable"] .
					$response["text"]
	);
}

/**
 * FUNCTION 2: Your natal chart (with Sabian symbols)
 * 
 * @param	array 	person properties
 *			char	sys (p, k, r, c, b, o, m, a, t, v)
 *
 * @return
 * 		natal_wheel_src
 *		natal_aspect_grid_src
 * 		natal_wheel_img
 *		natal_aspect_grid_img
 *		natalData
 *		natalDataAspectTable
 *		text
 */
function astro_natalChartWithSabianSymbols($params, $sys = 'p') {
	// validation
	$requiredParams = array("name", "birthDate", "birthTime", "city");
	foreach ($requiredParams as $p) if (!isset($params[$p]) || trim($params[$p]) == '') return astro_errorMissingParameter($p);
	if (astro_getGPSByCity($params["city"]) === false) return astro_errorInvalidParameterValue($params["city"]);

	// make post data
	$_POST = astro_makePostData($params);
	$_POST["h_sys"] = $sys;

	// call external script and get response
	$response = astro_callScript('sabian_form_wheel_2');

	// returned array with complete html and separated data
	return array(
		"status" => "success",
		"data" => $response,
		"html" => 	$response["natal_wheel_img"] .
					$response["natal_aspect_grid_img"] .
					$response["natalData"] .
					$response["natalDataAspectTable"] .
					$response["text"]
	);
}

/**
 * FUNCTION 3: Your synastry with another
 * 
 * @param	array 	person1 properties
 *			array 	person2 properties
 *			char	sys (p, k, r, c, b, o, m, a, t, v)
 *
 * @return
 * 		synastry_wheel_src
 *		synastry_aspect_grid_src
 * 		synastry_wheel_img
 *		synastry_aspect_grid_img
 *		synastryData
 *		synastryDataAspectTable
 *		text
 */
function astro_synastryWithAnother($params1, $params2, $sys = 'p') {
	// validation
	$requiredParams = array("name", "birthDate", "birthTime", "city");
	foreach ($requiredParams as $p) if (!isset($params1[$p]) || trim($params1[$p]) == '') return astro_errorMissingParameter("person1: " . $p);
	foreach ($requiredParams as $p) if (!isset($params2[$p]) || trim($params2[$p]) == '') return astro_errorMissingParameter("person2: " . $p);
	if (astro_getGPSByCity($params1["city"]) === false) return astro_errorInvalidParameterValue($params1["city"]);
	if (astro_getGPSByCity($params2["city"]) === false) return astro_errorInvalidParameterValue($params2["city"]);

	// make post data
	$_POST = astro_makePostData($params1, $params2);
	$_POST["h_sys"] = $sys;

	// call external script and get response
	$response = astro_callScript('synastry_form_wheel');

	// returned array with complete html and separated data
	return array(
		"status" => "success",
		"data" => $response,
		"html" => 	$response["synastry_wheel_img"] .
					$response["synastry_aspect_grid_img"] .
					$response["synastryData"] .
					$response["synastryDataAspectTable"] .
					$response["text"]
	);
}

/**
 * FUNCTION 4: Your composite chart with another
 * 
 * @param	array 	person1 properties
 *			array 	person2 properties
 *			char	sys (p, k, r, c, b, o, m, a, t, v)
 *
 * @return
 * 		composite_wheel_src
 *		composite_aspect_grid_src
 * 		composite_wheel_img
 *		composite_aspect_grid_img
 *		compositeData
 *		compositeDataAspectTable
 *		text
 */
function astro_compositeChart($params1, $params2, $sys = 'p') {
	// validation
	$requiredParams = array("name", "birthDate", "birthTime", "city");
	foreach ($requiredParams as $p) if (!isset($params1[$p]) || trim($params1[$p]) == '') return astro_errorMissingParameter("person1: " . $p);
	foreach ($requiredParams as $p) if (!isset($params2[$p]) || trim($params2[$p]) == '') return astro_errorMissingParameter("person2: " . $p);
	if (astro_getGPSByCity($params1["city"]) === false) return astro_errorInvalidParameterValue($params1["city"]);
	if (astro_getGPSByCity($params2["city"]) === false) return astro_errorInvalidParameterValue($params2["city"]);

	// make post data
	$_POST = astro_makePostData($params1, $params2);
	$_POST["h_sys"] = $sys;

	// call external script and get response
	$response = astro_callScript('composite_form_wheel');

	// returned array with complete html and separated data
	return array(
		"status" => "success",
		"data" => $response,
		"html" => 	$response["composite_wheel_img"] .
					$response["composite_aspect_grid_img"] .
					$response["compositeData"] .
					$response["compositeDataAspectTable"] .
					$response["text"]
	);
}

/**
 * FUNCTION 5: Your Davison relationship chart with another
 * 
 * @param	array 	person1 properties
 *			array 	person2 properties
 *			char	sys (p, k, r, c, b, o, m, a, t, v)
 *
 * @return
 * 		natal_wheel_src
 *		natal_aspect_grid_src
 * 		natal_wheel_img
 *		natal_aspect_grid_img
 *		davisonRelationshipData
 *		davisonRelationshipDataAspectTable
 *		text
 */
function astro_davisonRelationShipChart($params1, $params2, $sys = 'p') {
	// validation
	$requiredParams = array("name", "birthDate", "birthTime", "city");
	foreach ($requiredParams as $p) if (!isset($params1[$p]) || trim($params1[$p]) == '') return astro_errorMissingParameter("person1: " . $p);
	foreach ($requiredParams as $p) if (!isset($params2[$p]) || trim($params2[$p]) == '') return astro_errorMissingParameter("person2: " . $p);
	if (astro_getGPSByCity($params1["city"]) === false) return astro_errorInvalidParameterValue($params1["city"]);
	if (astro_getGPSByCity($params2["city"]) === false) return astro_errorInvalidParameterValue($params2["city"]);

	// make post data
	$_POST = astro_makePostData($params1, $params2);
	$_POST["h_sys"] = $sys;

	// call external script and get response
	$response = astro_callScript('davison_form_wheel');

	// returned array with complete html and separated data
	return array(
		"status" => "success",
		"data" => $response,
		"html" => 	$response["natal_wheel_img"] .
					$response["natal_aspect_grid_img"] .
					$response["davisonRelationshipData"] .
					$response["davisonRelationshipDataAspectTable"] .
					$response["text"]
	);
}

/**
 * FUNCTION 6: Your transits right now (with brief interpretations)
 * 
 * @param	array 	person properties
 *			char	sys (p, k, r, c, b, o, m, a, t, v)
 *
 * @return
 * 		transit_wheel_src
 *		transit_aspect_grid_src
 * 		transit_wheel_img
 *		transit_aspect_grid_img
 *		transitData
 *		transitDataAspectTable
 *		text
 */
function astro_transitsRightNow($params, $sys = 'p') {
	// validation
	$requiredParams = array("name", "birthDate", "birthTime", "city");
	foreach ($requiredParams as $p) if (!isset($params[$p]) || trim($params[$p]) == '') return astro_errorMissingParameter($p);
	if (astro_getGPSByCity($params["city"]) === false) return astro_errorInvalidParameterValue($params["city"]);

	// make post data
	$_POST = astro_makePostData($params);
	$_POST["h_sys"] = $sys;

	// call script, get response
	$response = astro_callScript('now_form_wheel');

	// returned array with complete html and separated data
	return array(
		"status" => "success",
		"data" => $response,
		"html" => 	$response["transit_wheel_img"] .
					$response["transit_aspect_grid_img"] .
					$response["transitData"] .
					$response["transitDataAspectTable"] .
					$response["text"]
	);
}

/**
 * FUNCTION 7: Your transits for any date (with brief interpretations)
 * 
 * @param	array 	person properties
 *			string	date
 *			char	sys (p, k, r, c, b, o, m, a, t, v)
 *
 * @return
 * 		transit_wheel_src
 *		transit_aspect_grid_src
 * 		transit_wheel_img
 *		transit_aspect_grid_img
 *		transitData
 *		transitDataAspectTable
 *		text
 */
function astro_transitsForAnyDate($params, $date = false, $sys = 'p') {
	if ($date === false) $date = date('Y-m-d');

	// validation
	$requiredParams = array("name", "birthDate", "birthTime", "city");
	foreach ($requiredParams as $p) if (!isset($params[$p]) || trim($params[$p]) == '') return astro_errorMissingParameter($p);
	if (astro_getGPSByCity($params["city"]) === false) return astro_errorInvalidParameterValue($params["city"]);

	// make post data
	$_POST = astro_makePostData($params);

	$_POST["start_year"] = substr($date, 0, 4);
	$_POST["start_month"] = substr($date, 5, 2);
	$_POST["start_day"] = substr($date, 8, 2);

	$_POST["h_sys"] = $sys;

	// call script, get response
	$response = astro_callScript('transits_form_wheel');

	// returned array with complete html and separated data
	return array(
		"status" => "success",
		"data" => $response,
		"html" => 	$response["transit_wheel_img"] .
					$response["transit_aspect_grid_img"] .
					$response["transitData"] .
					$response["transitDataAspectTable"] .
					$response["text"]
	);
}

/**
 * FUNCTION 8: Your progressions for any date
 * 
 * @param	array 	person properties
 *			string	date
 *			char	sys (p, k, r, c, b, o, m, a, t, v)
 *
 * @return
 * 		prog_wheel_src
 *		prog_aspect_grid_src
 * 		prog_wheel_img
 *		prog_aspect_grid_img
 *		progressedData
 *		progressedDataAspectTable
 *		text
 */
function astro_progressionsForAnyDate($params, $date = false, $sys = 'p') {
	if ($date === false) $date = date('Y-m-d');

	// validation
	$requiredParams = array("name", "birthDate", "birthTime", "city");
	foreach ($requiredParams as $p) if (!isset($params[$p]) || trim($params[$p]) == '') return astro_errorMissingParameter($p);
	if (astro_getGPSByCity($params["city"]) === false) return astro_errorInvalidParameterValue($params["city"]);

	// make post data
	$_POST = astro_makePostData($params);

	$_POST["start_year"] = substr($date, 0, 4);
	$_POST["start_month"] = substr($date, 5, 2);
	$_POST["start_day"] = substr($date, 8, 2);

	$_POST["h_sys"] = $sys;

	// call script, get response
	$response = astro_callScript('progressions_form_wheel');

	// returned array with complete html and separated data
	return array(
		"status" => "success",
		"data" => $response,
		"html" => 	$response["prog_wheel_img"] .
					$response["prog_aspect_grid_img"] .
					$response["progressedData"] .
					$response["progressedDataAspectTable"] .
					$response["text"]
	);
}

/**
 * FUNCTION 9: Your transits and progressions for any date
 * 
 * @param	array 	person properties
 *			string	date
 *			char	sys (p, k, r, c, b, o, m, a, t, v)
 *
 * @return
 * 		transit_prog_wheel_src
 *		prog_aspect_grid_src
 *		transit_aspect_grid_src
 * 		transit_prog_wheel_img
 *		prog_aspect_grid_img
 *		transit_aspect_grid_img
 *		data
 *		progressedDataAspectTable
 *		transitDataAspectTable
 *		text
 */
function astro_transitsAndProgressionsForAnyDate($params, $date = false, $sys = 'p') {
	if ($date === false) $date = date('Y-m-d');

	// validation
	$requiredParams = array("name", "birthDate", "birthTime", "city");
	foreach ($requiredParams as $p) if (!isset($params[$p]) || trim($params[$p]) == '') return astro_errorMissingParameter($p);
	if (astro_getGPSByCity($params["city"]) === false) return astro_errorInvalidParameterValue($params["city"]);

	// make post data
	$_POST = astro_makePostData($params);

	$_POST["start_year"] = substr($date, 0, 4);
	$_POST["start_month"] = substr($date, 5, 2);
	$_POST["start_day"] = substr($date, 8, 2);

	$_POST["h_sys"] = $sys;

	// call script, get response
	$response = astro_callScript('transits_progressed_form_wheel');

	// returned array with complete html and separated data
	return array(
		"status" => "success",
		"data" => $response,
		"html" => 	$response["transit_prog_wheel_img"] .
					$response["prog_aspect_grid_img"] .
					$response["transit_aspect_grid_img"] .
					$response["data"] .
					$response["progressedDataAspectTable"] .
					$response["transitDataAspectTable"] .
					$response["text"]
	);
}

/**
 * FUNCTION 10: Your solar arcs for any date
 * 
 * @param	array 	person properties
 *			string	date
 *			char	sys (p, k, r, c, b, o, m, a, t, v)
 *
 * @return
 * 		sa_wheel_src
 *		sa_aspect_grid_src
 * 		sa_wheel_img
 *		sa_aspect_grid_img
 *		solarArcData
 *		solarArcDataAspectTable
 *		text
 */
function astro_solarArcsForAnyDate($params, $date = false, $sys = 'p') {
	if ($date === false) $date = date('Y-m-d');

	// validation
	$requiredParams = array("name", "birthDate", "birthTime", "city");
	foreach ($requiredParams as $p) if (!isset($params[$p]) || trim($params[$p]) == '') return astro_errorMissingParameter($p);
	if (astro_getGPSByCity($params["city"]) === false) return astro_errorInvalidParameterValue($params["city"]);

	// make post data
	$_POST = astro_makePostData($params);

	$_POST["start_year"] = substr($date, 0, 4);
	$_POST["start_month"] = substr($date, 5, 2);
	$_POST["start_day"] = substr($date, 8, 2);

	$_POST["h_sys"] = $sys;

	// call script, get response
	$response = astro_callScript('solar_arcs_form_wheel');

	// returned array with complete html and separated data
	return array(
		"status" => "success",
		"data" => $response,
		"html" => 	$response["sa_wheel_img"] .
					$response["sa_aspect_grid_img"] .
					$response["solarArcData"] .
					$response["solarArcDataAspectTable"] .
					$response["text"]
	);
}

/**
 * FUNCTION 11: Your transits and solar arcs for any date
 * 
 * @param	array 	person properties
 *			string	date
 *			char	sys (p, k, r, c, b, o, m, a, t, v)
 *
 * @return
 * 		transit_sa_wheel_src
 *		sa_aspect_grid_for_tr_sa_src
 *		transit_aspect_grid_src
 * 		transit_sa_wheel_img
 *		sa_aspect_grid_for_tr_sa_img
 *		transit_aspect_grid_img
 *		data
 *		solarArcDataAspectTable
 *		transitDataAspectTable
 *		text
 */
function astro_transitsAndSolarArcsForAnyDate($params, $date = false, $sys = 'p') {
	if ($date === false) $date = date('Y-m-d');

	// validation
	$requiredParams = array("name", "birthDate", "birthTime", "city");
	foreach ($requiredParams as $p) if (!isset($params[$p]) || trim($params[$p]) == '') return astro_errorMissingParameter($p);
	if (astro_getGPSByCity($params["city"]) === false) return astro_errorInvalidParameterValue($params["city"]);

	// make post data
	$_POST = astro_makePostData($params);

	$_POST["start_year"] = substr($date, 0, 4);
	$_POST["start_month"] = substr($date, 5, 2);
	$_POST["start_day"] = substr($date, 8, 2);

	$_POST["h_sys"] = $sys;

	// call script, get response
	$response = astro_callScript('transits_solar_arcs_form_wheel');

	// returned array with complete html and separated data
	return array(
		"status" => "success",
		"data" => $response,
		"html" => 	$response["transit_sa_wheel_img"] .
					$response["sa_aspect_grid_for_tr_sa_img"] .
					$response["transit_aspect_grid_img"] .
					$response["data"] .
					$response["solarArcDataAspectTable"] .
					$response["transitDataAspectTable"] .
					$response["text"]
	);
}

/**
 * FUNCTION 12: Right now (no houses)
 *
 * @return
 * 		chartwheel_right_now_line_src
 *		chartwheel_right_now_line_img
 *		data
 */
function astro_rightNow() {
	// call script, get response
	$response = astro_callScript('right_now');

	// returned array with complete html and separated data
	return array(
		"status" => "success",
		"data" => $response,
		"html" =>	$response["chartwheel_right_now_line_img"] .
					$response["data"]
	);
}

/**
 * FUNCTION 13: Right now where you are connecting from
 *
 * @return
 */
function astro_rightNowWhereAreYouConnectingFrom() {
	// missing right_now_1_location.php file
}

/**
 * FUNCTION 14: Moon aspects including void-of-course Moon
 *
 * @return
 * 		data
 */
function astro_moonAspects() {
	// call script, get response
	$response = astro_callScript('moon_aspects');

	// returned array with complete html and separated data
	return array(
		"status" => "success",
		"data" => $response,
		"html" => $response["data"]
	);
}

/**
 * FUNCTION 15: Planetary Hours
 *
 * @return
 * 		data
 */
function astro_planetaryHours($params) {
	// validation
	$requiredParams = array("date", "city");
	foreach ($requiredParams as $p) if (!isset($params[$p]) || trim($params[$p]) == '') return astro_errorMissingParameter($p);
	if (astro_getGPSByCity($params["city"]) === false) return astro_errorInvalidParameterValue($params["city"]);

	// make post data
	$_POST = array();

	$_POST["year"] = substr($params["date"], 0, 4);
	$_POST["month"] = substr($params["date"], 5, 2);
	$_POST["day"] = substr($params["date"], 8, 2);

	$gps = astro_getGPSByCity($params["city"]);
	$_POST = astro_addCoordinatesToPost($_POST, $gps);

	$_POST["submitted"] = 'TRUE';

	// call script, get response
	$response = astro_callScript('planetary_hours');

	// returned array with complete html and separated data
	return array(
		"status" => "success",
		"data" => $response,
		"html" => $response["data"]
	);
}
