<?php
/**
 * @file
 * Default theme implementation to display a single Drupal page.
 *
 * The doctype, html, head and body tags are not in this template. Instead they
 * can be found in the html.tpl.php template in this directory.
 *
 * Available variables:
 *
 * Variables:
 * - $site_name: site name
 * - $questions: all available question of the test
 * - $test: all test data
 * - $question_number: questions number
 * - $time: test max time in minutes
 * - $seconds: test max time in seconds
 * - $next: next button text.
 *
 * @ingroup templates
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
    

?>
<section id="transactionResult">
    <div class="">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    
                    <h1 Class=""><?php echo $payment['Status'] == 'Succeeded' ? t('Success transaction') : t('Failed transaction'); ?></h1>
                    <?php if($payment['Status'] == 'Succeeded'): ?>
                    
                    <h3 class=""><?php echo t('Sikeresen fizettél :price-ot bankkártyával!', array(':price' => certify_format_price($payment['Total']) )); ?></h3>
                    
                    <p class=""><big><?php echo t('A tranzakció részletei:'); ?></big></p>
                
                    <p class=""><?php echo t('Fizetés időpontja: :created', array(':created' => date('Y-m-d H:i:s', strtotime($payment['CompletedAt'])) )); ?></p>
                    <p class=""><?php echo t('Fizetés Barion azonosítója: :payment', array(':payment' => $payment['PaymentId'] )); ?></p>
                    <p class=""><?php echo t('Rendelés azonosítója: :order', array(':order' => $payment['OrderNumber'] )); ?></p>

                    <?php else: ?>
                    
                    <h3 class=""><?php echo t('Nem sikerült kifizetned :price-ot bankkártyával!', array(':price' => certify_format_price($payment['Total']) )); ?></h3>
                    
                    <p class=""><big><?php echo t('A tranzakció részletei:'); ?></big></p>
                
                    <p class=""><?php echo t('Fizetés időpontja: :created', array(':created' => date('Y-m-d H:i:s', strtotime($payment['CompletedAt'])) )); ?></p>
                    <p class=""><?php echo t('Fizetés Barion azonosítója: :payment', array(':payment' => $payment['PaymentId'] )); ?></p>
                    <p class=""><?php echo t('Rendelés azonosítója: :order', array(':order' => $payment['OrderNumber'] )); ?></p>
                    
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<br><br>
<?php

//    crt_debug($payment);
    
?>
<style>
    .page-header {
        display: none;
    }
</style>

<script>
    
(function ($) {


    
})(jQuery);

    
</script>