<?php

require 'vendor/autoload.php';

use Billingo\API\Connector\HTTP\Request;

$private_key = isset($_POST['private_key']) ? $_POST['private_key'] : '';
$public_key  = isset($_POST['public_key'])  ? $_POST['public_key']  : '';
$function    = isset($_POST['function'])    ? $_POST['function']    : '';
$type        = isset($_POST['type'])        ? $_POST['type']        : '';
$post        = isset($_POST['post'])        ? $_POST['post']        : '';
$id          = isset($_POST['id'])          ? $_POST['id']          : '';

$billingo = new Request([
    'public_key'  => $public_key,
    'private_key' => $private_key
]);

// Get requests
if ($type == 'get'){
    if ($function == 'vat'){ // Clients

        if($id == ''){

            // Return all clients array
            $result  = $billingo->get('vat');

        } else {

            // Return one client data
            $result  = $billingo->get("vat/eu");

        }

    }
    if ($function == 'clients'){ // Clients

        if($id == ''){

            // Return all clients array
            $result  = $billingo->get('clients');

        } else {

            // Return one client data
            $result  = $billingo->get("clients/$id");

        }

    }
    else if ($function == 'products'){ // Products

        if($id == ''){

            // Return all clients array
            $result  = $billingo->get('products');

        } else {

            // Return one client data
            $result  = $billingo->get("products/$id");

        }

    }
    else if ($function == 'invoices'){ // Invoices

        if($id == ''){

            // Return all clients array
            $result  = $billingo->get('invoices');

        } else {

            // Return one client data
            $result  = $billingo->get("invoices/$id");

        }

    }
    else if ($function == 'invoice_link'){ // Invoices

        if($id != ''){

            // Return all clients array
            $code  = $billingo->get("invoices/$id/code")['code'];
            
            $result = "https://www.billingo.hu/access/c:$code";

        } else {

            // Return one client data
            $result  = FALSE;

        }

    }
    if ($function == 'generate'){ // Clients

        if($id != ''){

            // Return success
//            $result  = $billingo->get("invoices/$id/generate");
            
            // Create invoice
            try {
                $gen     = $billingo->get("invoices/$id/generate");
                $invoice = $billingo->get("invoices")[0];
                $result = $invoice;
            } catch (Exception $e) {
                $response['error'] = true;
                $response['messages'][] = $e->getMessage();
                $result = $response;
            }
            
            

        } else {

            // Return false
            $result  = FALSE;

        }

    }
}

// Post requests
if ($type == 'post'){
    if ($function == 'clients'){ // Clients
        
        if($post != ''){

            // Return all clients array 
            $result = $billingo->post("clients", json_decode($post));

        } else {

            // Return one client data
            $result  = FALSE;

        }
        
    }
    if ($function == 'products'){ // Clients
        
        if($post != ''){
            
            // Return all clients array 
            $result = $billingo->post("products", json_decode($post));

        } else {

            // Return one client data
            $result  = FALSE;

        }
        
    }
    if ($function == 'invoices'){ // Clients
        
        if($post != ''){
            
            // Create invoice
            try {
                $invoice = $billingo->post("invoices", json_decode($post) );
                $result = $invoice;
            } catch (Exception $e) {
                $response['error'] = true;
                $response['messages'][] = $e->getMessage();
                $result = $response;
            }

        } else {

            // Return one client data
            $result  = FALSE;

        }
        
    }
}

// Put requests
if ($type == 'put'){
    if ($function == 'clients'){ // Clients
        
        if($post != '' && $id != ''){

            // Update client
            $result = $billingo->put("clients/$id", json_decode($post));

        } else {

            // Return one client data
            $result  = FALSE;

        }
        
    }
}

bill_debug($result, true);
	
// Functions
function bill_debug($var, $json = FALSE){
	if ($json){
		header('Content-Type: application/json');
		echo json_encode($var);
	} else {
		echo '<pre>';
		print_r($var);
		echo '</pre>';
	}
}