<?php

/**
 * @file Here can test the module units.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
require_once 'barion_api.functions.inc';

/**
 * Unit test runner function.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function barion_api_unit_test() {

    global $user;
    $address = 'Budapest, Fő utca 18.';

    $order['uid'] = $user->uid;
    $order['oid'] = '3';
    $order['item'] = array(
        'name' => t('Test credit pack'),
        'description' => t('Creditpack what use for tests.'),
        'quantity' => 1,
        'unit' => t('credit pack'),
        'unitprice' => 17889,
        'itemtotal' => 17889,
        'sku' => 'BR-0052-MINTA'
    );
    $order['transaction'] = array(
        'title' => t('Credit order'),
        'total' => 17889,
        'hash' => 'TR-' . barion_api_get_transaction_unique_hash()
    );
    $order['payment'] = array(
        'oid' => '0003-MINTA',
        'hash' => 'PR-' . barion_api_get_payment_unique_hash(),
        'usermail' => $user->mail,
        'shipping' => $address,
    );

    $data = barion_api_get_payment('175f66bb1bd042c188bddd7243f20f23');

    mdd($data);
    exit();
}

/**
 * Unit test runner function for payment request.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function barion_api_unit_test_request($oid = '') {

    if ($oid == '') {
        $oid = barion_api_last_oid();
    }

    $order = membership_order_get_details($oid);
    $login = user_is_logged_in();

    if ($order['is_firm_invoice'] === 1) {
        $address = $order['firm_city'] . ', ' . $order['firm_address'];
    } else {
        $address = $order['city'] . ', ' . $order['address'];
    }

    $order['uid'] = $order['id'];
    $order['item'] = array(
        'name' => $order['name'],
        'description' => $order['proforma_name'],
        'quantity' => 1,
        'unit' => t('db'),
        'unitprice' => $order['price'],
        'itemtotal' => $order['price'],
        'sku' => 'ITEM-' . $order['pid'] . '-' . $order['hash']
    );
    $order['transaction'] = array(
        'title' => $order['name'],
        'total' => $order['price'],
        'hash' => 'TR-' . barion_api_get_transaction_unique_hash()
    );
    $order['payment'] = array(
        'oid' => $order['oid'],
        'hash' => 'PR-' . barion_api_get_payment_unique_hash(),
        'usermail' => $order['email'],
        'shipping' => $address,
    );
//    mdd($order, true);
//    barion_api_payment_request($order);

    $data = barion_api_get_payment('175f66bb1bd042c188bddd7243f20f23');

    mdd($data, true);
}

/**
 * Get the name field form the certify_candidate_groups table.
 * @param integer $cgid The unique id of the row.
 * @return string The name field value.
 * @author Müller Péter <egyeves@gmail.com>
 */
function barion_api_last_oid() {
    return db_query_range('SELECT oid FROM {membership_orders} ORDER BY oid DESC', 0, 1, array())->fetchField();
}
