<?php

define('ERROR_URL', 'http://' . $_SERVER[HTTP_HOST] . $_SERVER[REQUEST_URI] . '/');
define('THANK_YOU_PAGE', 'http://' . $_SERVER[HTTP_HOST] . '/node/');

/** @AC-REMOVE-START */
// Az Email Marketer API-ját beolvassuk.
//require_once 'intelligent_mailer.api.php';
/** @AC-REMOVE-END */

/** @AC-ADD-START */
  // ActiveCampaign API-ját belovassuk
  require_once("ac_api/includes/ActiveCampaign.class.php");
  $ac = new ActiveCampaign("https://hottiehu.api-us1.com", "a78d8a1cf9a44920f2a8424f36b0df3de027704ed64db438e33e290c7e9b43b6d93ff2b2");
/** @AC-ADD-END */

// A hibajelző változót hamsira (nincs hiba) állítjuk.
$error = FALSE;

// Megtisztítjuk a paramétereket, és az utónevet nagybetűssé alakítjuk.
$email = trim(check_plain($_POST['email']));
$nickname = capitalize(trim(check_plain($_POST['nickname'])));
$dm = isset($_POST['dm']) ? $_POST['dm'] : '0';
$gdpr = isset($_POST['gdpr']) ? $_POST['gdpr'] : '0';
/** @AC-REMOVE-START */
//$par = trim(im_check_plain($_POST['par']));
/** @AC-REMOVE-END */


// Nem üresek a mezők?
if (empty($email) || empty($nickname)) {
  error('Hiányzó mezők! Kérlek tölts ki minden szükséges mezőt a feliratkozáshoz.');
  $error = TRUE;
}

// Helyes az e-mail címe?
if (!is_valid_email($email)) {
  error('Hibás e-mail cím! Kérlek nézd meg újra az e-mail címed, és add meg helyesen.');
  $error = TRUE;
}

if (!$error) {

  /** @AC-REMOVE-START */
//  // Hozzáadjuk a feliratkozót az adatbázisahoz.
//  $result = json_decode(im_subscribeEmail($email, ''));
//  $id = $result->data->id;
//
//  // Hozzáadjuk az utónév mezőt a feliratkozókhoz.
//  $result = im_setSubscriberField($email, 'GaBiydUMho2Bv5ZWGEB4F5X2G8lnREw7y', $nickname);
//
//  // Ha nem üres a paraméter...
//  if (!empty($par)) {
//    // A stringből tömböt csinálunk | elválasztóval.
//    $tags = trim_explode('|', $par);
//    $labels = get_labels();
//    // Ellenőrizzüj, hogy a cimke létezik-e már az IM-ben.
//    foreach ($tags as $value) {
//      if (!in_array($value, $labels)) {
//        // Ha a címke nem létezik, létrehozzuk.
//        im_createLabel($value);
//      }
//    }
//    // Hozzáadjuk a címkéket a feliratkozóhoz.
//    im_modifySubscriberLabels($email, $tags, array());
//
//    // Hozzáadjuk a hirdetés azonosító mezőt a feliratkozókhoz.
//    $result = im_setSubscriberField($email, 'GLcGNoS00vkevLp4rgbrfWrMJvzq81wfJ', $par);
//  }
//
//  // Elindítjuk a szekvencián.
//  $result = im_startSubscriberSequence($email, 'GvRHVLw0zYUctqPzbmtlgxKlXD16KoqF1oPaFtptO');
//
//  // Elhelyezünk a gépén egy cookie-t, hogy ezen a gépen ne kapjon újra
//  // felugró ablakot, a feliratkozásra, ha egyszer már feliratkozott.
//  // Elhelyezzük a Cookie-t 4 évre.
//  setcookie('Hottie.subscribed', '1', time() + 60 * 60 * 24 * 365 * 4 + 1, '/');
  /** @AC-REMOVE-END */
  
  /** @AC-ADD-START */
  if ($gdpr == '1'){
	  $contact = array(
		'email' => $email,
		'first_name' => mb_ucwords($nickname),
		'last_name' => '',
		'phone' => '',
		'p[1]' => 1,
		'status[1]' => 1, // "Active" status
		'tags' => 'A_emails_a02_start, dm, gdpr',
	  );
  } else {
	  $contact = array(
		'email' => $email,
		'first_name' => mb_ucwords($nickname),
		'last_name' => '',
		'phone' => '',
		'p[1]' => 1,
		'status[1]' => 1, // "Active" status
		'tags' => 'A_emails_a02_start',
	  );
  }

  $contact_sync = $ac->api("contact/sync", $contact);

  if (!(int) $contact_sync->success) {
    // request failed
    $message = "Hiba történt a feliratkozáskor: $contact_sync->error Küldd el ezt az üzeletetet az info@omniparents.hu e-mail címre, hogy tudjunk neked segíteni.";
    header('Location: ' . ERROR_URL . "?error=$message");
    exit();
  }
/** @AC-ADD-END */
  
  // Átirányítjuk a Thank you page-re.
  header('Location: ' . THANK_YOU_PAGE . "?id=$id&email=$email");
}

/**
 * Ellenőrzi az email címet. 
 * 
 * @param string $email
 *   A nyers e-mail cím.
 * 
 * @return boolean
 *   TRUE ha az email korrekt és a domain létezik.
 */
function is_valid_email($email) {
  $isValid = true;
  $atIndex = strrpos($email, "@");
  if (is_bool($atIndex) && !$atIndex) {
    $isValid = false;
  } else {
    $domain = substr($email, $atIndex + 1);
    $local = substr($email, 0, $atIndex);
    $localLen = strlen($local);
    $domainLen = strlen($domain);
    if ($localLen < 1 || $localLen > 64) {
      // A helyi rész szabályos hosszát túlléptük.
      $isValid = false;
    } else if ($domainLen < 1 || $domainLen > 255) {
      // A domain rész szabályos hosszát túlléptük.
      $isValid = false;
    } else if ($local[0] == '.' || $local[$localLen - 1] == '.') {
      // A helyi rész '.'-ra végződik.
      $isValid = false;
    } else if (preg_match('/\\.\\./', $local)) {
      // A helyi részben két folyamatos pont van.
      $isValid = false;
    } else if (!preg_match('/^[A-Za-z0-9\\-\\.]+$/', $domain)) {
      // A karakter nem valós a domain részben.
      $isValid = false;
    } else if (preg_match('/\\.\\./', $domain)) {
      // A domain részben két folyamatos pont van.
      $isValid = false;
    } else if (!preg_match('/^(\\\\.|[A-Za-z0-9!#%&`_=\\/$\'*+?^{}|~.-])+$/', str_replace("\\\\", "", $local))) {
      // A karakter nem valós a helyi részben, kivéve ha idézett.
      if (!preg_match('/^"(\\\\"|[^"])+"$/', str_replace("\\\\", "", $local))) {
        $isValid = false;
      }
    }
    if ($isValid && !(checkdnsrr($domain, "MX") || checkdnsrr($domain, "A"))) {
      // A domain DNS rekordja nem található.
      $isValid = false;
    }
  }
  return $isValid;
}

/**
 * Nagybetűsítjük a stringet.
 * 
 * @param string $str
 *   A konvertálandó string.
 *  
 * @return string
 *   A string első betűje nagy a többi kicsi.
 */
function capitalize($str) {
  $outstr = ucfirst(strtolower($str));
  return $outstr;
}

function error($error_message) {
  header("Location: " . ERROR_URL . "?error=$error_message");
  //print "Error: $error_message";
}

/**
 * Explode the string then trims the values and remove the empty elements.
 * @param string $delimiter The delimither char.
 * @param string $string The string for exploding.
 * @return array The trimmed and not enplty exploded array elements.
 */
function trim_explode($delimiter, $string) {
  $tmp = explode($delimiter, $string);
  foreach ($tmp as $value) {
    $array[] = trim($value);
  }
  $array = array_diff($array, array(''));
  return $array;
}

/**
 * Get the label names from the IM into a single array.
 * @return array Array of the labels.
 */
function get_labels() {
  $im_labels = json_decode(im_GetLabels())->data;
  foreach ($im_labels as $value) {
    $labels[] = $value->label;
  }
  return $labels;
}

function mb_ucwords($str, $encoding = "UTF-8") {
  $oldEncoding = mb_internal_encoding();
  mb_internal_encoding($encoding);
  $retValue = mb_convert_case($str, MB_CASE_TITLE);
  mb_internal_encoding($oldEncoding);
  return $retValue;
}

function check_plain($text) {
  return htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
}
