Drupal.locale = { 'pluralFormula': function ($n) { return Number(($n!=1)); }, 'strings': {"":{"An AJAX HTTP error occurred.":"Egy AJAX HTTP hiba k\u00f6vetkezett be.","HTTP Result Code: !status":"HTTP eredm\u00e9nyk\u00f3d: !status","An AJAX HTTP request terminated abnormally.":"Az AJAX HTTP k\u00e9r\u00e9s rendellenesen megszakadt.","Debugging information follows.":"A hibakeres\u00e9si inform\u00e1ci\u00f3k k\u00f6vetkeznek.","Path: !uri":"\u00datvonal: !uri","StatusText: !statusText":"\u00c1llapot\u00fczenet: !statusText","ResponseText: !responseText":"V\u00e1lasz\u00fczenet: !responseText","ReadyState: !readyState":"K\u00e9sz\u00fclts\u00e9g: !readyState","CustomMessage: !customMessage":"Egy\u00e9ni \u00fczenet: !customMessage","No results":"Nincs eredm\u00e9ny","clear":"t\u00f6rl\u00e9s","All":"Mind","New":"\u00daj","Modules installed within the last week.":"Az elm\u00falt h\u00e9ten telep\u00edtett modulok.","No modules added within the last week.":"Az elm\u00falt h\u00e9ten nem voltak modulok telep\u00edtve.","Recent":"Friss","Modules enabled\/disabled within the last week.":"Az elm\u00falt h\u00e9ten telep\u00edtett vagy elt\u00e1vol\u00edtott modulok.","No modules were enabled or disabled within the last week.":"Az elm\u00falt h\u00e9ten nem voltak modulok telep\u00edtve vagy elt\u00e1vol\u00edtva.","@enabled of @total":"@enabled \/ @total","Select all rows in this table":"A t\u00e1bl\u00e1zat minden sor\u00e1nak kiv\u00e1laszt\u00e1sa","Deselect all rows in this table":"A kiv\u00e1laszt\u00e1s megsz\u00fcntet\u00e9se a t\u00e1bl\u00e1zat minden sor\u00e1ban","Hide":"Elrejt\u00e9s","Show":"Megjelen\u00edt\u00e9s","Configure":"Be\u00e1ll\u00edt\u00e1s","Loading token browser...":"Vez\u00e9rjel b\u00f6ng\u00e9sz\u0151 bet\u00f6lt\u00e9se...","Available tokens":"El\u00e9rhet\u0151 vez\u00e9rjelek","Insert this token into your form":"A vez\u00e9rjel besz\u00far\u00e1sa az \u0171rlapba","First click a text field to insert your tokens into.":"El\u0151sz\u00f6r r\u00e1 kell kattintani egy sz\u00f6veges mez\u0151re, ahov\u00e1 a vez\u00e9rjelet be kell sz\u00farni.","(active tab)":"(akt\u00edv f\u00fcl)","Re-order rows by numerical weight instead of dragging.":"A sorok \u00fajrarendez\u00e9se h\u00faz\u00e1s helyett numerikus s\u00falyuk alapj\u00e1n.","Show row weights":"Sorok s\u00faly\u00e1nak mutat\u00e1sa","Hide row weights":"A sorok s\u00faly\u00e1nak elrejt\u00e9se","Drag to re-order":"\u00c1trendez\u00e9s h\u00faz\u00e1ssal","Changes made in this table will not be saved until the form is submitted.":"A t\u00e1bl\u00e1zaton v\u00e9grehajtott v\u00e1ltoztat\u00e1sok az \u0171rlap bek\u00fcld\u00e9s\u00e9ig nem lesznek elmentve.","Disabled":"Tiltott","Enabled":"Enged\u00e9lyezett","Edit":"Szerkeszt\u00e9s","Add":"Hozz\u00e1ad\u00e1s","Done":"K\u00e9sz","Breadcrumbs":"Morzs\u00e1k","Tooltips":"Eszk\u00f6ztippek","@number comments per page":"@number hozz\u00e1sz\u00f3l\u00e1s egy oldalon","The selected file %filename cannot be uploaded. Only files with the following extensions are allowed: %extensions.":"%filename kiv\u00e1lasztott f\u00e1jl nem t\u00f6lthet\u0151 fel. Csak a k\u00f6vetkez\u0151 kiterjeszt\u00e9sek egyik\u00e9vel rendelkez\u0151 f\u00e1jlok t\u00f6lthet\u0151ek fel: %extensions.","Autocomplete popup":"Automatikusan kieg\u00e9sz\u00edt\u0151 felugr\u00f3 ablak","Searching for matches...":"Egyez\u00e9sek keres\u00e9se...","Responsive Images":"Alkalmazkod\u00f3 k\u00e9pek","Anchors":"Horgonyok","Responsive Tables":"Reszponz\u00edv t\u00e1bl\u00e1zatok","Inverse":"Ford\u00edtott","Popovers":"Felugr\u00f3 \u00fczenetek","@size Buttons":"@size Gombok","@shape Images":"@shape K\u00e9pek","CDN provider: %provider":"CDN sz\u00e1ll\u00edt\u00f3: %provider","Preview of the Bootstrap theme":"A \u003Cem\u003EBootstrap\u003C\/em\u003E smink el\u0151n\u00e9zete","Preview of the @title Bootswatch theme":"@title \u003Cem\u003EBootswatch\u003C\/em\u003E smink el\u0151n\u00e9zete","Status":"\u00c1llapot","Description":"Le\u00edr\u00e1s","Size":"M\u00e9ret","all":"mind","Other":"Egy\u00e9b","Select":"Kiv\u00e1laszt\u00e1s","@count year from now":"@count \u00e9v mostant\u00f3l","@count years from now":"@count \u00e9v mostant\u00f3l","Next":"K\u00f6vetkez\u0151","none":"nincs","Sunday":"vas\u00e1rnap","Monday":"h\u00e9tf\u0151","Tuesday":"kedd","Wednesday":"szerda","Thursday":"cs\u00fct\u00f6rt\u00f6k","Friday":"p\u00e9ntek","Saturday":"szombat","Filename":"F\u00e1jln\u00e9v","N\/A":"Nincs adat","OK":"OK","This field is required.":"Sz\u00fcks\u00e9ges mez\u0151.","Prev":"El\u0151z\u0151","Owner":"Tulajdonos","Mon":"h","Tue":"k","Wed":"sze","Thu":"cs","Fri":"p","Sat":"szo","Sun":"v","January":"janu\u00e1r","February":"febru\u00e1r","March":"m\u00e1rcius","April":"\u00e1prilis","May":"m\u00e1j","June":"j\u00fanius","July":"j\u00falius","August":"augusztus","September":"szeptember","October":"okt\u00f3ber","November":"november","December":"december","Today":"Ma","Jan":"jan","Mar":"m\u00e1r","Apr":"\u00e1pr","Jun":"j\u00fan","Jul":"j\u00fal","Aug":"aug","Sep":"szep","Oct":"okt","Nov":"nov","Dec":"dec","Su":"Va","Mo":"H\u00e9","Tu":"Ke","We":"Sz","Th":"Cs","Fr":"P\u00e9","Sa":"Sz","Not published":"Rejtett","Please wait...":"Egy pillanat...","mm\/dd\/yy":"hh\/nn\/\u00e9\u00e9","By @name on @date":"Szerz\u0151: @name (@date)","By @name":"Szerz\u0151: @name","Not in menu":"Nincs men\u00fcben","Alias: @alias":"\u00c1ln\u00e9v: @alias","No alias":"Nincs \u00e1ln\u00e9v","New revision":"\u00daj v\u00e1ltozat","The changes to these blocks will not be saved until the \u003Cem\u003ESave blocks\u003C\/em\u003E button is clicked.":"A blokkok v\u00e1ltoz\u00e1sai nem lesznek elmentve a \u003Cem\u003EBlokk ment\u00e9se\u003C\/em\u003E nyom\u00f3gombra kattint\u00e1sig.","This permission is inherited from the authenticated user role.":"Ezt a szerepk\u00f6rt minden azonos\u00edtott felhaszn\u00e1l\u00f3 megkapja.","No revision":"Nincs v\u00e1ltozat","Requires a title":"Sz\u00fcks\u00e9ges egy c\u00edm","Not restricted":"Nem korl\u00e1tozott","Not customizable":"Nem testreszabhat\u00f3","Restricted to certain pages":"Bizonyos oldalakra korl\u00e1tozva","The block cannot be placed in this region.":"A blokk nem helyezhet\u0151 el ebbe a r\u00e9gi\u00f3ba.","Hide summary":"\u00d6sszefoglal\u00f3 elrejt\u00e9se","Edit summary":"\u00d6sszefoglal\u00f3 szerkeszt\u00e9se","Don\u0027t display post information":"Ne jelen\u00edtse meg a bek\u00fcld\u00e9si inform\u00e1ci\u00f3t","The response failed verification so will not be processed.":"A v\u00e1laszt nem siker\u00fclt hiteles\u00edteni, ez\u00e9rt nem lesz feldolgozva.","The callback URL is not local and not trusted: !url":"!url visszah\u00edv\u00e1si URL nem e webhelyr\u0151l val\u00f3, ez\u00e9rt nem megb\u00edzhat\u00f3.","Show description":"Le\u00edr\u00e1s megjelen\u00edt\u00e9se","Hide description":"Le\u00edr\u00e1s elrejt\u00e9se","Ignored from settings":"Friss\u00edt\u00e9s figyel\u00e9s letiltva","Automatic alias":"Automatikus \u00e1ln\u00e9v","No redirects":"Nincs \u00e1tir\u00e1ny\u00edt\u00e1s","Select all":"Mindent kijel\u00f6l","Remove group":"Csoport t\u00f6rl\u00e9se","Apply (all displays)":"Alkalmaz\u00e1s (minden megjelen\u00edt\u00e9sre)","Apply (this display)":"Alkalmaz\u00e1s (erre a megjelen\u00edt\u00e9sre)","Revert to default":"Visszat\u00e9r\u00e9s az alap\u00e9rtelmez\u00e9shez","Inclusion: @value":"Bele\u00e9rtve: @value","Priority: @value":"Fontoss\u00e1g: @value","Deselect all":"Minden kiv\u00e1laszt\u00e1s megsz\u00fcntet\u00e9se","Media browser":"M\u00e9diab\u00f6ng\u00e9sz\u0151","Colorbox":"Colorbox","Start upload":"Felt\u00f6lt\u00e9s ind\u00edt\u00e1sa","Close":"Bez\u00e1r","Add files":"F\u00e1jlok hozz\u00e1ad\u00e1sa","Select files":"F\u00e1jlok kiv\u00e1laszt\u00e1sa","Add files to the upload queue and click the start button.":"Felt\u00f6lt\u00e9shez el\u0151bb f\u00e1jlokat kell adni a felt\u00f6lt\u00e9si sorhoz, majd a start gombra kell kattintani.","Stop current upload":"Jelenlegi felt\u00f6lt\u00e9s le\u00e1ll\u00edt\u00e1sa","Start uploading queue":"Felt\u00f6lt\u00e9si sor ind\u00edt\u00e1sa","Drag files here.":"F\u00e1jlokat h\u00faz\u00e1ssal lehet hozz\u00e1adni.","Uploaded %d\/%d files":"%d\/%d f\u00e1jl felt\u00f6ltve","File extension error.":"F\u00e1jlkiterjeszt\u00e9s-hiba.","File size error.":"F\u00e1jlm\u00e9ret-hiba.","Init error.":"Inicializ\u00e1l\u00e1si hiba.","HTTP Error.":"HTTP hiba.","Security error.":"Biztons\u00e1gi hiba.","Generic error.":"\u00c1ltal\u00e1nos hiba.","IO error.":"IO hiba.","Stop upload":"Felt\u00f6lt\u00e9s meg\u00e1ll\u00edt\u00e1sa","%d files queued":"%d f\u00e1jl \u00e1ll sorba","Please wait while your files are being uploaded.":"A f\u00e1jlok felt\u00f6lt\u00e9se folyamatban.","Show layout designer":"Elrendez\u00e9sszerkeszt\u0151 megjelen\u00edt\u00e9se","Hide layout designer":"Elrendez\u00e9sszerkeszt\u0151 elrejt\u00e9se","Remove this pane?":"T\u00e1bla elt\u00e1vol\u00edt\u00e1sa?","Geocoder failed due to: ":"A geok\u00f3dol\u00e1s meghi\u00fasult: ","Geocode was not successful for the following reason: ":"A geok\u00f3dol\u00e1s sikertelen volt a k\u00f6vetkez\u0151 ok miatt: "}} };;
(function ($) {

/**
 * Attach the machine-readable name form element behavior.
 */
Drupal.behaviors.machineName = {
  /**
   * Attaches the behavior.
   *
   * @param settings.machineName
   *   A list of elements to process, keyed by the HTML ID of the form element
   *   containing the human-readable value. Each element is an object defining
   *   the following properties:
   *   - target: The HTML ID of the machine name form element.
   *   - suffix: The HTML ID of a container to show the machine name preview in
   *     (usually a field suffix after the human-readable name form element).
   *   - label: The label to show for the machine name preview.
   *   - replace_pattern: A regular expression (without modifiers) matching
   *     disallowed characters in the machine name; e.g., '[^a-z0-9]+'.
   *   - replace: A character to replace disallowed characters with; e.g., '_'
   *     or '-'.
   *   - standalone: Whether the preview should stay in its own element rather
   *     than the suffix of the source element.
   *   - field_prefix: The #field_prefix of the form element.
   *   - field_suffix: The #field_suffix of the form element.
   */
  attach: function (context, settings) {
    var self = this;
    $.each(settings.machineName, function (source_id, options) {
      var $source = $(source_id, context).addClass('machine-name-source');
      var $target = $(options.target, context).addClass('machine-name-target');
      var $suffix = $(options.suffix, context);
      var $wrapper = $target.closest('.form-item');
      // All elements have to exist.
      if (!$source.length || !$target.length || !$suffix.length || !$wrapper.length) {
        return;
      }
      // Skip processing upon a form validation error on the machine name.
      if ($target.hasClass('error')) {
        return;
      }
      // Figure out the maximum length for the machine name.
      options.maxlength = $target.attr('maxlength');
      // Hide the form item container of the machine name form element.
      $wrapper.hide();
      // Determine the initial machine name value. Unless the machine name form
      // element is disabled or not empty, the initial default value is based on
      // the human-readable form element value.
      if ($target.is(':disabled') || $target.val() != '') {
        var machine = $target.val();
      }
      else {
        var machine = self.transliterate($source.val(), options);
      }
      // Append the machine name preview to the source field.
      var $preview = $('<span class="machine-name-value">' + options.field_prefix + Drupal.checkPlain(machine) + options.field_suffix + '</span>');
      $suffix.empty();
      if (options.label) {
        $suffix.append(' ').append('<span class="machine-name-label">' + options.label + ':</span>');
      }
      $suffix.append(' ').append($preview);

      // If the machine name cannot be edited, stop further processing.
      if ($target.is(':disabled')) {
        return;
      }

      // If it is editable, append an edit link.
      var $link = $('<span class="admin-link"><a href="#">' + Drupal.t('Edit') + '</a></span>')
        .click(function () {
          $wrapper.show();
          $target.focus();
          $suffix.hide();
          $source.unbind('.machineName');
          return false;
        });
      $suffix.append(' ').append($link);

      // Preview the machine name in realtime when the human-readable name
      // changes, but only if there is no machine name yet; i.e., only upon
      // initial creation, not when editing.
      if ($target.val() == '') {
        $source.bind('keyup.machineName change.machineName input.machineName', function () {
          machine = self.transliterate($(this).val(), options);
          // Set the machine name to the transliterated value.
          if (machine != '') {
            if (machine != options.replace) {
              $target.val(machine);
              $preview.html(options.field_prefix + Drupal.checkPlain(machine) + options.field_suffix);
            }
            $suffix.show();
          }
          else {
            $suffix.hide();
            $target.val(machine);
            $preview.empty();
          }
        });
        // Initialize machine name preview.
        $source.keyup();
      }
    });
  },

  /**
   * Transliterate a human-readable name to a machine name.
   *
   * @param source
   *   A string to transliterate.
   * @param settings
   *   The machine name settings for the corresponding field, containing:
   *   - replace_pattern: A regular expression (without modifiers) matching
   *     disallowed characters in the machine name; e.g., '[^a-z0-9]+'.
   *   - replace: A character to replace disallowed characters with; e.g., '_'
   *     or '-'.
   *   - maxlength: The maximum length of the machine name.
   *
   * @return
   *   The transliterated source string.
   */
  transliterate: function (source, settings) {
    var rx = new RegExp(settings.replace_pattern, 'g');
    return source.toLowerCase().replace(rx, settings.replace).substr(0, settings.maxlength);
  }
};

})(jQuery);
;
(function ($) {

Drupal.behaviors.textarea = {
  attach: function (context, settings) {
    $('.form-textarea-wrapper.resizable', context).once('textarea', function () {
      var staticOffset = null;
      var textarea = $(this).addClass('resizable-textarea').find('textarea');
      var grippie = $('<div class="grippie"></div>').mousedown(startDrag);

      grippie.insertAfter(textarea);

      function startDrag(e) {
        staticOffset = textarea.height() - e.pageY;
        textarea.css('opacity', 0.25);
        $(document).mousemove(performDrag).mouseup(endDrag);
        return false;
      }

      function performDrag(e) {
        textarea.height(Math.max(32, staticOffset + e.pageY) + 'px');
        return false;
      }

      function endDrag(e) {
        $(document).unbind('mousemove', performDrag).unbind('mouseup', endDrag);
        textarea.css('opacity', 1);
      }
    });
  }
};

})(jQuery);
;
(function ($) {

/**
 * Toggle the visibility of a fieldset using smooth animations.
 */
Drupal.toggleFieldset = function (fieldset) {
  var $fieldset = $(fieldset);
  if ($fieldset.is('.collapsed')) {
    var $content = $('> .fieldset-wrapper', fieldset).hide();
    $fieldset
      .removeClass('collapsed')
      .trigger({ type: 'collapsed', value: false })
      .find('> legend span.fieldset-legend-prefix').html(Drupal.t('Hide'));
    $content.slideDown({
      duration: 'fast',
      easing: 'linear',
      complete: function () {
        Drupal.collapseScrollIntoView(fieldset);
        fieldset.animating = false;
      },
      step: function () {
        // Scroll the fieldset into view.
        Drupal.collapseScrollIntoView(fieldset);
      }
    });
  }
  else {
    $fieldset.trigger({ type: 'collapsed', value: true });
    $('> .fieldset-wrapper', fieldset).slideUp('fast', function () {
      $fieldset
        .addClass('collapsed')
        .find('> legend span.fieldset-legend-prefix').html(Drupal.t('Show'));
      fieldset.animating = false;
    });
  }
};

/**
 * Scroll a given fieldset into view as much as possible.
 */
Drupal.collapseScrollIntoView = function (node) {
  var h = document.documentElement.clientHeight || document.body.clientHeight || 0;
  var offset = document.documentElement.scrollTop || document.body.scrollTop || 0;
  var posY = $(node).offset().top;
  var fudge = 55;
  if (posY + node.offsetHeight + fudge > h + offset) {
    if (node.offsetHeight > h) {
      window.scrollTo(0, posY);
    }
    else {
      window.scrollTo(0, posY + node.offsetHeight - h + fudge);
    }
  }
};

Drupal.behaviors.collapse = {
  attach: function (context, settings) {
    $('fieldset.collapsible', context).once('collapse', function () {
      var $fieldset = $(this);
      // Expand fieldset if there are errors inside, or if it contains an
      // element that is targeted by the URI fragment identifier.
      var anchor = location.hash && location.hash != '#' ? ', ' + location.hash : '';
      if ($fieldset.find('.error' + anchor).length) {
        $fieldset.removeClass('collapsed');
      }

      var summary = $('<span class="summary"></span>');
      $fieldset.
        bind('summaryUpdated', function () {
          var text = $.trim($fieldset.drupalGetSummary());
          summary.html(text ? ' (' + text + ')' : '');
        })
        .trigger('summaryUpdated');

      // Turn the legend into a clickable link, but retain span.fieldset-legend
      // for CSS positioning.
      var $legend = $('> legend .fieldset-legend', this);

      $('<span class="fieldset-legend-prefix element-invisible"></span>')
        .append($fieldset.hasClass('collapsed') ? Drupal.t('Show') : Drupal.t('Hide'))
        .prependTo($legend)
        .after(' ');

      // .wrapInner() does not retain bound events.
      var $link = $('<a class="fieldset-title" href="#"></a>')
        .prepend($legend.contents())
        .appendTo($legend)
        .click(function () {
          var fieldset = $fieldset.get(0);
          // Don't animate multiple times.
          if (!fieldset.animating) {
            fieldset.animating = true;
            Drupal.toggleFieldset(fieldset);
          }
          return false;
        });

      $legend.append(summary);
    });
  }
};

})(jQuery);
;

(function ($) {

Drupal.behaviors.commentFieldsetSummaries = {
  attach: function (context) {
    $('fieldset.comment-node-settings-form', context).drupalSetSummary(function (context) {
      return Drupal.checkPlain($('.form-item-comment input:checked', context).next('label').text());
    });

    // Provide the summary for the node type form.
    $('fieldset.comment-node-type-settings-form', context).drupalSetSummary(function(context) {
      var vals = [];

      // Default comment setting.
      vals.push($(".form-item-comment select option:selected", context).text());

      // Threading.
      var threading = $(".form-item-comment-default-mode input:checked", context).next('label').text();
      if (threading) {
        vals.push(threading);
      }

      // Comments per page.
      var number = $(".form-item-comment-default-per-page select option:selected", context).val();
      vals.push(Drupal.t('@number comments per page', {'@number': number}));

      return Drupal.checkPlain(vals.join(', '));
    });
  }
};

})(jQuery);
;
(function ($) {

Drupal.behaviors.menuChangeParentItems = {
  attach: function (context, settings) {
    $('fieldset#edit-menu input').each(function () {
      $(this).change(function () {
        // Update list of available parent menu items.
        Drupal.menu_update_parent_list();
      });
    });
  }
};

/**
 * Function to set the options of the menu parent item dropdown.
 */
Drupal.menu_update_parent_list = function () {
  var values = [];

  $('input:checked', $('fieldset#edit-menu')).each(function () {
    // Get the names of all checked menus.
    values.push(Drupal.checkPlain($.trim($(this).val())));
  });

  var url = Drupal.settings.basePath + 'admin/structure/menu/parents';
  $.ajax({
    url: location.protocol + '//' + location.host + url,
    type: 'POST',
    data: {'menus[]' : values},
    dataType: 'json',
    success: function (options) {
      // Save key of last selected element.
      var selected = $('fieldset#edit-menu #edit-menu-parent :selected').val();
      // Remove all exisiting options from dropdown.
      $('fieldset#edit-menu #edit-menu-parent').children().remove();
      // Add new options to dropdown.
      jQuery.each(options, function(index, value) {
        $('fieldset#edit-menu #edit-menu-parent').append(
          $('<option ' + (index == selected ? ' selected="selected"' : '') + '></option>').val(index).text(value)
        );
      });
    }
  });
};

})(jQuery);
;

(function ($) {

Drupal.behaviors.xmlsitemapFieldsetSummaries = {
  attach: function (context) {
    $('fieldset#edit-xmlsitemap', context).drupalSetSummary(function (context) {
      var vals = [];

      // Inclusion select field.
      var status = $('#edit-xmlsitemap-status option:selected').text();
      vals.push(Drupal.t('Inclusion: @value', { '@value': status }));

      // Priority select field.
      var priority = $('#edit-xmlsitemap-priority option:selected').text();
      vals.push(Drupal.t('Priority: @value', { '@value': priority }));

      return vals.join('<br />');
    });
  }
};

})(jQuery);
;
/**
 * @file
 * Enhancements for webform node type forms.
 */

(function ($) {

  "use strict";

  Drupal.behaviors.webformContentTypes = {
    attach: function (context) {
      // Provide the vertical tab summaries.
      $('fieldset#edit-webform', context).drupalSetSummary(function (context) {
        var vals = [];
        $('input[type=checkbox]', context).each(function () {
          if (this.checked && this.attributes['data-enabled-description']) {
            vals.push(this.attributes['data-enabled-description'].value);
          }
          else if (!this.checked && this.attributes['data-disabled-description']) {
            vals.push(this.attributes['data-disabled-description'].value);
          }
        });
        return vals.join(', ');
      });
    }
  };
})(jQuery);
;
(function ($) {

Drupal.behaviors.contentTypes = {
  attach: function (context) {
    // Provide the vertical tab summaries.
    $('fieldset#edit-submission', context).drupalSetSummary(function(context) {
      var vals = [];
      vals.push(Drupal.checkPlain($('#edit-title-label', context).val()) || Drupal.t('Requires a title'));
      return vals.join(', ');
    });
    $('fieldset#edit-workflow', context).drupalSetSummary(function(context) {
      var vals = [];
      $("input[name^='node_options']:checked", context).parent().each(function() {
        vals.push(Drupal.checkPlain($(this).text()));
      });
      if (!$('#edit-node-options-status', context).is(':checked')) {
        vals.unshift(Drupal.t('Not published'));
      }
      return vals.join(', ');
    });
    $('fieldset#edit-display', context).drupalSetSummary(function(context) {
      var vals = [];
      $('input:checked', context).next('label').each(function() {
        vals.push(Drupal.checkPlain($(this).text()));
      });
      if (!$('#edit-node-submitted', context).is(':checked')) {
        vals.unshift(Drupal.t("Don't display post information"));
      }
      return vals.join(', ');
    });
  }
};

})(jQuery);
;
