<?php
/**
 * @file
 * A termékcsoportok adminisztrálása
 */

/**
 * Sales-ek adminisztrálása - Listázás
 */
function membership_sales_list() {
  $html = '';
    
  $header = array(
    array('data' => 'sid', 'field' => 'sid', 'sort' => 'asc'),
    array('data' => t('Sales neve'), 'field' => 'name'),
    array('data' => t('Műveletek')),
  );
  
  $result = db_select('membership_sales', 's')
    ->extend('PagerDefault')
    ->limit(variable_get('membership_list_limit_sales'))
    ->extend('TableSort')
    ->orderByHeader($header)
    ->fields('s', array('sid','name'))
    ->execute();
           
  $rows = array();
  
  foreach ($result as $value) {
    $links = l(t('Edit'), "admin/config/membership/sales/edit/$value->sid").
      '&nbsp;&nbsp;'.
      l(t('Delete'), "admin/config/membership/sales/delete/$value->sid"
    );
    
    $rows[]= array(
      'data' => array(
        $value->sid,
        $value->name,
        $links,
      )
    );
  }  

  $html .= theme('table', array(
    'header' => $header,
    'rows'=>$rows,
    'caption' => t('Sales-ek tábalája'),
    'sticky' => TRUE,                        
    'empty' => t('Nincsenek még sales-ek.'),
  ));
     
  $html .= theme('pager',array('tags' => array()));

  return $html;
} 

/**
 * Implements hook_form().
 * Termékcsoportok adminisztrálása - Hozzáadás.
 */
function membership_sales_add_form($form, &$form_state) {
  $form = array();
  
  $form['overview'] = array(
    '#markup' => t('Ezen a felületen lehet hozzáadni új sales-eket.'),
    '#prefix' => '<p>',
    '#suffix' => '</p>',
  );
  
  $form['name'] = array(
    '#title' => t('Sales neve'),
    '#description' => t('A sales neve.'),
    '#type' => 'textfield',
    '#required' => TRUE,
  );
  
  $form['description'] = array(
    '#title' => t('Sales leírása'),
    '#description' => t('A sales leírása.'),
    '#type' => 'textarea',
    '#required' => TRUE,
  );
  
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => 'Sales mentése',
  );
  
  return $form;
}

function membership_sales_add_form_validate($form, &$form_state) {
  $name = $form_state['values']['name'];
  $row = db_query('SELECT sid FROM {membership_sales} WHERE name = :name', array(':name' => $name))->fetchObject();
  if(isset($row->sid)) {
    form_set_error('name', t('Ezen a néven már létezik sales a rendszerben.'));
  } 
}

function membership_sales_add_form_submit($form, &$form_state) {
  $s_fields = array(
    'name' => trim($form_state['values']['name']),
    'description' => trim($form_state['values']['description']),
    );
 
  $sid = db_insert('membership_sales')->fields($s_fields)->execute();
  
  // Átirányítás a listázás oldalra.
  $form_state['redirect'] = array('admin/config/membership/sales',
    array(
      'query' => array(),
      'fragment' => '',
    ),
  );
  
  // Üzenet kiírása az oldalon és az esemény rögzítése a watchdog-ba.
  drupal_set_message(t('<em>@name</em> nevű sales belüldve.', array('@name' => $s_fields['name'])));
  watchdog('membership', t('<em>@name</em> nevű sales beküldve.', array('@name' => $s_fields['name'])), WATCHDOG_NOTICE);
}
 
/**
 * Implements hook_form().
 * Termékcsoportok adminisztrálása - Szerkesztés.
 */
function membership_sales_edit_form($form, &$form_state, $sid) {
  $sales = db_query_range("SELECT * FROM {membership_sales} WHERE sid = :sid", 0, 1, array(':sid' => $sid))->fetchObject();
  
  drupal_set_message(t('SID: <em>@name</em>', array('@name' => $sid)));  
  $form = array();
  
  $form['overview'] = array(
    '#markup' => t('Ezen a felületen lehet szerkeszteni a salest.'),
    '#prefix' => '<p>',
    '#suffix' => '</p>',
  );
  
  $form['name'] = array(
    '#title' => t('Sales neve'),
    '#description' => t('A sales neve.'),
    '#type' => 'textfield',
    '#required' => TRUE,
    '#default_value' => $sales->name,
  );
  
    $form['description'] = array(
    '#title' => t('Sales leírása'),
    '#description' => t('A sales leírása.'),
    '#type' => 'textarea',
    '#required' => TRUE,
    '#default_value' => $sales->description,
  );
  
  
  // A sales régi nevét megtartjuk, hogy a watchdog-ba rögzíteni lehessen.
  $form['old_name'] = array(
    '#type' => 'hidden',
    '#default_value' => $sales->name,
  );
  
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => 'Sales mentése',
  );
  
  return $form;
}

function membership_sales_edit_form_validate($form, &$form_state) {
  $name = $form_state['values']['name'];
  $sid = $form_state['build_info']['args'][0];  
  $row = db_query('SELECT sid FROM {membership_sales} WHERE name = :name AND sid != :sid', array(':name' => $name, ':sid' => $sid,))->fetchObject();
  if(isset($row->sid)) {
    form_set_error('name', t('Ezen a néven már létezik sales a rendszerben.'));
  } 
}

function membership_sales_edit_form_submit($form, &$form_state) {
  $s_fields = array('name' => trim($form_state['values']['name']),);
  $sid = $form_state['build_info']['args'][0];
  
  $num_updated = db_update('membership_sales')->fields($s_fields)->condition('sid', $sid, '=')->execute();
  
  // Átirányítás a listázás oldalra.
  $form_state['redirect'] = array('admin/config/membership/sales',
    array(
      'query' => array(),
      'fragment' => '',
    ),
  );
  
  // Üzenet kiírása az oldalon és az esemény rögzítése a watchdog-ba.
  drupal_set_message(t('A sales sikeresen megváltozott.'));
  watchdog('membership', 'A sales sikeresen megváltozott. Régi név: <em>@old_name</em> Az új név: <em>@name</em>', 
    array('@old_name' => $form_state['values']['old_name'], '@name' => $s_fields['name']), WATCHDOG_NOTICE);
}
 
/**
 * Implements hook_form()
 * Sales adminisztrálása - Törlés.
 */
function membership_sales_delete_form($form, &$form_state, $pgid) {
  $result = db_query_range("SELECT name FROM {membership_sales} WHERE sid = :sid", 0, 1, array(':sid' => $sid))->fetchField();  
    
  $form = array();  
  $form['sid'] = array(
    '#type' => 'value',
    '#value' => $sid,
  );
  
  // A termékcsoport régi nevét megtartjuk, hogy a watchdog-ba rögzíteni lehessen.
  $form['name'] = array(
    '#type' => 'hidden',
    '#default_value' => $result,
  );
  return confirm_form(
    $form,
    t('<em>"'.$result.'"</em> biztosan törölhető?'),
    'admin/config/membership/sales',
    t('Ez a művelet nem vonható vissza.'),
    t('Delete'),
    t('Cancel')
  );
}

function membership_sales_delete_form_submit($form, &$form_state) {
  $sid= array('name' => $form_state['values']['sid']);
    
  $num_deleted = db_delete('membership_sales')->condition('sid', $sid, '=')->execute();
     
  // Átirányítás a listázás oldalra.
  $form_state['redirect'] = array('admin/config/membership/sales',
    array(
      'query' => array(),
      'fragment' => '',
    ),
  );
  
  // Üzenet kiírása az oldalon és az esemény rögzítése a watchdog-ba.
  drupal_set_message(t('A sales sikeresen törölve.'));
  watchdog('membership', '<em>@name</em> nevű sales törölve lett.', array('@name' => $form_state['values']['name']), WATCHDOG_NOTICE);
}
