<?php

/**
 * @file
 * A proforma számla megjelenítő és elkészítő rutinja.
 */
function membership_proforma_form($form, &$form_state) {
    global $user;

    // A paraméterek ellenőrzése.
    // Az id alapján döntjük majd el, hogy megjelenítsük-e a díjbekérőt.
    $id = 0;
    if (isset($_GET['oid'])) {
        // Ha meg van adva a rendelés azonosító.
        $oid = trim(check_plain($_GET['oid']));
        if ($user->uid > 0) {
            // A rendelés azonosító alapján beolvassuk a felhasználó
            // azonosítóját.
            $id = db_query_range('SELECT id FROM {membership_orders} WHERE oid = :oid', 0, 1, array(':oid' => $oid,))->fetchField();
            $uid = db_query_range('SELECT uid FROM {membership_users} WHERE id = :id', 0, 1, array(':id' => $id,))->fetchField();
            if (!user_access('administer membership') && $user->uid != $uid) {
                // Ha nem adminisztrátor és nem egyezik a megtalált felhasználói
                // azonosítója a rendszereben tárolttal, az id-t lenullázzuk, hogy
                // hibaüzenetet adjon.
                $id = 0;
            }
        } else {
            // Ha a felhasználó nem azonosított, ellenőrizzük adott-e meg
            // hash kódot.
            if (isset($_GET['hash'])) {
                // Ha megadott beolvassuk, a hash kódot.
                $hash = trim(check_plain($_GET['hash']));
                // Beolvassuk az id-t.
                $id = db_query_range('SELECT id FROM {membership_orders} WHERE oid = :oid', 0, 1, array(':oid' => $oid,))->fetchField();
                // Megnézzük, hogy a hashkód létezik-e, és visszaadjuk az id-t.
                $is_hash_valid = db_query_range('SELECT id FROM {membership_users} WHERE hash = :hash', 0, 1, array(':hash' => $hash,))->fetchField();
                // Ha a hash egyezik, visszadja az id-t, ha nem akkor üres
                // változót ad vissza, amivel felülírjuk az id értékét,
                $id = $is_hash_valid;
                if (!$id) {
                    // Ha az id 0, akkor hibaüzenetet írunk ki.
                    drupal_set_message(t('Hibás paraméterek, ezért a díjbekérő levelet nem lehet kiállítani.'), 'error');
                }
            } else {
                // Ha nem adott meg hash kódot, hibát adunk vissza.
                drupal_set_message(t('Nem megfelelő paraméterek, ezért a díjbekérő levelet nem lehet kiállítani.'), 'error');
            }
        }
    } else {
        // Ha a rendelés azonosító hiányzik, nem tudjuk miről állítsuk ki
        // a proforma számlát.
        drupal_set_message(t('Nincsenek paraméterek, ezért a díjbekérő levelet nem lehet kiállítani.'), 'error');
    }

    // Ha minden helyes, létrehozzuk az oldalt.
    if ($id) {
        $link = membership_create_proforma($id, $oid);

        $html = '<h1>Díjbekérő levél</h1>';
        $html .= '<p>A díjbekérő leveled innen töltheted le:</p>';
        $html .= '<p><a class="btn btn-primary" href="' . $link . '">Díjbekérő levél letöltése</a></p>';
        $html .= '<p>Ha a gombra kattintva nem jelenik meg a díjbekérő levél, kattints jobb egér gombbal rá és a felugró menüből válaszd a <em>Hivatkozás mentése másnéven...</em> pontot.</p>';

        $form = array();

        $form['text'] = array(
            '#type' => 'item',
            '#markup' => $html,
        );

        return $form;
    }
}

function membership_create_proforma($id, $oid) {
    require_once 'tfpdf/tfpdf.php';

    $user = db_query_range('SELECT * FROM {membership_users} WHERE id = :id', 0, 1, array(':id' => $id))->fetchObject();
    $country = db_query_range('SELECT name FROM {membership_country} WHERE code = :code', 0, 1, array(':code' => $user->country,))->fetchField();

    // A rendelések lekérdezése.
    $query = db_select('membership_orders', 'o');
    // Hozzákapcsoljuk a termék nevét.
    $query->join('membership_products', 'p', 'o.pid = p.pid');
    // Lekérdezzük a mezőket.
    $query->fields('p', array('proforma_name'));
    $query->fields('o', array('oid', 'pid', 'price', 'shipping', 'created'));
    // Csak azt, ahol egyezik a rendelés azonosító.
    $query->condition('o.oid', $oid, '=');
    // Csak egy darabot mert minden rendelés egyedi.
    $query->range(0, 1);
    $order = $query->execute()->fetchObject();

    // A rendelés azonosító szám létrehozása.
    $identification = variable_get('membership_firm_invoice_prefix') . "-$oid-$id";

    $pdf = new tFPDF('P', 'mm', 'A4');
    $pdf->AddFont('DejaVu', '', 'DejaVuSans.ttf', true);
    $pdf->AddFont('DejaVuB', '', 'DejaVuSans-Bold.ttf', true);
    $pdf->AddFont('DejaVuI', '', 'DejaVuSans-Oblique.ttf', true);
    $pdf->SetTopMargin(15);
    $pdf->AddPage();
    $pdf->SetFont('DejaVuB', '', 18);
    $pdf->Cell(190, 10, "DÍJBEKÉRŐ LEVÉL", 0, 0, 'C');
    $pdf->Ln(6);
    $pdf->SetFont('DejaVu', '', 14);
    $pdf->Cell(190, 10, "(PROFORMA SZÁMLA)", 0, 0, 'C');
    $pdf->Ln(16);
    $pdf->SetFont('DejaVuI', '', 12);
    $pdf->Cell(95, 10, "Sorszáma: $identification", 0, 0, 'L'); // rendelés azonosító prefix-userid-order
    //----- Dobozok ----- //
    $pdf->SetFont('DejaVuB', '', 12);
    $pdf->SetXY(10, 46);
    $pdf->Cell(95, 10, "Kiállító:", 0, 0, 'L');
    $pdf->SetFont('DejaVu', '', 12);
    $pdf->Ln(10);
    $pdf->Cell(95, 10, variable_get('membership_firm_name'), 0, 0, 'L');
    $pdf->Ln(6);
    $pdf->Cell(95, 10, 'H-' .
            variable_get('membership_firm_zip') . ' ' .
            variable_get('membership_firm_city') . ' ' .
            variable_get('membership_firm_street_name') . ' ' .
            variable_get('membership_firm_street_type') . ' ' .
            variable_get('membership_firm_street_no'), 0, 0, 'L');
    $pdf->Ln(6);
    $pdf->Cell(95, 10, 'Adószám: ' . variable_get('membership_firm_taxid'), 0, 0, 'L');
    $pdf->Ln(10);
    $pdf->Cell(95, 10, 'Számlavezető: ' . variable_get('membership_firm_account_holder'), 0, 0, 'L');
    $pdf->Ln(6);
    $pdf->Cell(95, 10, variable_get('membership_firm_account'), 0, 0, 'L');
    $pdf->Ln(6);
    $pdf->Rect(10, 46, 95, 50, 'D');
    $pdf->Rect(105, 46, 95, 50, 'D');
    $pdf->SetXY(105, 46);
    $pdf->SetFont('DejaVuB', '', 12);
    $pdf->Cell(95, 10, "Vásárló:", 0, 0, 'L');
    $pdf->SetFont('DejaVu', '', 12);
    $pdf->Ln(10);
    // Ha magyarországról van szól, nem írjuk bele a címbe.
    if ($user->country == 'HU')
        $country = '';
    if (!$user->is_firm_invoice) {
        // Normál számla.
        $pdf->SetX(105);
        $pdf->Cell(95, 10, "$user->lastname $user->firstname", 0, 0, 'L');
        $pdf->Ln(6);
        $pdf->SetX(105);
        $pdf->Cell(95, 10, "$user->zip $user->city", 0, 0, 'L');
        $pdf->Ln(6);
        $pdf->SetX(105);
        $pdf->Cell(95, 10, $user->address, 0, 0, 'L');
        $pdf->Ln(6);
        $pdf->SetX(105);
        $pdf->Cell(95, 10, $country, 0, 0, 'L');
    } else {
        // Céges számla.
        $pdf->SetX(105);
        $pdf->Cell(95, 10, $user->firm_name, 0, 0, 'L');
        $pdf->Ln(6);
        $pdf->SetX(105);
        $pdf->Cell(95, 10, "$user->firm_zip $user->firm_city", 0, 0, 'L');
        $pdf->Ln(6);
        $pdf->SetX(105);
        $pdf->Cell(95, 10, "$user->firm_address", 0, 0, 'L');
        $pdf->Ln(6);
        $pdf->SetX(105);
        $pdf->Cell(95, 10, "Adószám: $user->firm_taxid", 0, 0, 'L');
    }
    $pdf->Ln(23);
    $pdf->Cell(95, 10, "Jelen díjbekérő levél ÁFA visszaigénylésre nem jogosít.", 0, 0, 'L');
    $pdf->Ln(6);
    $pdf->Cell(95, 10, "A számla a pénzügyi teljesítést követően kerül kiállításra.", 0, 0, 'L');
    $pdf->Ln(15);

    $sku = $order->pid;
    $price = $order->price + $order->shipping;

    $vatplus = (100 + variable_get('membership_firm_invoice_vat')) / 100;
    $net_price = number_format($price / $vatplus, 0, ',', ' ');
    $net_unit_price = $net_price;
    $vat = number_format($price - ($price / $vatplus), 0, ',', ' ');
    $price = number_format($price, 0, ',', ' ');

    $header = array("Cikkszám", "Megnevezés", "M.e.", "Menny", "Nettó egységár", "Nettó ár", "ÁFA %", "ÁFA érték", "Bruttó ár");
    $invoice = array($sku, $order->proforma_name, "db", "1", "$net_unit_price Ft", "$net_price Ft", variable_get('membership_firm_invoice_vat') . '%', "$vat Ft", "$price Ft");
    $cwidth = array(20, 34, 9, 16, 32, 22, 15, 22, 22);

    $pdf->SetFont('DejaVuB', '', 10);
    for ($i = 0; $i < count($header); $i++) {
        $pdf->Cell($cwidth[$i], 7, $header[$i], 1, 0, 'C');
    }
    $pdf->Ln();
    $pdf->SetFont('DejaVu', '', 10);
    for ($i = 0; $i < count($invoice); $i++) {
        $pdf->Cell($cwidth[$i], 7, $invoice[$i], 1, 0, 'C');
    }
    $pdf->Ln(10);
    $pdf->SetFont('DejaVuB', '', 12);
    $pdf->Cell(70, 10, 'Fizetendő teljes összeg:', 0, 0, 'L');
    $pdf->SetFont('DejaVuB', 'U', 12);
    $pdf->Cell(50, 10, "$price Ft", 0, 0, 'L');
    $pdf->Ln(10);
    $pdf->SetFont('DejaVuB', '', 12);
    $pdf->Cell(70, 10, 'Fizetés módja', 0, 0, 'L');
    $pdf->SetFont('DejaVuB', 'U', 12);
    $pdf->Cell(50, 10, 'átutalás', 0, 0, 'L');
    $pdf->Ln(10);
    $pdf->SetFont('DejaVuI', '', 12);
    $pdf->Cell(70, 10, 'Díjbekérő levél kelte:', 0, 0, 'L');
    $pdf->Cell(50, 10, date("Y-m-d", $order->created), 0, 0, 'L');
    $pdf->Ln(6);
    $pdf->Cell(70, 10, 'Fizetési határidő:', 0, 0, 'L');
    $pdf->Cell(50, 10, date("Y-m-d", $order->created + variable_get('membership_firm_invoice_payment_deadline') * 86400), 0, 0, 'L');
    $pdf->Ln(20);
    $pdf->SetFont('DejaVuB', 'U', 12);
    $pdf->Cell(70, 10, 'Fontos!', 0, 0, 'L');
    $pdf->Ln(10);
    $pdf->SetFont('DejaVu', '', 12);
    $pdf->MultiCell(190, 6, 'Az utalás esetén kérlek a közleménybe írd be a számla alján található rendelésazonosító számot! Enélkül nem tudjuk azonosítani a befizetésed. Bármilyen kérdésed vagy kérésed van, ezekkel a számokkal tudod magad azonosítani. A közleménybe tehát csak a lent található azonosító számot írd!', 0, 'J');
    $pdf->Ln(6);
    $pdf->SetFont('DejaVuB', '', 18);
    $pdf->Cell(190, 10, 'Rendelésazonosító:', 0, 0, 'C');
    $pdf->Ln(8);
    $pdf->SetFont('DejaVu', '', 18);
    $pdf->Cell(190, 10, $identification, 0, 0, 'C');

    $uri = "public://proforma/$identification-$user->hash.pdf";
    $path = file_create_url($uri);
    $output = $pdf->Output("$uri", 'F');

    return $path;
}
