<?php

/**
 * @file
 * A tagságok aktiválásáért felelő rutin.
 */
require_once 'lib.php';
require_once 'membership.email.inc';
require_once 'membership.invoices.inc';
require_once('ac_api/includes/ActiveCampaign.class.php');

function membership_activate_form($form, &$form_state) {
  $form = array();

  if (empty($form_state['storage']['find_the_order'])) {
    $form['oid'] = array(
      '#title' => t('A rendelés azonosítója'),
      '#description' => t('A rendelésből az azonosító szöveg után is számsor. Vagyis a kiemelt rész: <em>1ev-<strong>3167</strong>-1230</em>.'),
      '#type' => 'textfield',
      '#required' => TRUE,
    );

    $form['search'] = array(
      '#type' => 'submit',
      '#value' => 'Keresés',
      '#validate' => array('membership_search_oid'),
    );
  } else {
    $user = $form_state['storage']['user'];
    $order = $form_state['storage']['order'];
    $product = db_query_range('SELECT name, proforma_name, commission FROM {membership_products} WHERE pid = :pid', 0, 1, array(':pid' => $order->pid,))->fetchObject();

    $product_name = $product->name;
    $proforma_name = $product->proforma_name;

    // Összeállítjuk a magánszemélynek szóló rendelését.
    $user_data = "$user->lastname $user->firstname, <em>$user->zip. $user->city, $user->address";
    if ($user->country != 'HU') {
      // Ha nem magyarországi cím, akkor kiírjuk azt ország nevét is.
      $country = db_query('SELECT * FROM {membership_country} ORDER BY name ASC')->fetchAllKeyed();
      $user_data .= ', ' . $country[$user->country];
    }
    $user_data .= '</em>';
    $options = array(0 => $user_data,);

    // Ha céges számlát kért összeállítjuk a cégadatokat is.
    if ($user->is_firm_invoice) {
      $firm_data = "$user->firm_name, <em>$user->firm_zip. $user->firm_city, $user->firm_address (Adószám: $user->firm_taxid)</em>";
      $options[1] = $firm_data;
    }

    $form['order'] = array(
      '#type' => 'fieldset',
      '#title' => t("$product_name aktiválása"),
      '#collapsible' => TRUE,
      '#collapsed' => FALSE,
    );

    $form['order']['is_firm_invoice'] = array(
      '#type' => 'radios',
      '#title' => t('Megrendelő adatai'),
      '#default_value' => $user->is_firm_invoice,
      '#options' => $options,
      '#required' => TRUE,
    );

    $form['order']['price'] = array(
      '#type' => 'textfield',
      '#title' => t('A fizetett összeg'),
      '#size' => 12,
      '#maxlength' => 9,
      '#required' => TRUE,
      '#default_value' => $order->price,
    );

    $form['submit'] = array(
      '#type' => 'submit',
      '#value' => 'Aktiválás',
    );

    $form['id'] = array(
      '#type' => 'hidden',
      '#default_value' => $user->id,
    );

    $form['uid'] = array(
      '#type' => 'hidden',
      '#default_value' => $user->uid,
    );

    $form['nickname'] = array(
      '#type' => 'hidden',
      '#default_value' => $user->nickname,
    );

    $form['name'] = array(
      '#type' => 'hidden',
      '#default_value' => "$user->lastname $user->firstname",
    );

    $form['email'] = array(
      '#type' => 'hidden',
      '#default_value' => $user->email,
    );

    $form['oid'] = array(
      '#type' => 'hidden',
      '#default_value' => $order->oid,
    );

    $form['pid'] = array(
      '#type' => 'hidden',
      '#default_value' => $order->pid,
    );

    $form['commission'] = array(
      '#type' => 'hidden',
      '#default_value' => $product->commission,
    );

    if ($user->is_firm_invoice == 0) {
      // Normál számla
      $name = "$user->lastname $user->firstname";
      $zip = $user->zip;
      $city = $user->city;
      $address = $user->address;
    } else {
      // Céges számla.
      $name = $user->firm_name;
      $zip = $user->firm_zip;
      $city = $user->firm_city;
      $address = $user->firm_address;
    }
    $country = $user->country;

    $form['iname'] = array(
      '#type' => 'hidden',
      '#default_value' => $name,
    );

    $form['izip'] = array(
      '#type' => 'hidden',
      '#default_value' => $zip,
    );
    $form['icity'] = array(
      '#type' => 'hidden',
      '#default_value' => $city,
    );
    $form['iaddress'] = array(
      '#type' => 'hidden',
      '#default_value' => $address,
    );
    $form['icountry'] = array(
      '#type' => 'hidden',
      '#default_value' => $country,
    );
    $form['iproduct'] = array(
      '#type' => 'hidden',
      '#default_value' => $proforma_name,
    );
  }

  return $form;
}

function membership_search_oid($form, &$form_state) {
  $oid = trim($form_state['values']['oid']);
  // Megvizsgáljuk a megadott érték pozitív egész-e.
  if (!is_numeric($oid) || $oid < 1 || $oid != round($oid)) {
    // Ha nem pozitív egész hibaüzenetet adunk vissza.
    form_set_error('oid', t('A rendelés azonosítónak pozitív egész számnak kell lennie.'));
  } else {
    // Ha pozitív egész, akkor megnézzük, hogy létezik-e a rendelés azonosító.
    $order = db_query_range('SELECT * FROM {membership_orders} WHERE oid = :oid', 0, 1, array(':oid' => $oid,))->fetchObject();
    if (empty($order)) {
      form_set_error('oid', t('Ilyen sorszámmal nem létezik rendelés a rendszerben.'));
    } else {
      if ($order->is_activated) {
        form_set_error('oid', t('Ez a megrendelés már aktiválva van.'));
      } else {
        // Ha megtaláltuk, beolvassuk az user-t, átadjuk az adatokat és átlépünk az űrlap következő lépésére.
        $user = db_query_range('SELECT * FROM {membership_users} WHERE id = :id', 0, 1, array(':id' => $order->id,))->fetchObject();
        $form_state['storage']['order'] = $order;
        $form_state['storage']['user'] = $user;
        $form_state['storage']['find_the_order'] = TRUE;
        $form_state['rebuild'] = TRUE;
      }
    }
  }
}

function membership_activate_form_validate($form, &$form_state) {
  $price = trim($form_state['values']['price']);
  if (!is_numeric($price) || $price < 0 || $price != round($price)) {
    // Ha nem pozitív egész hibaüzenetet adunk vissza.
    form_set_error('price', t('A fizetendő összegnek pozitív egész számnak kell lennie.'));
  }
}

function membership_activate_form_submit($form, &$form_state) {
  $uid = $form_state['values']['uid'];
  $nickname = $form_state['values']['nickname'];
  $username = $form_state['values']['name'];
  $email = $form_state['values']['email'];

  $max = db_query('SELECT MAX(invoice_number) FROM {membership_invoices}')->fetchField();

  $invoice = array(
    'id' => $form_state['values']['id'],
    'oid' => $form_state['values']['oid'],
    'created' => REQUEST_TIME,
    'issued' => REQUEST_TIME,
    'invoice_number' => $max + 1,
    'quantity' => 1,
    'amount' => (int) trim($form_state['values']['price']),
    'is_firm_invoice' => $form_state['values']['is_firm_invoice'],
    'cancellation' => NULL,
    'error' => '',
    'name' => $form_state['values']['iname'],
    'zip' => $form_state['values']['izip'],
    'city' => $form_state['values']['icity'],
    'address' => $form_state['values']['iaddress'],
    'country' => $form_state['values']['icountry'],
    'deadline' => REQUEST_TIME,
    'product' => $form_state['values']['iproduct'],
    'hash' => _make_hash(32),
    'mode' => 2,
    'vat' => variable_get('membership_firm_invoice_vat'),
  );

  if ($invoice['amount'] != 0) {
    // Ha nagyobb a termnék értéke mint 0.     
    $iid = db_insert('membership_invoices')->fields($invoice)->execute();

    // Létrehozzuk a számlát.
    membership_create_invoice($iid);

    // Előkésztjük az orders táblában a frissítendő mezőket.
    $order = array(
      'price' => $invoice['amount'],
      'is_activated' => REQUEST_TIME,
      'is_invoiced' => $iid,
    );
  } else {
    // Ha a számla végösszege nulla, azt jelenti, hogy a felhasználó nem fizet
    // a termékért, ezért a is_invoiced mezőt nem kell módostíani, különben
    // hibaüznetet kapunk, mert a kiszámolázott számlára mutat, aminek az
    // azonosítója nem lehet nulla. 
    $order = array(
      'price' => $invoice['amount'],
      'is_activated' => REQUEST_TIME,
    );
  }

  $num_updated = db_update('membership_orders')->fields($order)->condition('oid', $invoice['oid'], '=')->execute();

  if (!$uid) {
    // Ha még nem aktivált felhasználó létrehozzunk az adatbázisban
    // és összekötjük a megerendelési adatokkal.
    $result = create_new_user($username, $email);

    $uid = $result['account']->uid;
    $num_updated = db_update('membership_users')->fields(array('uid' => $uid,))->condition('id', $invoice['id'], '=')->execute();

    // E-mail küldés az belépési adatokról.
    _new_user_email_send($form_state['values']['name'], $form_state['values']['email'], $result['username'], $result['password']);
  }


  // A szerepkörök, és hírvelek ki-be kikapcsolása.
  $product = db_query('SELECT name, roles_activate_add, roles_activate_remove, newsletter_activate, table_name FROM {membership_products} WHERE pid = :pid', array(':pid' => $form_state['values']['pid']))->fetchAssoc();

  // A szerepkörök törlése és hozzáadása.
  $roles_remove = unserialize($product['roles_activate_remove']);
  $rids = array();
  foreach ($roles_remove as $role) {
    if ($role != 0) {
      $rids[] = $role;
    }
  }
  _set_roles($uid, $rids, 'remove_role');

  $roles_add = unserialize($product['roles_activate_add']);
  $rids = array();
  foreach ($roles_add as $role) {
    if ($role != 0) {
      $rids[] = $role;
    }
  }
  _set_roles($uid, $rids, 'add_role');

  // Felhasználó törlése és hozzáadása a hírlevél listákhoz.
//  $newsletter_remove = unserialize($product['newsletter_activate_remove']);
//  $listids = array();
//  foreach($newsletter_remove as $listid) {
//    if ($listid!=0) {
//      $listids[]=$listid; 
//    }
//  }
//  _set_mailing_lists('', $email, $listids, 'remove_list');
//  
//  $newsletter_add = unserialize($product['newsletter_activate_add']);
//  $listids = array();
//  foreach($newsletter_add as $listid) {
//    if ($listid!=0) {
//      $listids[]=$listid; 
//    }
//  }
//  _set_mailing_lists($nickname, $email, $listids, 'add_list');
  // E-mail küldés az aktiválásról
  _activate_email_send($form_state['values']['name'], $form_state['values']['email'], $product['name']);

  if ($invoice['amount'] != 0) {
    // Ha nagyobb a termnék értéke mint 0.  
    // E-mail küldés a számlázásról.
    _invoice_send($iid, $invoice['hash'], $email, $username);
  }

  // A felhasználó felcímkézése az IM-ben.
  // Az e-mailhez hozzáadjuk az aktivált címkét és eltávolítjuk a megrendelt és
  // lejárt címkéket. Ha a felhasználó nem létezik, nem történik semmi.
  // im_modifySubscriberLabels($form_state['values']['email'], array('F_' . $product['table_name']), array('M_' . $product['table_name'], 'L_' . $product['table_name']));

  $ac = new ActiveCampaign(variable_get('membership_ac_api_url'), variable_get('membership_ac_api_key'));

  $nl_activate = unserialize($product['newsletter_activate']);
  
  // Címkék összerakása
  $tags_add = explode(',', $nl_activate['activate_tags_add']);
  $tags_add[] = 'F_' . $product['table_name'];
  $tags_remove = explode(',', $nl_activate['activate_tags_remove']);
  $tags_remove_all = array_merge($tags_remove, array('M_' . $product['table_name'], 'L_' . $product['table_name'], 'V_' . $product['table_name'],));
  
  $post_data = array(
    'email' => $form_state['values']['email'],
    'tags' => $tags_add,
  );
  $response = $ac->api("contact/tag_add", $post_data);

  $post_data = array(
    'email' => $form_state['values']['email'],
    'tags' => $tags_remove_all,
  );
  $response = $ac->api("contact/tag_remove", $post_data);
  
  // Elindítjuk a felhasználót a szekvencián.
  // im_startSubscriberSequence($form_s,tate['values']['email'], $product['newsletter_activate']);
  // AC elindítjuk az automatizmuson
  $post_data = array(
    'contact_email' => $form_state['values']['email'], // include this or contact_id
    'automation' => $nl_activate['newsletter_activate'], // one or more
  );
  $response = $ac->api("automation/contact/add", $post_data);

  // Ha az alert modul be van kapcsolva megnézi, hogy az illető rendelése
  // szerepel-e az alert_nopayers vagyis nem fizetők táblájában.  
  if (module_exists('alert')) {
    $nonpayer = db_query_range('SELECT oid FROM {alert_nonpayers} WHERE oid = :oid', 0, 1, array(':oid' => $invoice['oid']))->fetchField();
    if (!empty($nonpayer)) {
      // Ha szerepel a táblában töröljük, hiszen az aktiválás bizonyítja, hogy
      // fizetett.
      db_delete('alert_nonpayers')->condition('oid', $nonpayer, '=')->execute();
    }
  }

  // Ellenőrizzük, hogy az aff modul be van-e kapcsolva és a számla értéke
  // nagyobb-e mint nulla. Ha nulla a nullánnak nincs értéke, ezért nem kell
  // jutalékot sem fizetnünk. Ha nagyobb mint nulla, és a modul be van kapcsolva
  // meghívjuk a rutint, ami feljegyzi a befizetést az adatbázisba.
  if (module_exists('aff') && $invoice['amount'] != 0) {
    aff_payment($product['name'], $form_state['values']['commission'], $invoice['oid']);
  }

  drupal_set_message(t($invoice['oid'] . '. sorszámú rendelés <em>(' . $product['name'] . ')</em> aktiválva.'), 'status');
}

/**
 * Létrehoz egy új felhasználót
 *
 * @param string $username
 * A felhasználónév.
 * 
 * @param string $email
 * A felhasználó e-mail címe.
 *  
 * @return array
 * A felhasználó név és a jelszó, és az account.
 *   
 */
function create_new_user($username, $email) {
  // A felhasználó nevet megtisztítjuk és egyedivé tesszük.
  $username = unique_username(sanitise_username($username));

  $edit = array(
    'name' => $username,
    'pass' => _make_hash(6, FALSE),
    'mail' => $email,
    'status' => 1,
    'language' => 'hu',
    'init' => $email,
    'roles' => array(2, 'authenticated user'),
  );

  $account = user_save(NULL, $edit);

  return array(
    'username' => $edit['name'],
    'password' => $edit['pass'],
    'account' => $account,
  );
}

/**
 * Kiveszi a felhasználó névből az illegális karaktereket.
 * 
 * @param string $username
 * A felhasználónév.
 * 
 * @return
 * A "megtisztított" felhasználónév.
 */
function sanitise_username($username) {
  // username cannot contain an illegal character
  $username = preg_replace('/[^\x80-\xF7 [:alnum:]@_.-]/', '', $username);
  $username = preg_replace(
    '/[\x{80}-\x{A0}' . // Non-printable ISO-8859-1 + NBSP
    '\x{AD}' . // Soft-hyphen
    '\x{2000}-\x{200F}' . // Various space characters
    '\x{2028}-\x{202F}' . // Bidirectional text overrides
    '\x{205F}-\x{206F}' . // Various text hinting characters
    '\x{FEFF}' . // Byte order mark
    '\x{FF01}-\x{FF60}' . // Full-width latin
    '\x{FFF9}-\x{FFFD}' . // Replacement characters
    '\x{0}]/u', '', $username);

  // username cannot contain multiple spaces in a row
  $username = preg_replace('/[ ]+/', ' ', $username);

  // username must be less than 56 characters
  $username = substr($username, 0, 56);

  // username cannot begin or end with a space
  $username = trim($username);
  return $username;
}

/**
 * Kezeli ha egy felhasználó neve ugyanaz lenne mint egy másiké.
 * PL.: Ha "Kovács Jánosból" kettő van, a másodikat "Kovács János 2"
 * névre alakítja.
 * 
 * @param string $username
 * A felhasználó név.
 * 
 * @return
 * Az első szabad felhasználónév.
 */
function unique_username($username, $start = FALSE) {
  static $suffix = 1;
  if ($start)
    $suffix = 1;

  if ($suffix < 2) {
    $duplicate = db_query_range('SELECT uid FROM {users} WHERE name = :name', 0, 1, array(':name' => $username))->fetchField();
  } else {
    $duplicate = db_query_range('SELECT uid FROM {users} WHERE name = :name', 0, 1, array(':name' => "$username $suffix"))->fetchField();
  }

  // loop until name is valid
  if (!empty($duplicate)) {
    $suffix++;
    unique_username($username);
  }

  // add number at end of username if it already exists
  $username = ($suffix < 2) ? $username : "$username $suffix";

  return $username;
}
