<?php

function callin_user_form($form, &$form_state, $id) {
    global $user;

    $user_notes = _callin_get_user_notes(check_plain($id));

    // Createing the HTML list.
    $html = _callin_get_user_header($id);
    foreach ($user_notes as $value) {
        $html .= '<p>' . _callin_get_caller_name($value->calleruid) . ' @ <em>' . date('Y-m-d H:i', $value->created) . '</em></p>';
        $html .= "<blockquote>$value->note</blockquote>";
        if ($value->followup != 0) {
            $html .= '<p>' . t('Follow up') . ' -> <em>' . date('Y-m-d H:i', $value->followup) . '</em></p>';
        }
        $html .= '<hr>';
    }

    $html .= '<h2>' . t('Add note') . '</h2>';

    $form = array();

    $form['followup_information'] = array(
        '#markup' => $html,
    );

    $form['note'] = array(
        '#title' => t('Note'),
        '#description' => t('Note about the call.'),
        '#type' => 'textarea',
        '#required' => TRUE,
    );

    $form['followup'] = array(
        '#title' => t('Follow up'),
        '#description' => t(''
                . 'Write here the date and time, if you want to remember to follow up the user. '
                . 'If you dont \'t want to followup, just leave this empty. Examples for the dates:<br>'
                . '<li><em>17-12-11</em></li>'
                . '<li><em>2017-12-11</em></li>'
                . '<li><em>2017-12-11 10:00</em></li>'
                . '<li><em>+1 day</em></li>'
                . '<li><em>+1 week</em></li>'
                . '<li><em>+1 week Thursday</em></li>'
                . '<li><em>+1 week 2 days 4 hours 2 seconds</em></li>'
                . '<li><em>next Monday</em></li>'),
        '#type' => 'textfield',
            //'#element_validate' => array('_callin_validate_date'),
    );

    $form['id'] = array(
        '#type' => 'value',
        '#value' => $id,
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Save'),
    );

    $form['order'] = array(
        '#type' => 'submit',
        '#value' => t('Add new order'),
        '#submit' => array('callin_add_order_submit'),
        '#limit_validation_errors' => array(),
    );

    return $form;
}

function callin_user_form_submit($form, &$form_state) {
    global $user;

    // Saves a lot of typing.
    $v = $form_state['values'];
    $time = $v['followup'];
    $ts = strtotime($time);

// outputs 10th December, 2011
    //Collect the form fields
    $fields = array(
        'id' => $v['id'],
        'calleruid' => $user->uid,
        'created' => REQUEST_TIME,
        'note' => $v['note'],
        'followup' => (!empty($time)) ? $ts : 0,
    );
    db_insert('callin_notes')->fields($fields)->execute();
}

function callin_add_order_submit($form, &$form_state) {
    $id = $form_state['build_info']['args'][0];
    $form_state['redirect'] = array("admin/config/callin/$id/order", array('query' => array(), 'fragment' => '',),);
}

function callin_order_form($form, &$form_state, $id) {
    $products = _callin_get_filtered_products();

    $html = _callin_get_user_header($id);
    $html .= '<h2>' . t('Add order') . '</h2>';

    $form = array();

    $form['followup_information'] = array(
        '#markup' => $html,
    );

    if (!isset($form_state['storage']['page_2'])) {

        $form['product'] = array(
            '#type' => 'select',
            '#title' => t('Products'),
            '#options' => $products,
            '#required' => TRUE,
        );

        $form['price'] = array(
            '#type' => 'textfield',
            '#title' => t('Price'),
            '#size' => 16,
            '#maxlength' => 254,
            '#required' => TRUE,
            '#element_validate' => array('_callin_validate_price'),
        );

        $form['proforma'] = array(
            '#type' => 'checkbox',
            '#title' => t('Send proforma invoice to the user.'),
        );

        $form['id'] = array(
            '#type' => 'value',
            '#value' => $id,
        );

        $form['next'] = array(
            '#type' => 'submit',
            '#value' => t('Next'),
        );
    } else {

        // saves lots of typing,
        $v = $form_state['storage']['page_1']['values'];
        $order = '<h4>' . $products[$v['product']] . '</h4>';
        $order .= '<h5>' . t('New price: ') . number_format($v['price'], 0, ',', ' ') . ' Ft</h5>';


        $form['order_information'] = array(
            '#markup' => $order,
        );

        $form['submit'] = array(
            '#type' => 'submit',
            '#value' => t('Yes, Place order'),
        );
    }
    return $form;
}

function callin_order_form_submit($form, &$form_state) {
    global $user, $base_url;
    if (!isset($form_state['storage']['page_2'])) {
        // First page, go the the next step
        $form_state['storage']['page_2'] = TRUE;
        $form_state['storage']['page_1']['values'] = $form_state['values'];
        $form_state['rebuild'] = TRUE;
    } else {

        //Saves lots of typing.
        $v = $form_state['storage']['page_1']['values'];

        // Add the order to the membership
        $fields = array(
            'id' => $v['id'],
            'pid' => $v['product'],
            'created' => REQUEST_TIME,
            'ip' => _callin_get_real_ip(),
            'sid' => 0,
            'price' => $v['price'],
            'shipping' => 0,
            'vat' => variable_get('membership_firm_invoice_vat'),
            'is_activated' => 0,
            'is_sent' => 3,
            'is_invoiced' => 0,
        );

        $oid = db_insert('membership_orders')->fields($fields)->execute();

        $product_name = db_query_range('SELECT name FROM {membership_products} WHERE pid = :pid', 0, 1, array(':pid' => $v['product']))->fetchField();
        $product_commission = floatval(variable_get('callin_product_commission_amount_' . $v['product']));

        // Send an e-mail.
        if ($v['proforma']) {
            $products = _callin_get_products();
            $u = _callin_get_user_data_object($v['id']);
            $name = "$u->lastname $u->firstname";
            $email = $u->email;
            $proforma_link = "$base_url/dijbekero-level/?oid=$oid&hash=$u->hash";
            $sign = db_query_range('SELECT firstname FROM {membership_users} WHERE uid = :uid', 0, 1, array(':uid' => $user->uid))->fetchField();

            callin_email_send($name, $email, $product_name, $proforma_link, $sign);
        }
        // Add a new record to the callin_orders table.
        $fields = array(
            'calleruid' => $user->uid,
            'created' => REQUEST_TIME,
            'oid' => $oid,
            'commission' => (floatval($v['price']) * ($product_commission / 100)),
        );
        db_insert('callin_orders')->fields($fields)->execute();

        // Add a new note to the callin_notes table about the order.

        $fields = array(
            'id' => $v['id'],
            'calleruid' => $user->uid,
            'created' => REQUEST_TIME,
            'note' => t('Order:') . ' ' . $product_name . ' | Price: ' . number_format($v['price'], 0, ',', ' ') . ' Ft',
            'followup' => 0,
        );
        db_insert('callin_notes')->fields($fields)->execute();

        // Redirect the user to the callin notes.
        unset($form_state['storage']); // This value must be unset for redirection!!
        $form_state['redirect'] = array('admin/config/callin/' . $v['id'] . '/user', array('query' => array(), 'fragment' => '',),); // Redirects the user.
    }
}
