<?php

function callin_payment_form($form, &$form_state) {
    $products = db_query('SELECT pid, name FROM {membership_products}')->fetchAllKeyed();
    $callers = _callin_get_callers();

// Get params

    (isset($_GET['caller'])) ? $caller = $_GET['caller'] : $caller = '';

    // Creating the search form.
    $form = array();

    $form['caller'] = array(
        '#type' => 'select',
        '#title' => t('Caller'),
        '#options' => $callers,
        '#prefix' => '<table><td>',
        '#suffix' => '</td>',
        '#default_value' => $caller,
    );

    $form['submit'] = array(
        '#prefix' => '<td>',
        '#suffix' => '</td></tr></table>',
        '#type' => 'submit',
        '#value' => t('Search'),
    );

    // Creating the table
    $header = array(
        array('data' => t('Caller ID'), 'field' => 'uid'),
        array('data' => t('Caller'), 'field' => 'name', 'sort' => 'asc'),
        array('data' => t('Income Sum'), 'field' => 'income',),
        array('data' => t('Payments Sum'), 'field' => 'payments',),
        array('data' => t('Unpaid income'), 'field' => 'unpaid',),
        array('data' => t('Operations')),
    );

    $query = db_select('callin_orders', 'c');
    $query->join('users', 'u', 'c.calleruid = u.uid');
    $query->join('membership_orders', 'o', 'o.oid = c.oid');
    $query->condition('o.is_activated', 0, '!=');
    $query->groupBy('u.uid');
//    $query->groupBy('o.pid');
    $query->fields('u', array('uid', 'name'));
    $query->fields('o', array('pid'));
    $query->addExpression('SUM(price)', 'income');
    $query->addExpression('SUM(commission)', 'commission');
    if ($caller != 0) {
        $query->condition('calleruid', $caller);
    }
    $query = $query->extend('PagerDefault')
            ->limit(50)
            ->extend('TableSort')
            ->orderByHeader($header);
    $users = $query->execute()->fetchAll();

//    mdd($users);

    $rows = array();
    foreach ($users as $value) {
        $paid = _callin_sum_payments($value->uid);
        $unpaid = floatval($value->commission) - $paid;
        $links = l(t('Details'), "admin/config/callin/" . $value->uid . "/details") . '&nbsp;|&nbsp;' .
                l(t('Pay'), "admin/config/callin/" . $value->uid . "/$unpaid/pay");

        $rows[] = array(
            'data' => array(
                $value->uid,
                $value->name,
                _callin_float_right(_callin_price($value->commission)),
                _callin_float_right(_callin_price($paid)),
                _callin_float_right(_callin_price($unpaid)),
                $links,
            )
        );
    }

    $form['table'] = array(
        '#theme' => 'table',
        '#header' => $header,
        '#rows' => $rows,
        '#empty' => t('Nincsenek találatok.'),
        '#attributes' => array('class' => array('table table-striped table-bordered table-condensed'))
    );
    $form['pager'] = array('#markup' => theme('pager'));

    return $form;
}

function callin_payment_form_submit($form, &$form_state) {
    // Save lots of typing
    $v = $form_state['values'];
    $form_state['redirect'] = array('admin/config/callin/payments',
        array('query' => array(
                'caller' => $v['caller'],
            ),
            'fragment' => '',),
    );
}

function callin_payment_details_form($form, &$form_state, $uid) {

// Get params
    (isset($_GET['from'])) ? $from = $_GET['from'] : $from = '1970-01-01 00:00:00';
    (isset($_GET['to'])) ? $to = $_GET['to'] : $to = date('Y-m-d H:i:s');

    $html = '<h1>' . _callin_get_caller_name($uid) . '</h1><hr>';

// Creating the search form.
    $form = array();
    $form['followup_information'] = array(
        '#markup' => $html,
    );

    $form['from'] = array(
        '#type' => 'textfield',
        '#title' => t('From date'),
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 254,
        '#prefix' => '<table><tr><td>',
        '#suffix' => '</td>',
        '#default_value' => $from,
    );

    $form['to'] = array(
        '#type' => 'textfield',
        '#title' => t('To date'),
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 254,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $to,
    );

    $form['submit'] = array(
        '#prefix' => '<td>',
        '#suffix' => '</td></tr></table>',
        '#type' => 'submit',
        '#value' => t('Search'),
    );


    // Creating the table
    $header = array(
        array('data' => t('Payment date'), 'field' => 'created', 'sort' => 'desc'),
        array('data' => t('Amount'), 'field' => 'amount',),
        array('data' => t('Payer'), 'field' => 'orders',),
    );

    $start_time = strtotime($from);
    $end_time = strtotime($to);

    $query = db_select('callin_payments', 'p');
    $query->join('users', 'u', 'p.payeruid = u.uid');
    $query->condition('p.created', array($start_time, $end_time), 'BETWEEN');
    $query->fields('u', array('name'));
    $query->fields('p', array('created', 'amount'));
    $query->extend('PagerDefault')
            ->limit(52)
            ->extend('TableSort')
            ->orderByHeader($header);
    $payments = $query->execute();

    $rows = array();

    foreach ($payments as $value) {

        $rows[] = array(
            'data' => array(
                date('Y-m-d H:i', $value->created),
                _callin_float_right(_callin_price($value->amount)),
                $value->name,
            )
        );
    }

    $form['table'] = array(
        '#theme' => 'table',
        '#header' => $header,
        '#rows' => $rows,
        '#empty' => t('Nincsenek találatok.'),
        '#attributes' => array('class' => array('table table-striped table-bordered table-condensed'))
    );
    $form['pager'] = array('#markup' => theme('pager'));

    return $form;
}

function callin_payment_details_form_submit($form, &$form_state) {

    $calleruid = $form_state['build_info']['args'][0];

    // Save lots of typing
    $v = $form_state['values'];
    $form_state['redirect'] = array("admin/config/callin/$calleruid/details",
        array('query' => array(
                'from' => $v['from'],
                'to' => $v['to'],
            ),
            'fragment' => '',),
    );
}

/**
 * Add payment form to user.
 * @param type $form
 * @param type $form_state
 * @param type $uid
 * @param type $value
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function callin_pay_form($form, &$form_state, $uid, $value) {

    $html = _callin_get_caller_header($uid);
    $html .= '<h2>' . t('Add payment') . '</h2>';

    $form = array();

    $form['payment_information'] = array(
        '#markup' => $html,
    );

    $form['uid'] = array(
        '#type' => 'value',
        '#value' => check_plain($uid),
    );

    $form['amount'] = array(
        '#title' => t('Payment amount'),
        '#type' => 'textfield',
        '#maxlength' => 6,
        '#attributes' => array('placeholder' => 0),
        '#required' => TRUE,
        '#default_value' => $value,
        '#element_validate' => array('callin_credit_amount_validate'),
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Pay'),
        '#submit' => array('callin_pay_form_submit'),
    );

    return $form;
}

/**
 * Credit order form submit.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function callin_pay_form_submit(&$form, &$form_state) {

    // Sum credit assigns
    $amount = (int) $form_state['values']['amount'];

    callin_add_payment($amount, $form_state['values']['uid']);

    // Redirect.
    $form_state['redirect'] = array('admin/config/callin/payments', array('query' => array(), 'fragment' => '',),);

    // Print a message.
    drupal_set_message(t('<em>Payment</em> successfull.'));
}

/**
 * Add positive valued credit transaction to database.
 * @param type integer $value
 * @param type integer $uid
 * @return string Last insert id.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function callin_add_payment($value = 0, $uid) {
    global $user;

    // Get timestamp
    $time = time();

    // Build row
    $data = array(
        'amount' => (int) $value,
        'created' => $time,
        'calleruid' => check_plain($uid),
        'payeruid' => $user->uid
    );

    $result = db_insert('callin_payments')->fields($data)->execute();

    // Save to watchdog.
    watchdog('callin', '"%value" payment created to %uid.', array('%value' => _callin_price($value), '%uid' => $uid, WATCHDOG_NOTICE));

    return $result;
}
