<?php

/**
 * @file Barion API functions.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */

/**
 * Payment request.
 * @params type array $order All details of the order.
 * @params type array $token One click mode.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function barion_api_payment_request($order = array(), $token = FALSE) {

    global $user;
    global $_REQUEST;
    global $base_url;
    $data = array();

    // Set keys
    $myPosKey = variable_get('barion_api_pos_key'); // <-- Replace this with your POSKey!
    $myEmailAddress = variable_get('barion_api_email'); // <-- Replace this with your e-mail address in Barion!
    $mode = variable_get('barion_api_mode');
    $currency = variable_get('barion_api_currency');
    $locale = variable_get('barion_api_locale');
    $token_key = $token == FALSE ? barion_api_generate_token() . '-' . $order['uid'] : check_plain($token);

    // Barion Client that connects to the TEST environment
    if ($mode == 1) {
        $BC = new BarionClient($myPosKey, BARION_API_VERSION, BarionEnvironment::Test);
    } else {
        $BC = new BarionClient($myPosKey, BARION_API_VERSION, BarionEnvironment::Prod);
    }

    // create the item model
    $item = new ItemModel();
    $item->Name = $order['item']['name']; // no more than 250 characters
    $item->Description = $order['item']['description']; // no more than 500 characters
    $item->Quantity = $order['item']['quantity'];
    $item->Unit = $order['item']['unit']; // no more than 50 characters
    $item->UnitPrice = $order['item']['unitprice'];
    $item->ItemTotal = $order['item']['itemtotal'];
    $item->SKU = $order['item']['sku']; // no more than 100 characters
    // create the transaction
    $trans = new PaymentTransactionModel();
    $trans->POSTransactionId = $order['transaction']['hash'];
    $trans->Payee = $myEmailAddress; // no more than 256 characters
    $trans->Total = $order['transaction']['total'];
    $trans->Comment = $order['transaction']['title']; // no more than 640 characters
    $trans->AddItem($item); // add the item to the transaction
    // create the request model
    $psr = new PreparePaymentRequestModel();
    $psr->GuestCheckout = true; // we allow guest checkout
    $psr->PaymentType = PaymentType::Immediate; // we want an immediate payment
    $psr->FundingSources = array(FundingSourceType::All); // both Barion wallet and bank card accepted
    $psr->PaymentRequestId = $order['payment']['hash']; // no more than 100 characters
    $psr->PayerHint = $order['payment']['usermail']; // no more than 256 characters
    $psr->RedirectUrl = $base_url . '/barion/redirect/'; // no more than 256 characters
    $psr->CallbackUrl = $base_url . '/barion/callback/'; // no more than 256 characters

    if ($locale == 6) {
        $psr->Locale = UILocale::FR;
    } else if ($locale == 5) {
        $psr->Locale = UILocale::SK;
    } else if ($locale == 4) {
        $psr->Locale = UILocale::SL;
    } else if ($locale == 3) {
        $psr->Locale = UILocale::DE;
    } else if ($locale == 2) {
        $psr->Locale = UILocale::HU;
    } else {
        $psr->Locale = UILocale::EN; // the UI language will be English
    }

    if ($currency == 3) {
        $psr->Currency = Currency::USD;
    } else if ($currency == 2) {
        $psr->Currency = Currency::EUR;
    } else {
        $psr->Currency = Currency::HUF;
    }
    $psr->OrderNumber = $order['payment']['oid']; // no more than 100 characters
    $psr->ShippingAddress = $order['payment']['shipping'];

    if ($token == FALSE) {
        $psr->InitiateRecurrence = TRUE;
        $psr->RecurrenceId = $token_key;

        // Save token to database
        $data = array(
            'uid' => $order['uid'],
            'token' => $token_key,
            'created' => ''
        );
        db_insert('barion_api_tokens')->fields($data)->execute();
    } else {
        $psr->InitiateRecurrence = FALSE;
        $psr->RecurrenceId = $token_key;
    }

    $psr->AddTransaction($trans); // add the transaction to the payment
    // send the request
    $myPayment = $BC->PreparePayment($psr);

    // Set transaction details array
    $fields = array(
        'uid' => $order['uid'],
        'oid' => $order['oid'],
        'payment' => $myPayment->PaymentId,
        'tr_hash' => $order['transaction']['hash'],
        'pr_hash' => $order['payment']['hash'],
        'items' => serialize((array) $item),
        'created' => date("Y-m-d H:i:s"),
        'token' => $token_key
    );

//    mdd($myPayment, true);
    // One click payment
    if ($token != FALSE && $myPayment->RecurrenceResult === 'Successful' && $myPayment->Status == 'Succeeded') {

        // Get payment details
        $paymentDetails = $BC->GetPaymentState($myPayment->PaymentId);

        // Update fields
        $fields['status'] = 1;
        $fields['response'] = serialize((array) $paymentDetails);

        // Drupal set message
        drupal_set_message(t('Congratulation! One click checkout is success.'));

        // Insert transaction data to database
        db_insert('barion_api_transactions')->fields($fields)->execute();

        // Save to watchdog.
        watchdog('barion_api', 'One click "%oid" order is successed. Payment id: %pid', array('%oid' => $order['oid'], '%pid' => $myPayment->PaymentId, WATCHDOG_NOTICE));

        // Redirect to thank you or callback page
        if (variable_get('barion_api_callback') == '') {
            barion_api_redirect_to_thank_you(array('paymentId' => $myPayment->PaymentId));
        } else {
            barion_api_redirect_to_payment_in($order['oid'], $myPayment->PaymentId);
        }
    } else if ($token != FALSE) {

        // Update fields
        $fields['status'] = 2;
        $fields['response'] = serialize((array) $myPayment);

        // Insert transaction data to database
        db_insert('barion_api_transactions')->fields($fields)->execute();

        // Drupal set message
        drupal_set_message(t('Oops! One click "@oid" order is failed.', array('@oid' => $order['oid'])), 'error');

        // Save to watchdog.
        watchdog('barion_api', 'One click "%oid" order is failed. Payment id: %pid', array('%oid' => $order['oid'], '%pid' => $myPayment->PaymentId, WATCHDOG_NOTICE));

        // Redirect to thank you page
        barion_api_redirect_to_thank_you(array('paymentId' => $myPayment->PaymentId));
    }

    // Insert transaction data to database
    db_insert('barion_api_transactions')->fields($fields)->execute();

    // If not One click redirect
    if ($myPayment->RequestSuccessful === true && $token == FALSE) {
        // redirect the user to the Barion Smart Gateway
        header("Location: " . BARION_WEB_URL_TEST . "?id=" . $myPayment->PaymentId);
    }
}

/**
 * Payment redirect function.
 * @params type string $paymentId.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function barion_api_callback() {
    barion_debug(true, true);
    exit();
}

/**
 * Payment redirect function.
 * @params type string $paymentId.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function barion_api_payment_redirect($paymentId = '') {
    global $_REQUEST;
    global $user;

    // Set keys
    if ($paymentId == '' && isset($_REQUEST['paymentId'])) {
        $paymentId = check_plain($_REQUEST['paymentId']);
    }
    $myPosKey = variable_get('barion_api_pos_key'); // <-- Your POSKey!
    $mode = variable_get('barion_api_mode');

    // Barion Client that connects to the TEST environment
    if ($mode == 1) {
        $BC = new BarionClient($myPosKey, BARION_API_VERSION, BarionEnvironment::Test);
    } else {
        $BC = new BarionClient($myPosKey, BARION_API_VERSION, BarionEnvironment::Prod);
    }

    // Get payment details
    $paymentDetails = $BC->GetPaymentState($paymentId);

    // Process the information contained in $paymentDetails
    // Success
    if ($paymentDetails->Status == 'Succeeded') {

        // Update transaction
        $fields = array(
            'response' => serialize((array) $paymentDetails),
            'status' => 1
        );
        db_update('barion_api_transactions')->fields($fields)->condition('payment', $paymentId)->execute();

        // Update token
        $token = db_select('barion_api_transactions', 't')
                ->fields('t', array('token'))
                ->condition('payment', $paymentId)
                ->execute()
                ->fetchField();
        $data = array(
            'card_mask' => $paymentDetails->FundingInformation->BankCard->MaskedPan,
            'card_type' => $paymentDetails->FundingInformation->BankCard->BankCardType,
            'card_year' => $paymentDetails->FundingInformation->BankCard->ValidThruYear,
            'card_month' => $paymentDetails->FundingInformation->BankCard->ValidThruMonth,
            'created' => date('Y-m-d H:i:s')
        );

        // Bank card details
        $card = db_select('barion_api_tokens', 't')
                ->fields('t')
                ->condition('uid', $user->uid)
                ->condition('card_mask', $data['card_mask'])
                ->condition('card_type', $data['card_type'])
                ->condition('card_year', $data['card_year'])
                ->condition('card_month', $data['card_month'])
                ->execute()
                ->fetchAll();
        if (empty($card)) {
            // If there is not matching card, update the token with card details
            db_update('barion_api_tokens')->fields($data)->condition('token', $token)->execute();
        } else {
            // If there is matching card, delete the new token
            db_update('barion_api_transactions')->fields(array('token' => $card[0]->token))->condition('payment', $paymentId)->execute();
            db_delete('barion_api_tokens')->condition('token', $token)->execute();
        }

        // Save to watchdog.
        watchdog('barion_api', '"%uid" order is successed. Payment id: %pid', array('%uid' => $user->uid, '%pid' => $paymentId, WATCHDOG_NOTICE));

        // Redirect to thank you or callback page
        if (variable_get('barion_api_callback') == '') {
            barion_api_redirect_to_thank_you(array('paymentId' => $paymentId));
        } else {
            $transaction = barion_api_get_payment($paymentId);
            barion_api_redirect_to_payment_in($transaction['oid'], $paymentId);
        }
    } else {

        // Update transaction
        $fields = array(
            'response' => serialize((array) $paymentDetails),
            'status' => 2
        );
        db_update('barion_api_transactions')->fields($fields)->condition('payment', $paymentId)->execute();

        // Save to watchdog.
        watchdog('barion_api', '"%uid" order is failed. Payment id: %pid', array('%uid' => $user->uid, '%pid' => $paymentId, WATCHDOG_NOTICE));

        // barion_debug($paymentDetails);
        $transaction = barion_api_get_payment($paymentId);
        barion_api_redirect_to_payment_in($transaction['oid'], $paymentId);
//        barion_api_redirect_to_thank_you(array('paymentId' => $paymentId));
    }
}

/**
 * Payment details function.
 * @params type array $paymentId All details of the order.
 * @return type array Complete response.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function barion_api_payment_get_details($paymentId) {

    // Update token
    $response = db_select('barion_api_transactions', 't')
            ->fields('t', array('response'))
            ->condition('payment', $paymentId)
            ->execute()
            ->fetchField();

    if (!empty($response)) {
        return unserialize($response);
    } else {
        return FALSE;
    }
}

/**
 * Payment process page before redirect.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function barion_api_payment_thankyou_page() {
    global $_REQUEST;

    // Get paymentId
    if (isset($_REQUEST['paymentId'])) {
        $paymentId = check_plain($_REQUEST['paymentId']);
    } else {
        $paymentId = '';
    }

    // Get response
    $payment_response = barion_api_payment_get_details($paymentId);

    // Print a message.
//    drupal_set_message(t('Transaction <em>successed</em>.<br>Payment id: "%pid"', array('%pid' => $paymentId)));
    // Save to watchdog.
//    watchdog('barion_api', '"%uid" order is successed. Payment id: %pid', array('%uid' => $user->uid, '%pid' => $paymentId, WATCHDOG_NOTICE));
    // Return html
    return theme('barion_api_thankyou', array(
        'payment' => $payment_response,
    ));
}
