(function($) {

var lastModuleItem;

Drupal.behaviors.moduleFilterPermissions = {
  attach: function(context) {
    $('.module-filter-inputs-wrapper', context).once('module-filter', function() {
      var filterInput = $('input[name="module_filter[name]"]', context);
      var selector = '#permissions tbody tr';

      // Move location of filter input.
      $('#permissions').parent().prepend(filterInput.parent().parent());

      filterInput.moduleFilter(selector, {
        wrapper: $('#permissions').parent(),
        childSelector: 'td.module',
        buildIndex: [
          function(moduleFilter, item) {
            item.isModule = (item.text != '') ? true : false;
            if (item.isModule) {
              item.children = new Array();
              lastModuleItem = item;
            }
            else {
              item.parent = lastModuleItem;
              lastModuleItem.children.push(item);
            }
            return item;
          }
        ]
      });

      var moduleFilter = filterInput.data('moduleFilter');

      moduleFilter.operators = {
        perm: function(string, moduleFilter, item) {
          if (!item.isModule) {
            if (item.name == undefined) {
              var $name = $('td.permission', item.element).clone();
              $('.description', $name).remove();
              item.name = $name.text().trim().toLowerCase();
            }

            if (item.name.indexOf(string) >= 0) {
              return true;
            }
          }
        }
      };

      moduleFilter.element.bind('moduleFilter:finish', function(e, data) {
        for (var i in moduleFilter.results) {
          if (moduleFilter.results[i].isModule) {
            for (var k in moduleFilter.results[i].children) {
              moduleFilter.results[i].children[k].element.removeClass('js-hide');
            }
          }
          else {
            moduleFilter.results[i].parent.element.removeClass('js-hide');
          }
        }
      });
    });
  }
};

})(jQuery);