<?php

/**
 * @file
 * A felhasználók adatainak adamisztrálása.
 */
// Az általános ellenőrző és átalakító függvények betöltése.
require_once 'lib.php';
require_once 'validate.php';

/**
 * Eldönti, hogy a felhasználó adminisztrátor-e, és ha átadta a
 * uid paraméter az adatott felhasználó adatait adja át a
 * saját adatai helyett.
 *
 * @return object
 * A felhasználó adtai.
 *
 */
function _get_user_data($id = '') {
    global $user;

    if ($id === '') {
        if (user_access('administer membership') && isset($_GET['id'])) {
            // Ha adminisztrátor és át lett adva azonosító paraméter
            // azt használjuk felhasználói azonosítónak, hogy bárki
            // adatait módosítani tudja.
            $id = trim(check_plain($_GET['id']));
            $user_data = db_query_range('SELECT * FROM {membership_users} WHERE id = :id', 0, 1, array(':id' => $id))->fetchObject();
        } else {
            // Ha nem adminsztrátor, vagy adminisztrátor, de nem lett
            // átadva az uid paraméter akkor kiolvassa a saját
            // azonosítóját.
            $uid = $user->uid;
            $user_data = db_query_range('SELECT * FROM {membership_users} WHERE uid = :uid', 0, 1, array(':uid' => $uid))->fetchObject();
        }
    } else {
        if (user_access('administer membership')) {
            // Ha adminisztrátor és át lett adva azonosító paraméter
            // azt használjuk felhasználói azonosítónak, hogy bárki
            // adatait módosítani tudja.
            $id = trim(check_plain($id));
            $user_data = db_query_range('SELECT * FROM {membership_users} WHERE id = :id', 0, 1, array(':id' => $id))->fetchObject();
        } else {
            // Ha nem adminsztrátor, vagy adminisztrátor, de nem lett
            // átadva az uid paraméter akkor kiolvassa a saját
            // azonosítóját.
            $uid = $user->uid;
            $user_data = db_query_range('SELECT * FROM {membership_users} WHERE uid = :uid', 0, 1, array(':uid' => $uid))->fetchObject();
        }
    }
    return $user_data;
}

function membership_user_data_alter_form($form, &$form_state, $account) {
    global $user;
    $uid = $user->uid;

    $muser = membership_user_details_object_by_uid($account->uid);
//    mdd($muser);
    if ($uid != 0) {
// Ha azonosított látogató, létrehozzuk az oldalt.
        $country = db_query('SELECT * FROM {membership_country} ORDER BY name ASC')->fetchAllKeyed();
        $user_data = _get_user_data($muser->id);

        $form = array();

// Címsor.
        $form['header'] = array(
            '#type' => 'item',
            '#markup' => "<h3>Saját adatok: <strong>$user_data->lastname $user_data->firstname</strong> (Felhasználónév: " .
            l(
                    db_query_range('SELECT name FROM {users} WHERE uid = :uid', 0, 1, array(':uid' => $user_data->uid,))->fetchField(), 'user/' . $user_data->uid
            ) . ")</h3>",
        );

// Személyes adatok.
        $personal_data = '<p><strong>Személyes adatok:</strong><br>';
        $personal_data .= "$user_data->lastname $user_data->firstname<br>";
        $personal_data .= "$user_data->email<br>";
        $personal_data .= "$user_data->phone<br>";
        $personal_data .= '<p><strong>Számlázási cím:</strong><br>';
        $personal_data .= "$user_data->zip. $user_data->city, $user_data->address";
        if ($user_data->country != 'HU') {
// Ha nem magyarországi cím, akkor kiírjuk azt ország nevét is.
            $personal_data .= '<br>' . $country[$user_data->country];
        }

        $personal_data .= "</p>";

        $form['personal_data'] = array(
            '#type' => 'item',
            '#markup' => $personal_data,
        );

// Cégadatok, ha meg vannak adva.
        if ($user_data->is_firm_invoice) {
            $firm_data = '<p><strong>Cég adatok:</strong><br>';
            $firm_data .= "$user_data->firm_name<br>";
            $firm_data .= "$user_data->firm_zip. $user_data->firm_city, $user_data->firm_address<br>";
            $firm_data .= "$user_data->firm_taxid</p>";

            $form['firm_data'] = array(
                '#type' => 'item',
                '#markup' => $firm_data,
            );
        }
        $form['submit'] = array(
            '#type' => 'submit',
            '#submit' => array('membership_user_data_form_submit'),
            '#attributes' => array('class' => array(variable_get('membership_class_own_data_edit_button'))),
            '#value' => 'Szerkesztés',
        );

//        mdd(variable_get('membership_class_own_data_edit_button'));
        $add_order = '<a href="/user/' . $uid . '/order/add" class="' . variable_get('membership_class_own_data_edit_button') . ' btn-default btn mb-2 form-submit">Megrendelés hozzáadása</a>';

        $form['link'] = array(
            '#type' => 'item',
            '#markup' => $add_order,
        );

        $form['id'] = array(
            '#type' => 'hidden',
            '#value' => $user_data->id,
        );

        // Tábla elkészítése
        $header = array(
            array('data' => t('Azonosító '), 'field' => 'o.oid', 'sort' => 'desc'),
            array('data' => t('Termék neve'), 'field' => 'p.name'),
            array('data' => t('Rendelés dátuma'), 'field' => 'o.created'),
            array('data' => t('Ára'), 'field' => 'o.price'),
            array('data' => t('Állapota')),
            array('data' => t('Műveletek')),
        );

        $user_orders = db_select('membership_orders', 'o');
        $user_orders->join('membership_products', 'p', 'o.pid = p.pid');
        $user_orders->extend('TableSort')->orderByHeader($header);
        $user_orders->fields('p', array('name'));
        $user_orders->fields('o', array('oid', 'created', 'price', 'shipping', 'is_activated', 'is_sent', 'is_invoiced'));
        $user_orders->condition('o.id', $user_data->id, '=');
        $result = $user_orders->execute();

        $rows = array();

        // Állapotok és műveletek beállítása.
        foreach ($result as $value) {
            if ($value->is_activated) {
                // Ha aktiválva van.
                if ($value->is_invoiced) {
                    // Ha számlázva van.
                    $status = 'invoiced';
                } else {
                    // Ha nincs számlázva.
                    if ($value->price == 0) {
                        // Ha az ára 0 Ft nem szükséges számlázás.
                        $status = 'doesnt_need_invoice';
                    } else {
                        $status = 'waiting_for_invoice';
                    }
                }
            } else {
                // Ha nincs aktiválva.
                if ($value->is_sent == 3) {
                    // Ha nem kell levelet kiküldeni.
                    $status = 'waiting_for_payment';
                } else if ($value->is_sent == 1) {
                    // Levél kiküldve.
                    $status = 'sent';
                } else {
                    // Levél kiküldésre vár.
                    $status = 'waiting_for_send';
                }
            }

            // Beállítani a megejelnítendő dolgokat.
            switch ($status) {
                case 'invoiced':
                    $status_txt = '<span class="' . variable_get('membership_class_own_data_invoiced_status_text') . '">' . t('Aktív') . '</span>';
                    $hash = db_query_range('SELECT hash FROM {membership_invoices} WHERE iid = :iid', 0, 1, array(':iid' => $value->is_invoiced,))->fetchField();
                    $links = l(t('Számla >>'), 'szamla', array('query' => array('iid' => $value->is_invoiced, 'hash' => $hash)));
                    break;
                case 'waiting_for_invoice':
                    $status_txt = '<span class="' . variable_get('membership_class_own_data_waiting_for_invoice_status_text') . '">' . t('Aktív') . '</span>';
                    $links = 'Számlázásra vár...';
                    break;
                case 'doesnt_need_invoice':
                    $status_txt = '<span class="' . variable_get('membership_class_own_data_waiting_for_invoice_status_text') . '">' . t('Aktív') . '</span>';
                    $links = 'Nem szükséges számla.';
                    break;
                case 'waiting_for_payment':
                    $status_txt = '<span class="' . variable_get('membership_class_own_data_waiting_for_payment_status_text') . '">' . t('Kifizetésre vár') . '</span>';
                    $links = l(t('Díjbekérő levél >>'), 'dijbekero-level', array('query' => array('oid' => $value->oid)));
                    if (user_access('administer membership')) {
                        $links .= '<br>' . l(t('Megrendelés törlése'), 'admin/config/membership/order/delete/' . $value->oid, array('query' => array('oid' => $value->oid)));
                    }
                    break;
                case 'sent':
                    $status_txt = '<span class="' . variable_get('membership_class_own_data_sent_status_text') . '" >' . t('Kifizetésre vár') . '</span>';
                    $links = l(t('Díjbekérő levél >>'), 'dijbekero-level', array('query' => array('oid' => $value->oid)));
                    if (user_access('administer membership')) {
                        $links .= '<br>' . l(t('Megrendelés törlése'), 'admin/config/membership/order/delete/' . $value->oid, array('query' => array('oid' => $value->oid)));
                    }
                    break;
                case 'waiting_for_send':
                    $status_txt = '<span class="' . variable_get('membership_class_own_data_waiting_for_send_status_text') . '">' . t('Kiküldésre vár') . '</span>';
                    $links = l(t('Díjbekérő levél >>'), 'dijbekero-level', array('query' => array('oid' => $value->oid)));
                    if (user_access('administer membership')) {
                        $links .= '<br>' . l(t('Megrendelés törlése'), 'admin/config/membership/order/delete/' . $value->oid, array('query' => array('oid' => $value->oid)));
                    }
                    break;
            }

            $rows[] = array(
                'data' => array(
                    $value->oid,
                    $value->name,
                    date('Y-m-d', $value->created),
                    $value->price . '&nbsp;Ft',
                    $status_txt,
                    $links,
                )
            );
        }

        $form['order_data'] = array(
            '#type' => 'item',
            '#markup' => '<p><br><br><strong>Rendelési adatok:</strong></p>',
        );

        $form['table'] = array(
            '#theme' => 'table',
            '#header' => $header,
            '#rows' => $rows,
            '#empty' => t('Nincsenek rendelések.'),
            '#attributes' => array('class' => array('table table-striped table-bordered table-condensed'))
        );


        // Kártyák lista elkészítése
        if (module_exists('barion_api')) {

            $header = array(
                array('data' => t('#')),
                array('data' => t('Bankkárya')),
                array('data' => t('Műveletek')),
            );

            $result = membership_user_get_cards($user_data->id);

            $rows = array();
            $i = 0;

            // Állapotok és műveletek beállítása.
            foreach ($result as $key => $value) {

                $links = l(t('Eltávolítás'), "card/$key/delete");

                if ($key != null) {
                    $i++;
                    $rows[] = array(
                        'data' => array(
                            $i,
                            $value,
                            $links,
                        )
                    );
                }
            }

            $form['card_data'] = array(
                '#type' => 'item',
                '#markup' => '<p><br><br><strong>Bankkártyák:</strong></p>',
            );

            $form['cards'] = array(
                '#theme' => 'table',
                '#header' => $header,
                '#rows' => $rows,
                '#empty' => t('Nincsenek bankkáryák.'),
                '#attributes' => array('class' => array('table table-striped table-bordered table-condensed'))
            );
        }
        // [name] => 1. hónap
        // [oid] => 6
        // [created] => 1362322482
        // [price] => 4950
        // [shipping] => 0
        // [is_activated] => 0
        // [is_sent] => 0
        // [is_invoiced] =>
    } else {
        // Ha nem azonosított látogató a biztonság kedvért hibaüzenetet adunk.
        drupal_set_message(t('Az adatok szerkesztésére csak a tagoknak van jogosultságuk.'), 'error');
    }

    return $form;
}

function membership_user_data_form($form, &$form_state) {
    global $user;
    $uid = $user->uid;

    if ($uid != 0) {
// Ha azonosított látogató, létrehozzuk az oldalt.
        $country = db_query('SELECT * FROM {membership_country} ORDER BY name ASC')->fetchAllKeyed();
        $user_data = _get_user_data();

        $form = array();

// Címsor.
        $form['header'] = array(
            '#type' => 'item',
            '#markup' => "<h3>Saját adatok: <strong>$user_data->lastname $user_data->firstname</strong> (Felhasználónév: " .
            l(
                    db_query_range('SELECT name FROM {users} WHERE uid = :uid', 0, 1, array(':uid' => $user_data->uid,))->fetchField(), 'user/' . $user_data->uid
            ) . ")</h3>",
        );

// Személyes adatok.
        $personal_data = '<p><strong>Személyes adatok:</strong><br>';
        $personal_data .= "$user_data->lastname $user_data->firstname<br>";
        $personal_data .= "$user_data->email<br>";
        $personal_data .= "$user_data->phone<br>";
        $personal_data .= '<p><strong>Számlázási cím:</strong><br>';
        $personal_data .= "$user_data->zip. $user_data->city, $user_data->address";
        if ($user_data->country != 'HU') {
// Ha nem magyarországi cím, akkor kiírjuk azt ország nevét is.
            $personal_data .= '<br>' . $country[$user_data->country];
        }

        $personal_data .= "</p>";

        $form['personal_data'] = array(
            '#type' => 'item',
            '#markup' => $personal_data,
        );

// Cégadatok, ha meg vannak adva.
        if ($user_data->is_firm_invoice) {
            $firm_data = '<p><strong>Cég adatok:</strong><br>';
            $firm_data .= "$user_data->firm_name<br>";
            $firm_data .= "$user_data->firm_zip. $user_data->firm_city, $user_data->firm_address<br>";
            $firm_data .= "$user_data->firm_taxid</p>";

            $form['firm_data'] = array(
                '#type' => 'item',
                '#markup' => $firm_data,
            );
        }
        $form['submit'] = array(
            '#type' => 'submit',
            '#attributes' => array('class' => array(variable_get('membership_class_own_data_edit_button'))),
            '#value' => 'Szerkesztés',
        );

//        mdd(variable_get('membership_class_own_data_edit_button'));
        $add_order = '<a href="/user/' . $user_data->uid . '/order/add" class="' . variable_get('membership_class_own_data_edit_button') . ' btn-default btn mb-2 form-submit">Megrendelés hozzáadása</a>';

        $form['link'] = array(
            '#type' => 'item',
            '#markup' => $add_order,
        );

        $form['id'] = array(
            '#type' => 'hidden',
            '#value' => $user_data->id,
        );

        // Tábla elkészítése
        $header = array(
            array('data' => t('Azonosító '), 'field' => 'o.oid', 'sort' => 'desc'),
            array('data' => t('Termék neve'), 'field' => 'p.name'),
            array('data' => t('Rendelés dátuma'), 'field' => 'o.created'),
            array('data' => t('Ára'), 'field' => 'o.price'),
            array('data' => t('Állapota')),
            array('data' => t('Műveletek')),
        );

        $user_orders = db_select('membership_orders', 'o');
        $user_orders->join('membership_products', 'p', 'o.pid = p.pid');
        $user_orders->extend('TableSort')->orderByHeader($header);
        $user_orders->fields('p', array('name'));
        $user_orders->fields('o', array('oid', 'created', 'price', 'shipping', 'is_activated', 'is_sent', 'is_invoiced'));
        $user_orders->condition('o.id', $user_data->id, '=');
        $result = $user_orders->execute();

        $rows = array();

        // Állapotok és műveletek beállítása.
        foreach ($result as $value) {
            if ($value->is_activated) {
                // Ha aktiválva van.
                if ($value->is_invoiced) {
                    // Ha számlázva van.
                    $status = 'invoiced';
                } else {
                    // Ha nincs számlázva.
                    if ($value->price == 0) {
                        // Ha az ára 0 Ft nem szükséges számlázás.
                        $status = 'doesnt_need_invoice';
                    } else {
                        $status = 'waiting_for_invoice';
                    }
                }
            } else {
                // Ha nincs aktiválva.
                if ($value->is_sent == 3) {
                    // Ha nem kell levelet kiküldeni.
                    $status = 'waiting_for_payment';
                } else if ($value->is_sent == 1) {
                    // Levél kiküldve.
                    $status = 'sent';
                } else {
                    // Levél kiküldésre vár.
                    $status = 'waiting_for_send';
                }
            }

            // Beállítani a megejelnítendő dolgokat.
            switch ($status) {
                case 'invoiced':
                    $status_txt = '<span class="' . variable_get('membership_class_own_data_invoiced_status_text') . '">' . t('Aktív') . '</span>';
                    $hash = db_query_range('SELECT hash FROM {membership_invoices} WHERE iid = :iid', 0, 1, array(':iid' => $value->is_invoiced,))->fetchField();
                    $links = l(t('Számla >>'), 'szamla', array('query' => array('iid' => $value->is_invoiced, 'hash' => $hash)));
                    break;
                case 'waiting_for_invoice':
                    $status_txt = '<span class="' . variable_get('membership_class_own_data_waiting_for_invoice_status_text') . '">' . t('Aktív') . '</span>';
                    $links = 'Számlázásra vár...';
                    break;
                case 'doesnt_need_invoice':
                    $status_txt = '<span class="' . variable_get('membership_class_own_data_waiting_for_invoice_status_text') . '">' . t('Aktív') . '</span>';
                    $links = 'Nem szükséges számla.';
                    break;
                case 'waiting_for_payment':
                    $status_txt = '<span class="' . variable_get('membership_class_own_data_waiting_for_payment_status_text') . '">' . t('Kifizetésre vár') . '</span>';
                    $links = l(t('Díjbekérő levél >>'), 'dijbekero-level', array('query' => array('oid' => $value->oid)));
                    if (user_access('administer membership')) {
                        $links .= '<br>' . l(t('Megrendelés törlése'), 'admin/config/membership/order/delete/' . $value->oid, array('query' => array('oid' => $value->oid)));
                    }
                    break;
                case 'sent':
                    $status_txt = '<span class="' . variable_get('membership_class_own_data_sent_status_text') . '" >' . t('Kifizetésre vár') . '</span>';
                    $links = l(t('Díjbekérő levél >>'), 'dijbekero-level', array('query' => array('oid' => $value->oid)));
                    if (user_access('administer membership')) {
                        $links .= '<br>' . l(t('Megrendelés törlése'), 'admin/config/membership/order/delete/' . $value->oid, array('query' => array('oid' => $value->oid)));
                    }
                    break;
                case 'waiting_for_send':
                    $status_txt = '<span class="' . variable_get('membership_class_own_data_waiting_for_send_status_text') . '">' . t('Kiküldésre vár') . '</span>';
                    $links = l(t('Díjbekérő levél >>'), 'dijbekero-level', array('query' => array('oid' => $value->oid)));
                    if (user_access('administer membership')) {
                        $links .= '<br>' . l(t('Megrendelés törlése'), 'admin/config/membership/order/delete/' . $value->oid, array('query' => array('oid' => $value->oid)));
                    }
                    break;
            }

            $rows[] = array(
                'data' => array(
                    $value->oid,
                    $value->name,
                    date('Y-m-d', $value->created),
                    $value->price . '&nbsp;Ft',
                    $status_txt,
                    $links,
                )
            );
        }

        $form['order_data'] = array(
            '#type' => 'item',
            '#markup' => '<p><br><br><strong>Rendelési adatok:</strong></p>',
        );

        $form['table'] = array(
            '#theme' => 'table',
            '#header' => $header,
            '#rows' => $rows,
            '#empty' => t('Nincsenek rendelések.'),
            '#attributes' => array('class' => array('table table-striped table-bordered table-condensed'))
        );


        // Kártyák lista elkészítése
        if (module_exists('barion_api')) {

            $header = array(
                array('data' => t('#')),
                array('data' => t('Bankkárya')),
                array('data' => t('Műveletek')),
            );

            $result = membership_user_get_cards($user_data->id);

            $rows = array();
            $i = 0;

            // Állapotok és műveletek beállítása.
            foreach ($result as $key => $value) {

                $links = l(t('Eltávolítás'), "card/$key/delete");

                if ($key != null) {
                    $i++;
                    $rows[] = array(
                        'data' => array(
                            $i,
                            $value,
                            $links,
                        )
                    );
                }
            }

            $form['card_data'] = array(
                '#type' => 'item',
                '#markup' => '<p><br><br><strong>Bankkártyák:</strong></p>',
            );

            $form['cards'] = array(
                '#theme' => 'table',
                '#header' => $header,
                '#rows' => $rows,
                '#empty' => t('Nincsenek bankkáryák.'),
                '#attributes' => array('class' => array('table table-striped table-bordered table-condensed'))
            );
        }
        // [name] => 1. hónap
        // [oid] => 6
        // [created] => 1362322482
        // [price] => 4950
        // [shipping] => 0
        // [is_activated] => 0
        // [is_sent] => 0
        // [is_invoiced] =>
    } else {
        // Ha nem azonosított látogató a biztonság kedvért hibaüzenetet adunk.
        drupal_set_message(t('Az adatok szerkesztésére csak a tagoknak van jogosultságuk.'), 'error');
    }

    return $form;
}

function membership_user_data_form_submit($form, &$form_state) {
    if (user_access('administer')) {
        $id = $form_state['values']['id'];
        $form_state['redirect'] = array('sajat-adatok/edit', array('query' => array('id' => $id), 'fragment' => '',),);
    } else {
        $form_state['redirect'] = array('sajat-adatok/edit', array('query' => '', 'fragment' => '',),);
    }
}

/**
 * Felahasználó szerkesztése.
 *
 */
function membership_user_edit_form($form, &$form_state) {
    $country = db_query('SELECT * FROM {membership_country} ORDER BY name ASC')->fetchAllKeyed();
    $user_data = _get_user_data();
    $id = $user_data->id;

    $form = array();

    $form['lastname'] = array(
        '#type' => 'textfield',
        '#title' => 'Vezetékneved',
        '#required' => TRUE,
        '#size' => 32,
        '#maxlength' => 64,
        '#default_value' => $user_data->lastname,
    );

    $form['firstname'] = array(
        '#type' => 'textfield',
        '#title' => 'Utóneved',
        '#required' => TRUE,
        '#size' => 32,
        '#maxlength' => 64,
        '#default_value' => $user_data->firstname,
    );
    $form['email'] = array(
        '#type' => 'textfield',
        '#title' => 'E-mail címed',
        '#required' => TRUE,
        '#size' => 32,
        '#maxlength' => 254,
        '#default_value' => $user_data->email,
        '#element_validate' => array('_validate_email'),
    );
    $form['phone'] = array(
        '#type' => 'textfield',
        '#title' => 'Telefonszám',
        '#required' => TRUE,
        '#size' => 16,
        '#maxlength' => 32,
        '#default_value' => $user_data->phone,
        '#element_validate' => array('_validate_phone'),
    );
    $form['city'] = array(
        '#type' => 'textfield',
        '#title' => 'Város',
        '#required' => TRUE,
        '#size' => 32,
        '#maxlength' => 254,
        '#default_value' => $user_data->city,
    );
    $form['address'] = array(
        '#type' => 'textfield',
        '#title' => 'Utca és házszám',
        '#required' => TRUE,
        '#size' => 32,
        '#maxlength' => 254,
        '#default_value' => $user_data->address,
    );

    $form['zip'] = array(
        '#type' => 'textfield',
        '#title' => 'Irányítószám',
        '#required' => TRUE,
        '#size' => 6,
        '#maxlength' => 12,
        '#default_value' => $user_data->zip,
    );

    $form['country'] = array(
        '#type' => 'select',
        '#title' => 'Ország',
        '#options' => $country,
        '#required' => TRUE,
        '#default_value' => $user_data->country,
    );

    $form['is_not_firm_invoice'] = array(
        '#type' => 'checkbox',
        '#title' => 'A számlázási adataim megegyeznek a postázási adataimmal.',
        '#description' => '',
        '#required' => FALSE,
        '#default_value' => !$user_data->is_firm_invoice,
    );

    // A számlázási adatok ha cégről van szó.
    $form['invoicing_data'] = array(
        '#type' => 'fieldset',
        '#title' => 'Számlázási adatok',
        '#collapsible' => FALSE,
        '#collapsed' => FALSE,
        '#states' => array(
            'visible' => array(
                ':input[name="is_not_firm_invoice"]' => array('checked' => FALSE),
            ),
        ),
    );

    $form['invoicing_data']['firm_name'] = array(
        '#type' => 'textfield',
        '#title' => 'Cégnév',
        '#required' => FALSE,
        '#size' => 32,
        '#maxlength' => 254,
        '#default_value' => $user_data->firm_name,
        '#element_validate' => array('_validate_firm'),
    );

    $form['invoicing_data']['firm_city'] = array(
        '#type' => 'textfield',
        '#title' => 'Város',
        '#required' => FALSE,
        '#size' => 32,
        '#maxlength' => 254,
        '#default_value' => $user_data->firm_city,
        '#element_validate' => array('_validate_firm'),
    );

    $form['invoicing_data']['firm_address'] = array(
        '#type' => 'textfield',
        '#title' => 'Utca és házszám',
        '#required' => FALSE,
        '#size' => 32,
        '#maxlength' => 254,
        '#default_value' => $user_data->firm_address,
        '#element_validate' => array('_validate_firm'),
    );

    $form['invoicing_data']['firm_zip'] = array(
        '#type' => 'textfield',
        '#title' => 'Irányítószám',
        '#required' => FALSE,
        '#size' => 6,
        '#maxlength' => 12,
        '#default_value' => $user_data->firm_zip,
        '#element_validate' => array('_validate_firm'),
    );

    $form['invoicing_data']['firm_taxid'] = array(
        '#type' => 'textfield',
        '#title' => 'Adószám',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 13,
        '#default_value' => $user_data->firm_taxid,
        '#element_validate' => array('_validate_taxid'),
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => 'Adatok menetése',
        '#attributes' => array('class' => array(variable_get('membership_class_own_data_save_button'))),
    );

    $form['id'] = array(
        '#type' => 'hidden',
        '#value' => $id,
    );

    return $form;
}

function membership_user_edit_form_validate($form, &$form_state) {
    // Gondoskodunk róla ahogy más adatait ne írhassa felül.
    $email = trim($form_state['values']['email']);
    $id = trim($form_state['values']['id']);
    $result = db_query_range('SELECT email FROM {membership_users} WHERE email = :email AND id != :id', 0, 1, array(':email' => $email, ':id' => $id,))->fetchAll();
    if (!empty($result)) {
        form_set_error('email', 'Ezen az e-mail címen már létezik felahsználó! Kérlek ellenőrzid az e-mail címed. Ha bármilyen nehézséged van, vedd fel velünk a kapcsolatot!');
    }
}

function membership_user_edit_form_submit($form, &$form_state) {
    // Beállítjuk a később használt mezőket.
    $id = $form_state['values']['id'];

    // Ha céges számlát kér az $is_firm_invoice változót igazra álltjuk.
    if ((int) $form_state['values']['is_not_firm_invoice'] == 0)
        $is_firm_invoice = TRUE;
    else
        $is_firm_invoice = FALSE;
    $user_fields = array(
        'email' => trim($form_state['values']['email']),
        'ip' => _get_real_ip(),
        'created' => REQUEST_TIME,
        'lastname' => _capitalize($form_state['values']['lastname']),
        'firstname' => _capitalize($form_state['values']['firstname']),
        'phone' => trim($form_state['values']['phone']),
        'zip' => trim($form_state['values']['zip']),
        'city' => _capitalize($form_state['values']['city']),
        'address' => trim($form_state['values']['address']), // @TODO Az utcanévre csinálni egy specális kapitalizációs rutint.
        'country' => $form_state['values']['country'],
        'is_firm_invoice' => (int) $is_firm_invoice,
        'firm_name' => ($is_firm_invoice == TRUE) ? trim($form_state['values']['firm_name']) : '',
        'firm_zip' => ($is_firm_invoice == TRUE) ? trim($form_state['values']['firm_zip']) : '',
        'firm_city' => ($is_firm_invoice == TRUE) ? _capitalize($form_state['values']['firm_city']) : '',
        'firm_address' => ($is_firm_invoice == TRUE) ? trim($form_state['values']['firm_address']) : '',
        'firm_taxid' => ($is_firm_invoice == TRUE) ? trim($form_state['values']['firm_taxid']) : '',
    );

    // Frissíti az utoló választott fizetési módot.
    $num_update = db_update('membership_users')
            ->fields($user_fields)
            ->condition('id', $id, '=')
            ->execute();

    // Ellenőrizzük, hogy a rendelési űrlapról érkezett-e.
    // Ha igen, akkor oda dobjuk vissza különben a saját
    // adatok megjelenítésére.
    if (isset($_GET['pid']) && isset($_GET['hash'])) {
        if (isset($_GET['sid'])) {
            $sid = trim(check_plain($_GET['sid']));
        } else {
            $sid = '';
        }
        $pid = trim(check_plain($_GET['pid']));
        $hash = trim(check_plain($_GET['hash']));
        $redirect = 'megrendeles';
        $form_state['redirect'] = array($redirect, array('query' => array('sid' => $sid, 'pid' => $pid, 'hash' => $hash,), 'fragment' => '',),);
    } else {
        $redirect = 'sajat-adatok';
        $form_state['redirect'] = array($redirect, array('query' => array('id' => $id,), 'fragment' => '',),);
    }
}

/**
 * Delete user's credit card.
 * @param type string $id Card id.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_delete_card_form($form, &$form_state, $id) {
    global $user;
    // Get the card for the question.
    $card = membership_user_get_cards($user->uid)[$id];

    return confirm_form(
            $form, t('Bankkártya eltávolítás?'), 'sajat-adatok', t('Biztosan törlöd ezt a bankkártyád: %card?<br>Az eltávolítást nem lehet visszavonni.<br><br>', array('%card' => $card)), t('Eltávolítás'), t('Mégsem')
    );
}

/**
 * Delete user's credit card submit.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_delete_card_form_submit($form, &$form_state) {
    // Get the argument.
    $id = $form_state['build_info']['args'][0];

    // Delete the product group.
    $num_update = db_update('barion_api_tokens')
            ->fields(array(
                'card_year' => 2000
            ))
            ->condition('id', $id, '=')
            ->execute();

    // Redirect after the delete.
    $form_state['redirect'] = array('sajat-adatok', array('query' => array(), 'fragment' => '',),);

    // Print a message.
    drupal_set_message(t('Bankkárya eltávolítva.'));

    // Save to watchdog.
    watchdog('membership', '"%id" card has been inactivated.', array('%id' => $id, WATCHDOG_NOTICE));
}
