<?php

/**
 * @file
 * A felhasználók adatainak adamisztrálása.
 */
// Az általános ellenőrző és átalakító függvények betöltése.
require_once 'lib.php';
require_once 'validate.php';

/**
 * Eldönti, hogy a felhasználó adminisztrátor-e, és ha átadta a
 * uid paraméter az adatott felhasználó adatait adja át a
 * saját adatai helyett.
 *
 * @return object
 * A felhasználó adtai.
 *
 */
function _get_user_data($id = '') {
    global $user;

    if ($id === '') {
        if (user_access('administer membership') && isset($_GET['id'])) {
            // Ha adminisztrátor és át lett adva azonosító paraméter
            // azt használjuk felhasználói azonosítónak, hogy bárki
            // adatait módosítani tudja.
            $id = trim(check_plain($_GET['id']));
            $user_data = db_query_range('SELECT * FROM {membership_users} WHERE id = :id', 0, 1, array(':id' => $id))->fetchObject();
        } else {
            // Ha nem adminsztrátor, vagy adminisztrátor, de nem lett
            // átadva az uid paraméter akkor kiolvassa a saját
            // azonosítóját.
            $uid = $user->uid;
            $user_data = db_query_range('SELECT * FROM {membership_users} WHERE uid = :uid', 0, 1, array(':uid' => $uid))->fetchObject();
        }
    } else {
        if (user_access('administer membership')) {
            // Ha adminisztrátor és át lett adva azonosító paraméter
            // azt használjuk felhasználói azonosítónak, hogy bárki
            // adatait módosítani tudja.
            $id = trim(check_plain($id));
            $user_data = db_query_range('SELECT * FROM {membership_users} WHERE id = :id', 0, 1, array(':id' => $id))->fetchObject();
        } else {
            // Ha nem adminsztrátor, vagy adminisztrátor, de nem lett
            // átadva az uid paraméter akkor kiolvassa a saját
            // azonosítóját.
            $uid = $user->uid;
            $user_data = db_query_range('SELECT * FROM {membership_users} WHERE uid = :uid', 0, 1, array(':uid' => $uid))->fetchObject();
        }
    }
    return $user_data;
}

/**
 * Delete order.
 * @param type $form
 * @param type $form_state
 * @param type $oid Order id.
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_union_users_form($form, &$form_state) {

    if (!isset($form_state['storage']['union_prepared'])) {

        $text = '<p>Add meg az egyesíteni kívánt fiókok membership felhasználó azonosítóját.</p>';

        $form['description'] = array(
            '#type' => 'item',
            '#markup' => $text,
        );

        $form['muid_save'] = array(
            '#title' => t('Megtartandó megrendelő azonosító'),
            '#type' => 'textfield',
            '#maxlength' => 10,
            '#required' => TRUE,
        );

        $form['muid_delete'] = array(
            '#title' => t('Beolvadó megrendelő azonosító'),
            '#type' => 'textfield',
            '#maxlength' => 10,
            '#required' => TRUE,
        );

        $form['submit'] = array(
            '#type' => 'submit',
            '#value' => t('Keresés'),
            '#submit' => array('membership_union_users_form_confirm'),
        );
    } else {

        $muser_save = $form_state['storage']['muser_save'];
        $muser_delete = $form_state['storage']['muser_delete'];
        $confirm = '<h2>Biztosan egyesíted a két megrendelőt?</h2>';
        $confirm .= '<p>Ez a művelet <strong>nem vonható vissza!</strong></p><br>';
        $confirm .= "<p><strong>" . t('Fennmaradó') . ":</strong> $muser_save->lastname $muser_save->firstname ($muser_save->email)</p>";
        $confirm .= "<p><strong>" . t('Beolvadó') . ":</strong> $muser_delete->lastname $muser_delete->firstname ($muser_delete->email)</p>";

        $form['header_data'] = array(
            '#type' => 'item',
            '#markup' => $confirm,
        );

        $form['submit'] = array(
            '#type' => 'submit',
            '#value' => t('Igen, egyesítem'),
            '#attributes' => array('class' => array('btn-warning')),
            '#submit' => array('membership_union_users_form_submit'),
        );
    }

    return $form;
}

/**
 * Confirm delete order.
 * @param type $form
 * @param type $form_state
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_union_users_form_confirm($form, &$form_state) {

    if (!isset($form_state['storage']['union_prepared'])) {

        $query = db_select('membership_users', 'u');
        $query->fields('u', array('lastname', 'firstname', 'email', 'id'));
        $query->condition('u.id', $form_state['values']['muid_save']);
        $muser_save = $query->execute()->fetchObject();

        $query = db_select('membership_users', 'u');
        $query->fields('u', array('lastname', 'firstname', 'email', 'id'));
        $query->condition('u.id', $form_state['values']['muid_delete']);
        $muser_delete = $query->execute()->fetchObject();

        if (!empty($muser_save) && !empty($muser_delete)) {

            $form_state['storage']['muser_save'] = $muser_save;
            $form_state['storage']['muser_delete'] = $muser_delete;
            $form_state['storage']['union_prepared'] = TRUE;
            $form_state['rebuild'] = TRUE;
        } else {

            drupal_set_message('<strong>Hiba:</strong> Hibás adatok! Nem létező felhasználó.', 'error');
            $form_state['rebuild'] = TRUE;
        }
    }
}

/**
 * Delete order form submit.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_union_users_form_submit(&$form, &$form_state) {
    global $user;

    // Insert order
    if (!empty($form_state['storage']['muser_save']) && !empty($form_state['storage']['muser_delete'])) {

        $muser_save = membership_user_details_object($form_state['storage']['muser_save']->id);
        $muser_delete = membership_user_details_object($form_state['storage']['muser_delete']->id);

        // Update orders
        $orders_update = db_update('membership_orders')
                ->fields(array('id' => $muser_save->id,))
                ->condition('id', $muser_delete->id)
                ->execute();

        // Update invoices
        $invoices_update = db_update('membership_invoices')
                ->fields(array('id' => $muser_save->id,))
                ->condition('id', $muser_delete->id)
                ->execute();

        // Get user
        if ($muser_delete->uid != 0 && $muser_save->uid != 0) {

            // Update roles
            $delete_user = user_load($muser_delete->uid);
            $rids = array_keys($delete_user->roles);
            _set_roles($muser_save->uid, $rids, 'add_role');

            // Block user
            $block_user = db_update('users')
                    ->fields(array('status' => 0,))
                    ->condition('uid', $muser_delete->uid)
                    ->execute();
        }

        // Delete membership user
        $delete_muser = db_delete('membership_users')
                ->condition('id', $muser_delete->id)
                ->execute();

        // Redirect
        $form_state['redirect'] = array('user/' . $muser_save->uid . '/sajat-adatok', array('query' => '', 'fragment' => '',),);

        drupal_set_message(t('Felhasználók egyesítve: %old -> %save.', array(
            '%old' => $muser_delete->lastname . ' ' . $muser_delete->firstname . ' (' . $muser_delete->id . ')',
            '%save' => $muser_save->lastname . ' ' . $muser_save->firstname . ' (' . $muser_save->id . ')'))
        );
    } else {
        drupal_set_message('<strong>Hiba:</strong> Hibás adatok! Nem létező felhasználó.', 'error');
    }

    // Save to watchdog.
    watchdog('membership', 'Felhasználók egyesítve: %old -> %save.', array(
        '%old' => $muser_delete->lastname . ' ' . $muser_delete->firstname . ' (' . $muser_delete->id . ')',
        '%save' => $muser_save->lastname . ' ' . $muser_save->firstname . ' (' . $muser_save->id . ')',
        WATCHDOG_NOTICE));
}
