<?php

/**
 * @file
 * A bellítások űrlap
 */

/**
 * Implements hook_forms().
 */
function membership_admin_settings_form($form, &$form_state) {
    $form = array();

    $form['overview'] = array(
        '#markup' => t('Ezen a felületen állíthaják be az adminisztrátorok a tagsági rendszer alapvető adatait.'),
        '#prefix' => '<p>',
        '#suffix' => '</p>',
    );

    $form['contact'] = array(
        '#type' => 'fieldset',
        '#title' => t('Cégadatok'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['contact']['membership_firm_name'] = array(
        '#title' => t('Cégnév'),
        '#description' => t('A cég neve, ami a weboldalt üzemelteti és a számlát kiállítja.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_name'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_city'] = array(
        '#title' => t('Város'),
        '#description' => t('A cég bejegyzésének a városa.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_city'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_street_name'] = array(
        '#title' => t('Utca név'),
        '#description' => t('A cég bejegyzésének az utcája, házszám és közetrület típus nélkül.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_street_name'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_street_type'] = array(
        '#title' => t('Közterület'),
        '#description' => t('A közterület típusa, pl. út.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_street_type'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_street_no'] = array(
        '#title' => t('Házszám, emelet/ajtó'),
        '#description' => t('A cég házszáma, plusz emelet/ajtó ha van.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_street_no'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_zip'] = array(
        '#title' => t('Irányítószám'),
        '#description' => t('A cég címének irányítószáma.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_zip'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_country'] = array(
        '#title' => t('Ország'),
        '#description' => t('A cég címének országa.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_country'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_taxid'] = array(
        '#title' => t('Adószám'),
        '#description' => t('A cég adószáma.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_taxid'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_account_holder'] = array(
        '#title' => t('Számlavezető bank'),
        '#description' => t('A bank neve, amelyiknél a cég a bankszámlaszámát vezeti.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_account_holder'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_account'] = array(
        '#title' => t('Bankszámlaszám'),
        '#description' => t('A cég bankszámlaszáma.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_account'),
        '#required' => TRUE,
    );

    $form['invoice'] = array(
        '#type' => 'fieldset',
        '#title' => t('Számlázási adatok'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['invoice']['membership_firm_invoice_prefix'] = array(
        '#title' => t('Számla előtag'),
        '#description' => t('A számlaszám előtagja.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_invoice_prefix'),
        '#required' => TRUE,
    );

    $form['invoice']['membership_firm_invoice_next_number'] = array(
        '#title' => t('A számla következő sorszáma'),
        '#description' => t('A következő számlaszám. FIGYELEM! A mező csak az első beállításra szolgál!'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_invoice_next_number'),
        '#required' => TRUE,
    );

    $form['invoice']['membership_firm_invoice_payment_deadline'] = array(
        '#title' => t('A fizetési határidő'),
        '#description' => t('A megadott fizetési határidő napokban!'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_invoice_payment_deadline'),
        '#required' => TRUE,
    );

    $form['invoice']['membership_firm_invoice_vat'] = array(
        '#title' => t('ÁFA'),
        '#description' => t('Az általános forgalmi adó százalékban.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_invoice_vat'),
        '#required' => TRUE,
    );

//  $form['email'] = array(
//    '#type' => 'fieldset',
//    '#title' => t('Az Intelligent Mailer beállításai'),
//    '#collapsible' => TRUE,
//    '#collapsed' => TRUE,
//  );
//
//  $form['email']['membership_im_username'] = array(
//    '#title' => t('Az Intelligent Mailer felhasználó azonosítója'),
//    '#description' => t('A saját profilban található.'),
//    '#type' => 'textfield',
//    '#default_value' => variable_get('membership_im_username'),
//    '#required' => TRUE,
//  );
//
//
//  $form['email']['membership_im_secret'] = array(
//    '#title' => t('Az Intelligent Mailer titkos kódja'),
//    '#description' => t('A beállítások alatt található meg.'),
//    '#type' => 'textfield',
//    '#default_value' => variable_get('membership_im_secret'),
//    '#required' => TRUE,
//  );

    $form['display'] = array(
        '#type' => 'fieldset',
        '#title' => t('A megjelenítések beállításai'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['display']['membership_list_limit_product_group'] = array(
        '#title' => t('A listázandó elemek száma a termékcsoportoknál'),
        '#description' => t('Ennyi elem jelenik meg egyszerre a termékcsoportok oldalon listázáskor.'),
        '#type' => 'select',
        '#options' => array(5 => '5', 10 => '10', 25 => '25', 50 => '50', 100 => '100'),
        '#default_value' => variable_get('membership_list_limit_product_group'),
        '#required' => TRUE,
    );

    $form['display']['membership_list_limit_product'] = array(
        '#title' => t('A listázandó elemek száma a terméknél'),
        '#description' => t('Ennyi elem jelenik meg egyszerre a termékek oldalon listázáskor.'),
        '#type' => 'select',
        '#options' => array(5 => '5', 10 => '10', 25 => '25', 50 => '50', 100 => '100'),
        '#default_value' => variable_get('membership_list_limit_product'),
        '#required' => TRUE,
    );

    $form['display']['membership_list_limit_sales'] = array(
        '#title' => t('A listázandó elemek száma a sales-eknél'),
        '#description' => t('Ennyi elem jelenik meg egyszerre a sales-ek oldalon listázáskor.'),
        '#type' => 'select',
        '#options' => array(5 => '5', 10 => '10', 25 => '25', 50 => '50', 100 => '100'),
        '#default_value' => variable_get('membership_list_limit_sales'),
        '#required' => TRUE,
    );

    $form['display']['membership_list_limit_users'] = array(
        '#title' => t('A listázandó elemek száma a felhasználóknál.'),
        '#description' => t('Ennyi elem jelenik meg egyszerre listázás oldalon listázáskor.'),
        '#type' => 'select',
        '#options' => array(5 => '5', 10 => '10', 25 => '25', 50 => '50', 100 => '100'),
        '#default_value' => variable_get('membership_list_limit_sales'),
        '#required' => TRUE,
    );

    $form['other'] = array(
        '#type' => 'fieldset',
        '#title' => t('Egyéb beállítások'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['other']['membership_site_name'] = array(
        '#title' => t('A weboldal neve'),
        '#description' => t('Ez fog megjelenni a Google Analytics e-kereskedelmi követő kódjában, mint <em>store name</em>'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_site_name'),
        '#required' => TRUE,
    );

    $form['other']['membership_thankyou_link'] = array(
        '#title' => t('A megrendelés utáni köszönöm oldal linkje'),
        '#description' => t('A linknek a domainen belülre kell mutatnia, és nem kell megadni a domain nevet. Pl.: <em>node/64</em>.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_thankyou_link'),
        '#required' => TRUE,
    );

    $form['other']['membership_mail_from_name'] = array(
        '#title' => t('Erről a névről küldünk e-mailt a felhasználónak'),
        '#description' => t('Az email küldő neve.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_mail_from_name'),
        '#required' => TRUE,
    );

    $form['other']['membership_mail_from_email'] = array(
        '#title' => t('Erről az e-mail címről küldünk üzenetet a felhasználónak.'),
        '#description' => t('E-mail cím.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_mail_from_email'),
        '#required' => TRUE,
    );

    $form['other']['membership_terms_conditions'] = array(
        '#title' => t('ÁSZF'),
        '#description' => t('Ez a szöveg jelenik meg a megrendelés gomb alatt.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_terms_conditions', 'A Megrendelés gombra kattintással elfogadod az <a href="#" target="_blank" >Általános szerződési feltételeineket</a>.'),
        '#required' => TRUE,
        '#size' => 150
    );

    $form['css'] = array(
        '#type' => 'fieldset',
        '#title' => t('CSS osztályok'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['css']['membership_class_order_yes_button'] = array(
        '#title' => t('A rendelési űrlap „Igen” gombja'),
        '#description' => t('Azoknak a felhasználóknak, akik már rendeltek az oldalon, nem kell megadniuka újra az adataikat. Amikor helyesnek találják a megadottakat, erre a gombra kattintva léphetnek tovább.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_order_yes_button'),
    );

    $form['css']['membership_class_order_no_button'] = array(
        '#title' => t('A rendelési űrlap „Nem” gombja'),
        '#description' => t('Azoknak a felhasználóknak, akik már rendeltek az oldalon, nem kell megadniuka újra az adataikat. Amikor helytelennek találják a megadottakat, erre a gombra kattintva szerkeszthetik az adataikat.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_order_no_button'),
    );

    $form['css']['membership_class_order_order_button'] = array(
        '#title' => t('A „Megrendelés” gomb'),
        '#description' => t('A megrendelés gomb'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_order_order_button'),
    );

    $form['css']['membership_class_own_data_edit_button'] = array(
        '#title' => t('A saját adatok oldalon a „Szerkesztés” gomb.'),
        '#description' => t('A saját adatokat áttekintve a felhasználó szerksztheti azokat erre a gombra kattintva.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_own_data_edit_button'),
    );

    $form['css']['membership_class_own_data_save_button'] = array(
        '#title' => t('A saját adatok szerkesztése oldalon az „Adatok mentése” gomb.'),
        '#description' => t('A saját adatok szerkesztésekor a felhasználó ezzel a gombbal menti el az új adatit.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_own_data_save_button'),
    );

    $form['css']['membership_class_own_data_invoiced_status_text'] = array(
        '#title' => t('A kiszámlázott rendelések formátuma'),
        '#description' => t('A saját adatok oldalon lévő táblázatban a kiszámlázott tételeknél megjelenő szöveg formátuma.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_own_data_invoiced_status_text'),
    );

    $form['css']['membership_class_own_data_waiting_for_invoice_status_text'] = array(
        '#title' => t('Az aktivált, de még számlázásra váró rendelések formátuma'),
        '#description' => t('A saját adatok oldalon lévő táblázatban az akitivált, de még számlázásra váró tételeknél megjelenő szöveg formátuma.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_own_data_waiting_for_invoice_status_text'),
    );

    $form['css']['membership_class_own_data_waiting_for_payment_status_text'] = array(
        '#title' => t('A befizetésre váró megrendelt tételek formátuma'),
        '#description' => t('A saját adatok oldalon lévő táblázatban befieztésre váró tételeknél megjelenő szöveg formátuma.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_own_data_waiting_for_payment_status_text'),
    );

    $form['css']['membership_class_own_data_sent_status_text'] = array(
        '#title' => t('A kiküldött befizetési csekkek (vagy futár) formátuma'),
        '#description' => t('A saját adatok oldalon lévő táblázatban a csekkes vagy futárszolgálatos tételeknél megjelenő szöveg formátuma, ha az már úton van.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_own_data_sent_status_text'),
    );

    $form['css']['membership_class_own_data_waiting_for_send_status_text'] = array(
        '#title' => t('A kiküldésre váró csekkek (vagy futár) formátuma'),
        '#description' => t('A saját adatok oldalon lévő táblázatban a csekkes vagy futárszolgálatos tételeknél megjelenő szöveg formátuma, ha az kiküldésre vár.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_own_data_waiting_for_send_status_text'),
    );


    $form['ac'] = array(
        '#type' => 'fieldset',
        '#title' => t('Active Campaign'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['ac']['membership_ac_api_url'] = array(
        '#title' => t('Active Campaigan API URL'),
        '#description' => t('Active Campaigan API URL'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_ac_api_url'),
        '#required' => TRUE,
    );

    $form['ac']['membership_ac_api_key'] = array(
        '#title' => t('Active Campaigan API Key'),
        '#description' => t('Active Campaigan API kulcs.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_ac_api_key'),
        '#required' => TRUE,
    );
    return system_settings_form($form);
}
