<?php

/**
 * @file
 * A termékek adminisztrálása.
 */
require 'lib.php';
require_once 'common/membership.global.functions.inc';
require_once 'common/membership.validation.functions.inc';

/**
 * Termékek adminisztrálása - Listázás.
 */
function membership_product_list() {
    $html = '';

    $header = array(
        array('data' => 'pid', 'field' => 'pid', 'sort' => 'asc'),
        array('data' => t('Termék neve'), 'field' => 'name'),
        array('data' => t('IM Címke'), 'field' => 'table_name'),
        array('data' => t('Ára'), 'field' => 'price'),
        array('data' => t('Hash'), 'field' => 'hash'),
        array('data' => t('Műveletek')),
    );

    $result = db_select('membership_products', 'p')
            ->extend('PagerDefault')
            ->limit(variable_get('membership_list_limit_product'))
            ->extend('TableSort')
            ->orderByHeader($header)
            ->fields('p', array('pid', 'name', 'table_name', 'price', 'hash'))
            ->execute();

    $rows = array();

    foreach ($result as $value) {
        $links = l(t('Edit'), "admin/config/membership/product/edit/$value->pid") .
                '&nbsp;&nbsp;' .
                l(t('Delete'), "admin/config/membership/product/delete/$value->pid") .
                '&nbsp;&nbsp;' .
                l(t('Megrendelés link'), "megrendeles/", array('query' => array('pid' => $value->pid, 'hash' => $value->hash,))
        );

        $rows[] = array(
            'data' => array(
                $value->pid,
                $value->name,
                $value->table_name,
                $value->price . ' Ft',
                $value->hash,
                $links,
            )
        );
    }

    $html .= theme('table', array(
        'header' => $header,
        'rows' => $rows,
        'caption' => t('Termékek táblája'),
        'sticky' => TRUE,
        'empty' => t('Még nincsenek termékek létrehozva.'),
    ));

    $html .= theme('pager', array('tags' => array()));

    return $html;
}

/**
 * Az űrlap alapvelő mezőit határozza meg.
 *
 * @return array
 * Az összeállított űrlap.
 */
function membership_product_create_form() {
    // A termékcsoportok beolvasása.
    $result = db_query("SELECT pgid, name FROM {membership_product_groups}")->fetchAllKeyed();
    $products = db_query("SELECT pid, name FROM {membership_products}")->fetchAllKeyed();

    // Az űrlap.
    $form = array();

    $form['overview'] = array(
        '#prefix' => '<p>',
        '#suffix' => '</p>',
    );

    $form['name'] = array(
        '#title' => t('Termék neve'),
        '#description' => t('A termék neve'),
        '#type' => 'textfield',
        '#required' => TRUE,
    );

    $form['thank_you'] = array(
        '#title' => t('Köszönöm oldal'),
        '#description' => t('Megrendelés utáni érkező oldal.'),
        '#type' => 'textfield',
        '#required' => TRUE,
        '#size' => 20,
        '#maxlength' => 256,
        '#default_value' => variable_get('membership_thankyou_link'),
    );

    $form['table_name'] = array(
        '#title' => t('Intelleigent Mailer címke'),
        '#description' => t('A termék ezen a néven fog szerepelni az Intelligent Mailerben. 3 előtagot kap: M_, F_, L_. FIGYELEM! Ha ez a mező meg lesz változtatva az IM-ben is át kell írni a címkéket, különben hibás lesz a teljes aktiválási folyamat!'),
        '#type' => 'textfield',
        '#required' => TRUE,
    );

    $form['proforma_name'] = array(
        '#title' => t('Számla név'),
        '#description' => t('A termék neve, ami a proforma számlán fog megjelenni.'),
        '#type' => 'textfield',
        '#size' => 20,
        '#maxlength' => 16,
        '#required' => TRUE,
    );

    $form['price'] = array(
        '#title' => t('Termék ára'),
        '#description' => t('A termék bruttó ára forintban.'),
        '#type' => 'textfield',
        '#size' => 12,
        '#maxlength' => 9,
        '#required' => TRUE,
        '#field_suffix' => ' Ft',
    );

    $form['shipping'] = array(
        '#title' => t('Szállítás költség'),
        '#description' => t('A termék szállítási költsége forintban.'),
        '#type' => 'textfield',
        '#size' => 12,
        '#maxlength' => 9,
        '#required' => TRUE,
        '#field_suffix' => ' Ft',
    );

    $form['vat'] = array(
        '#title' => t('ÁFA'),
        '#description' => t('Az általános forgalmi adó százalékban.'),
        '#type' => 'textfield',
        '#size' => 12,
        '#maxlength' => 9,
        '#required' => TRUE,
        '#default_value' => variable_get('membership_firm_invoice_vat'),
        '#field_suffix' => ' %',
    );

    $form['pgid'] = array(
        '#title' => t('Termékcsoport'),
        '#description' => t('Az itt kiválasztott termékcsoportba fog a termék kerülni. Az egy csoportba tartozó termékek egy szűrés oldalon egyszerre jelennek meg.'),
        '#type' => 'select',
        '#options' => $result,
        '#required' => TRUE,
    );

    $form['payment_modes'] = array(
        '#title' => 'Fizetési módok',
        '#description' => t('A lehetséges fizetési módok.'),
        '#type' => 'checkboxes',
        '#options' => variable_get('membership_payment_modes'),
    );

    // Összállít egy asszociatív tömböt a role-okból.
    $roles = user_roles();

    // Összeállít egy associatív tömböt a hírlevél listákból.
//  $xml = em_get_lists();
//  foreach ($xml->data->item as $value) {
//    $email_lists["$value->listid"] = "$value->name";
//  }

    $form['prerequisite'] = array(
        '#title' => t('Előfeltételek a rendeléshez'),
        '#description' => t('Azokat a szerepköröket kell bejelölni, amik nélkül, az adott termék nem rendelhető. Vagyis ezekkel rendelkeznie kell a felhazsnálónak, hogy meg tudja rendelni a terméket. Hogy egy termék bárki által rendelhetől legyen üresen kell hagyni.'),
        '#type' => 'checkboxes',
        '#options' => $roles,
    );

    $form['affiliate'] = array(
        '#type' => 'fieldset',
        '#title' => t('A partnerprogram'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['affiliate']['commission'] = array(
        '#title' => t('A partner jutaléka'),
        '#description' => t('Ennyit fizetünk ki bruttó áron (ÁFÁs számla ellenében) a partnernek forintban, ha az ő ajánlására érkezett rendelés.'),
        '#type' => 'textfield',
        '#size' => 12,
        '#maxlength' => 9,
        '#required' => TRUE,
        '#default_value' => 0,
        '#field_suffix' => ' Ft',
    );

    $form['affiliate']['remark'] = array(
        '#title' => t('Megjegyzés'),
        '#description' => t('Megjegyzés a termékhez.'),
        '#type' => 'textfield',
        '#required' => FALSE,
    );

    $form['order_roles'] = array(
        '#type' => 'fieldset',
        '#title' => t('A rendeléskor történő, szerepkör események'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['order_roles']['roles_order_remove'] = array(
        '#title' => t('A szerepköröket törölni'),
        '#description' => t('A megrendelőt, amikor megrendelte a terméket, ezekről a szerepkörökről töröljük. Első rendelők esetén ez figyelmen kívül van hagyva, mert nem lehet jogosultságot állítani olyan felahsználó esetében, aki még nincs a Drupal user táblájában.'),
        '#type' => 'checkboxes',
        '#options' => $roles,
    );

    $form['order_roles']['roles_order_add'] = array(
        '#title' => t('A szerepköröket hozzárendelni'),
        '#description' => t('A megrendelőt, amikor megrendelte a terméket, ezekhez a szerepkörökhöz adjuk hozzá. Első rendelők esetén ez figyelmen kívül van hagyva, mert nem lehet jogosultságot állítani olyan felahsználó esetében, aki még nincs a Drupal user táblájában.'),
        '#type' => 'checkboxes',
        '#options' => $roles,
    );

    $form['activate_roles'] = array(
        '#type' => 'fieldset',
        '#title' => t('Az aktiváláskor történő, szerepkör események'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['activate_roles']['roles_activate_remove'] = array(
        '#title' => t('A szerepköröket törölni'),
        '#description' => t('A megrendelőt, amikor aktiváljuk a terméket, ezekről a szerepkörökről töröljük.'),
        '#type' => 'checkboxes',
        '#options' => $roles,
    );

    $form['activate_roles']['roles_activate_add'] = array(
        '#title' => t('A szerepköröket hozzárendelni'),
        '#description' => t('A megrendelőt, amikor aktiváljuk a terméket, ezekhez a szerepkörökhöz adjuk hozzá.'),
        '#type' => 'checkboxes',
        '#options' => $roles,
    );

//  $form['order_newsletter'] = array(
//    '#type' => 'fieldset',
//    '#title' => t('A rendeléskor történő, hírlevél események'),
//    '#collapsible' => TRUE,
//    '#collapsed' => TRUE,
//  );
//
//  $form['order_newsletter']['newsletter_order_remove'] = array(
//    '#title' => t('Törölni a hírlevekről'),
//    '#description' => t('A megrendelőt, amikor megrendelte a terméket, ezekről a hírlevél csoportokról töröljük.'),
//    '#type' => 'checkboxes',
//    '#options' => $email_lists,
//  );
//
//  $form['order_newsletter']['newsletter_order_add'] = array(
//    '#title' => t('Hozzáadni a hírlevekhez'),
//    '#description' => t('A megrendelőt, amikor megrendelte a terméket, ezekhez a hírlevél csoportokhoz adjuk hozzá.'),
//    '#type' => 'checkboxes',
//    '#options' => $email_lists,
//  );
//
//
//  $form['activate_newsletter'] = array(
//    '#type' => 'fieldset',
//    '#title' => t('Az aktiváláskor történő, hírlevél események'),
//    '#collapsible' => TRUE,
//    '#collapsed' => TRUE,
//  );
//
//  $form['activate_newsletter']['newsletter_activate_remove'] = array(
//    '#title' => t('Törölni a hírlevekről'),
//    '#description' => t('A megrendelőt, amikor aktiváljuk, ezekről a hírlevél csoportokról töröljük.'),
//    '#type' => 'checkboxes',
//    '#options' => $email_lists,
//  );
//
//  $form['activate_newsletter']['newsletter_activate_add'] = array(
//    '#title' => t('Hozzáadni a hírlevekhez'),
//    '#description' => t('A megrendelőt, amikor aktiváljuk, ezekhez a hírlevél csoportokhoz adjuk hozzá.'),
//    '#type' => 'checkboxes',
//    '#options' => $email_lists,
//  );
//
    $form['newsletter'] = array(
        '#type' => 'fieldset',
        '#title' => t('Hírlevél események'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['newsletter']['order_newsletter'] = array(
        '#type' => 'fieldset',
        '#title' => t('A rendeléskor történő, hírlevél események'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['newsletter']['order_newsletter']['newsletter_order'] = array(
        '#title' => t('Rendelési szekvencia'),
        '#description' => t('Ezen a szekvencián indítjuk el a rendelése után.'),
        '#type' => 'textfield',
    );

    $form['newsletter']['order_newsletter']['order_tags_add'] = array(
        '#title' => t('Rendelési után ezeknek a címkék hozzáadása'),
        '#description' => t('Ezeket a címkéket adjuk hozzá rendelés után. Vesszővel elválasztva, szóköz nélkül. Pl: címke1,címke2,címke3. Az M_címke automatikusan hozzáadóik.'),
        '#type' => 'textfield',
    );

    $form['newsletter']['order_newsletter']['order_tags_remove'] = array(
        '#title' => t('Rendelési után ezeknek acímkék eltávollítása'),
        '#description' => t('Ezeket a címkéket távolítjuk el rendelés után. Vesszővel elválasztva, szóköz nélkül. Pl: címke1,címke2,címke3.'),
        '#type' => 'textfield',
    );

    $form['newsletter']['activate_newsletter'] = array(
        '#type' => 'fieldset',
        '#title' => t('Az aktiváláskor történő, hírlevél események'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );


    $form['newsletter']['activate_newsletter']['newsletter_activate'] = array(
        '#title' => t('Aktiválási szekvencia'),
        '#description' => t('Ezen a szekvencián indítjuk el az aktiválása után.'),
        '#type' => 'textfield',
    );

    $form['newsletter']['activate_newsletter']['activate_tags_add'] = array(
        '#title' => t('Aktiválás után ezeknek  a címkék hozzáadása'),
        '#description' => t('Ezeket a címkéket adjuk hozzá aktiválás után. Vesszővel elválasztva, szóköz nélkül. Pl: címke1,címke2,címke3. Az F_címke automatikusan hozzáadóik.'),
        '#type' => 'textfield',
    );

    $form['newsletter']['activate_newsletter']['activate_tags_remove'] = array(
        '#title' => t('Aktiválás után ezeknek a címkék eltávollítása'),
        '#description' => t('Ezeket a címkéket távolítjuk el aktiválűs után. Vesszővel elválasztva, szóköz nélkül. Pl: címke1,címke2,címke3. Az L_címke, V_címke, M_címke automatikusan eltávolítódik.'),
        '#type' => 'textfield',
    );

    $form['upsell'] = array(
        '#type' => 'fieldset',
        '#title' => t('Upsell termék'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['upsell']['upsell_active'] = array(
        '#title' => t('Aktiválás'),
        '#description' => t('Aktiválja az upsellt és az megjelenik a rendelési űrlapon.'),
        '#type' => 'checkbox',
        '#return_value' => 1,
    );

    $form['upsell']['upsell_product'] = array(
        '#title' => t('Upsell termék'),
        '#description' => t('Ez a termék lesz csatolva a megrendeléshez.'),
        '#type' => 'select',
        '#options' => $products,
    );

    $form['upsell']['upsell_price'] = array(
        '#title' => t('Upsell ára'),
        '#description' => t('Az upsell termék bruttó ára forintban.'),
        '#type' => 'textfield',
        '#size' => 12,
        '#maxlength' => 9,
        '#default_value' => 0,
        '#field_suffix' => ' Ft',
        '#element_validate' => array('membership_element_validate_positive_number'),
    );

    $form['upsell']['upsell_intro'] = array(
        '#title' => t('Bevezető'),
        '#description' => t('Ez a szöveg jelenik meg bevezetőként a checkbox felett. HTML elemeket is használhatsz.'),
        '#type' => 'textarea',
        '#rows' => 5
    );

    $form['upsell']['upsell_title'] = array(
        '#title' => t('Címsor'),
        '#description' => t('Ez a szöveg jelenik meg a checkbox mellett a megrendelési űrlapon.'),
        '#type' => 'textfield',
    );

    $form['upsell']['upsell_description'] = array(
        '#title' => t('Leírás'),
        '#description' => t('Ez a szöveg jelenik meg leírásként a checkbox alatt. HTML elemeket is használhatsz.'),
        '#type' => 'textarea',
        '#rows' => 5
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => 'Termék mentése',
    );

    return $form;
}

/**
 * Implements hook_form().
 * Termék csoportok adminisztrálása - Hozzáadás.
 */
function membership_product_add_form($form, &$form_state) {
    $form = membership_product_create_form();
    $form['overview']['#markup'] = t('Ezen a felületen lehet hozzáadni új termékeket.');
    return $form;
}

function membership_product_add_form_validate($form, &$form_state) {
    $name = $form_state['values']['name'];
    $table_name = $form_state['values']['table_name'];
    $proforma_name = $form_state['values']['proforma_name'];
    $price = $form_state['values']['price'];
    $shipping = $form_state['values']['shipping'];
    $commission = $form_state['values']['commission'];

    $name_row = db_query('SELECT pid FROM {membership_products} WHERE name = :name', array(':name' => $name))->fetchObject();
    //$table_name_row = db_query('SELECT pid FROM {membership_products} WHERE table_name = :table_name', array(':table_name' => $table_name))->fetchObject();
    //$proforma_name_row = db_query('SELECT pid FROM {membership_products} WHERE proforma_name = :proforma_name', array(':proforma_name' => $proforma_name,))->fetchObject();
    // Ha létezik már ezen a néven termék a rendszerben, hibaüzenetet ad.
    if (isset($name_row->pid)) {
        form_set_error('name', t('Ezen a néven már létezik termék a rendszerben.'));
    }

    // Ha létezik már ilyen néven tábla név a rendszerben hibaüzenetet ad.
//  if (isset($table_name_row->pid)) {
//    form_set_error('table_name', t('Ezen a néven már létezik címke a rendszerben.'));
//  }
    // A számlára kerülő nevek lehetnek ugyanazok
//  // Ha létezik már ilyen néven számla név a rendszerben hibaüzenetet ad.
//  if(isset($proforma_name_row->pid)) {
//    form_set_error('proforma_name', t('Ezen a néven már létezik számla név a rendszerben.'));
//  }
    // Ha a szám (0-9) és 1-9 karakter hosszú és nagyobb mint nulla, akkor helyes. Ha ennek nem felel meg hibaüzenetet adunk.
    if (!((preg_match('{^[0-9]{1,9}$}', $price)) && ($price >= 0))) {
        form_set_error('price', t('Helytelen összeg. Az árnak pozitív egész számot adj meg, ami nem hosszabb 9 számegynél.'));
    }
    if (!((preg_match('{^[0-9]{1,9}$}', $shipping)) && ($shipping >= 0))) {
        form_set_error('shipping', t('Helytelen összeg. Az szállítási költségnek pozitív egész számot adj meg, ami nem hosszabb 9 számegynél.'));
    }
    if (!((preg_match('{^[0-9]{1,9}$}', $commission)) && ($commission >= 0))) {
        form_set_error('commission', t('Helytelen összeg. A jutaléknak pozitív egész számot adj meg, ami  nem hosszabb 9 számegynél.'));
    }
}

function membership_product_add_form_submit($form, &$form_state) {
    $p_fields = array(
        'pgid' => $form_state['values']['pgid'],
        'name' => trim($form_state['values']['name']),
        'thank_you' => trim($form_state['values']['thank_you']),
        'table_name' => trim($form_state['values']['table_name']),
        'proforma_name' => trim($form_state['values']['proforma_name']),
        'price' => (int) trim($form_state['values']['price']),
        'shipping' => (int) trim($form_state['values']['shipping']),
        'payment_modes' => serialize($form_state['values']['payment_modes']),
        'prerequisite' => serialize($form_state['values']['prerequisite']),
        'roles_order_add' => serialize($form_state['values']['roles_order_add']),
        'roles_order_remove' => serialize($form_state['values']['roles_order_remove']),
        'roles_activate_add' => serialize($form_state['values']['roles_activate_add']),
        'roles_activate_remove' => serialize($form_state['values']['roles_activate_remove']),
        'newsletter_order' => serialize(array(
            'newsletter_order' => $form_state['values']['newsletter_order'],
            'order_tags_add' => $form_state['values']['order_tags_add'],
            'order_tags_remove' => $form_state['values']['order_tags_remove'],
        )),
        'newsletter_activate' => serialize(array(
            'newsletter_activate' => $form_state['values']['newsletter_activate'],
            'activate_tags_add' => $form_state['values']['activate_tags_add'],
            'activate_tags_remove' => $form_state['values']['activate_tags_remove'],
        )),
        'hash' => _make_hash(8),
        'commission' => (int) trim($form_state['values']['commission']),
        'vat' => (int) trim($form_state['values']['vat']),
        'remark' => trim($form_state['values']['remark']),
        'created' => REQUEST_TIME,
        'changed' => REQUEST_TIME,
    );

    $pid = db_insert('membership_products')->fields($p_fields)->execute();

//    $up_fields = array(
//        'pid' => $pid,
//        'upid' => $form_state['values']['upsell_product'],
//        'title' => trim($form_state['values']['upsell_title']),
//        'description' => trim($form_state['values']['upsell_description']),
//        'active' => (int) $form_state['values']['upsell_active'],
//        'price' => (int) trim($form_state['values']['upsell_price'])
//    );
    // Létrehozzuk a címkéket az IM rendszerében
//  im_createLabel('M_' . $p_fields['table_name']);
//  im_createLabel('F_' . $p_fields['table_name']);
//  im_createLabel('L_' . $p_fields['table_name']);
    // Átirányítás a listázás oldalra.
    $form_state['redirect'] = array('admin/config/membership/product',
        array(
            'query' => array(),
            'fragment' => '',
        ),
    );

    // Üzenet kiírása az oldalon és az esemény rögzítése a watchdog-ba.
    drupal_set_message(t('<em>@name</em> nevű termék belüldve.', array('@name' => $p_fields['name'])));
}

/**
 * Implements hook_form().
 * Termék csoportok adminisztrálása - Szerkesztés.
 */
function membership_product_edit_form($form, &$form_state, $pid) {
    $product = db_query_range("SELECT * FROM {membership_products} WHERE pid = :pid", 0, 1, array(':pid' => $pid))->fetchObject();
    drupal_set_message(t('PID: <em>@name</em> - @result ', array('@name' => $pid, '@result' => $product->name)));

    $upsell = db_query_range('SELECT * FROM {membership_upsell_products} WHERE pid = :pid AND status = 1', 0, 1, array(':pid' => $pid,))->fetchObject();

    // Az űrlap feltöltése az adatbázisból kiolvasott értékekkel.
    $form = membership_product_create_form();
    $form['overview']['#markup'] = t('Ezen a felületen lehet hozzáadni új termékeket.');
    $form['name']['#default_value'] = $product->name;
    $form['thank_you']['#default_value'] = $product->thank_you;
    $form['table_name']['#default_value'] = $product->table_name;
    $form['proforma_name']['#default_value'] = $product->proforma_name;
    $form['price']['#default_value'] = $product->price;
    $form['vat']['#default_value'] = $product->vat;
    $form['shipping']['#default_value'] = $product->shipping;
    $form['pgid']['#default_value'] = $product->pgid;
    $form['payment_modes']['#default_value'] = unserialize($product->payment_modes);
    $form['prerequisite']['#default_value'] = unserialize($product->prerequisite);
    $form['order_roles']['roles_order_remove']['#default_value'] = unserialize($product->roles_order_remove);
    $form['order_roles']['roles_order_add']['#default_value'] = unserialize($product->roles_order_add);
    $form['activate_roles']['roles_activate_remove']['#default_value'] = unserialize($product->roles_activate_remove);
    $form['activate_roles']['roles_activate_add']['#default_value'] = unserialize($product->roles_activate_add);

    $nl_order = unserialize($product->newsletter_order);
    $form['newsletter']['order_newsletter']['newsletter_order']['#default_value'] = $nl_order['newsletter_order'];
    $form['newsletter']['order_newsletter']['order_tags_add']['#default_value'] = $nl_order['order_tags_add'];
    $form['newsletter']['order_newsletter']['order_tags_remove']['#default_value'] = $nl_order['order_tags_remove'];

    $nl_activate = unserialize($product->newsletter_activate);
    $form['newsletter']['activate_newsletter']['newsletter_activate']['#default_value'] = $nl_activate['newsletter_activate'];
    $form['newsletter']['activate_newsletter']['activate_tags_add']['#default_value'] = $nl_activate['activate_tags_add'];
    $form['newsletter']['activate_newsletter']['activate_tags_remove']['#default_value'] = $nl_activate['activate_tags_remove'];

    $form['affiliate']['commission']['#default_value'] = $product->commission;
    $form['affiliate']['remark']['#default_value'] = $product->remark;

    if ($upsell != null) {
        $form['upsell']['upsell_product']['#default_value'] = $upsell->upid;
        $form['upsell']['upsell_active']['#default_value'] = (bool) $upsell->status;
        $form['upsell']['upsell_price']['#default_value'] = $upsell->price;
        $form['upsell']['upsell_intro']['#default_value'] = $upsell->intro;
        $form['upsell']['upsell_title']['#default_value'] = $upsell->title;
        $form['upsell']['upsell_description']['#default_value'] = $upsell->description;
    }
    return $form;
}

function membership_product_edit_form_validate($form, &$form_state) {
    $name = $form_state['values']['name'];
    $table_name = $form_state['values']['table_name'];
    $proforma_name = $form_state['values']['proforma_name'];
    $price = $form_state['values']['price'];
    $shipping = $form_state['values']['shipping'];
    $pid = $form_state['build_info']['args'][0];
    $commission = $form_state['values']['commission'];

    $name_row = db_query('SELECT pid FROM {membership_products} WHERE name = :name AND pid != :pid', array(':name' => $name, ':pid' => $pid,))->fetchObject();
    //$table_name_row = db_query('SELECT pid FROM {membership_products} WHERE table_name = :table_name AND pid != :pid', array(':table_name' => $table_name, ':pid' => $pid,))->fetchObject();
//  $proforma_name_row = db_query('SELECT pid FROM {membership_products} WHERE proforma_name = :proforma_name AND pid != :pid', array(':proforma_name' => $proforma_name, ':pid' => $pid,))->fetchObject();
    // Ha létezik már ezen a néven termék a rendszerben, hibaüzenetet ad.
    if (isset($name_row->pid)) {
        form_set_error('name', t('Ezen a néven már létezik termék a rendszerben.'));
    }

    // Ha létezik már ilyen néven tábla név a rendszerben hibaüzenetet ad.
//  if (isset($table_name_row->pid)) {
//    form_set_error('table_name', t('Ezen a néven már létezik címke a rendszerben.'));
//  }
//  // Ha létezik már ilyen néven tábla név a rendszerben hibaüzenetet ad.
//  if(isset($proforma_name_row->pid)) {
//    form_set_error('proforma_name', t('Ezen a néven már létezik számla név a rendszerben.'));
//  }
//
    // Ha a szám (0-9) és 1-9 karakter hosszú és nagyobb mint nulla, akkor helyes. Ha ennek nem felel meg hibaüzenetet adunk.
    if (!((preg_match('{^[0-9]{1,9}$}', $price)) && ($price >= 0))) {
        form_set_error('price_name', t('Helytelen összeg. Az árnak pozitív egész számot adj meg, ami nem hosszabb 9 számegynél.'));
    }
    if (!((preg_match('{^[0-9]{1,9}$}', $shipping)) && ($shipping >= 0))) {
        form_set_error('shipping_name', t('Helytelen összeg. A szállítási költségnek pozitív egész számot adj meg, nem hosszabb 9 számegynél.'));
    }
    if (!((preg_match('{^[0-9]{1,9}$}', $commission)) && ($commission >= 0))) {
        form_set_error('commission_name', t('Helytelen összeg. A jutaléknak pozitív egész számot adj meg, ami nem hosszabb 9 számegynél.'));
    }
    if ($pid == $form_state['values']['upsell_product']) {
        form_set_error('upsell_product', t('Az upsell termék nem lehet azonos a szerkesztett termékkel.'));
    }
}

function membership_product_edit_form_submit($form, &$form_state) {

    $p_fields = array(
        'pgid' => $form_state['values']['pgid'],
        'name' => trim($form_state['values']['name']),
        'thank_you' => trim($form_state['values']['thank_you']),
        'table_name' => trim($form_state['values']['table_name']),
        'proforma_name' => trim($form_state['values']['proforma_name']),
        'price' => (int) trim($form_state['values']['price']),
        'shipping' => (int) trim($form_state['values']['shipping']),
        'payment_modes' => serialize($form_state['values']['payment_modes']),
        'prerequisite' => serialize($form_state['values']['prerequisite']),
        'roles_order_add' => serialize($form_state['values']['roles_order_add']),
        'roles_order_remove' => serialize($form_state['values']['roles_order_remove']),
        'roles_activate_add' => serialize($form_state['values']['roles_activate_add']),
        'roles_activate_remove' => serialize($form_state['values']['roles_activate_remove']),
        'newsletter_order' => serialize(array(
            'newsletter_order' => $form_state['values']['newsletter_order'],
            'order_tags_add' => $form_state['values']['order_tags_add'],
            'order_tags_remove' => $form_state['values']['order_tags_remove'],
        )),
        'newsletter_activate' => serialize(array(
            'newsletter_activate' => $form_state['values']['newsletter_activate'],
            'activate_tags_add' => $form_state['values']['activate_tags_add'],
            'activate_tags_remove' => $form_state['values']['activate_tags_remove'],
        )),
        'commission' => (int) trim($form_state['values']['commission']),
        'vat' => (int) trim($form_state['values']['vat']),
        'remark' => trim($form_state['values']['remark']),
        'changed' => REQUEST_TIME,
    );
    $pid = $form_state['build_info']['args'][0];

    $num_updated = db_update('membership_products')->fields($p_fields)->condition('pid', $pid, '=')->execute();

    $block_update = membership_update_analytics_block_pages($p_fields['thank_you']);

    $up_fields = array(
        'pid' => $pid,
        'upid' => $form_state['values']['upsell_product'],
        'title' => trim($form_state['values']['upsell_title']),
        'description' => trim($form_state['values']['upsell_description']),
        'intro' => trim($form_state['values']['upsell_intro']),
        'status' => (int) $form_state['values']['upsell_active'],
        'price' => (int) trim($form_state['values']['upsell_price'])
    );
    $upsell_merge = db_merge('membership_upsell_products')->fields($up_fields)->condition('pid', $pid, '=')->execute();

    // Átirányítás a listázás oldalra.
    $form_state['redirect'] = array('admin/config/membership/product',
        array(
            'query' => array(),
            'fragment' => '',
        ),
    );

    // Üzenet kiírása az oldalon és az esemény rögzítése a watchdog-ba.
    drupal_set_message(t('<em>@name</em> nevű termék adatai sikeresen megváltoztak.', array('@name' => $p_fields['name'])));
}

/**
 * Implements hook_form()
 * Termék csoportok adminisztrálása - Törlés.@name' => $p_fields['name'])), WATCHDOG_NOTICE);
 */
function membership_product_delete_form($form, &$form_state, $pid) {
    $result = db_query_range("SELECT name FROM {membership_products} WHERE pid = :pid", 0, 1, array(':pid' => $pid))->fetchField();

    $form = array();
    $form['pid'] = array(
        '#type' => 'value',
        '#value' => $pid,
    );

    // A termék régi nevét megtartjuk, hogy a watchdog-ba rögzíteni lehessen.
    $form['name'] = array(
        '#type' => 'hidden',
        '#value' => $result,
    );

    return confirm_form(
            $form, t('<em>"' . $result . '"</em> biztosan törölhető?'), 'admin/config/membership/product', t('Ez a művelet nem vonható vissza.'), t('Delete'), t('Cancel')
    );
}

function membership_product_delete_form_submit($form, &$form_state) {
    $pid = array('name' => $form_state['values']['pid']);

    $num_deleted = db_delete('membership_products')->condition('pid', $pid, '=')->execute();

    // Átirányítás a listázás oldalra.
    $form_state['redirect'] = array('admin/config/membership/product',
        array(
            'query' => array(),
            'fragment' => '',
        ),
    );

    // Üzenet kiírása az oldalon.
    drupal_set_message(t('A termék sikeresen törölve.'));
}
