<?php
/**
 * @file
 * Az számlák listázásához tartozó függvények.
 *
 */

require_once 'lib.php';

 
function membership_invoice_form($form, &$form_state) {
  if (!isset($_GET['iid']) || !isset($_GET['hash'])) {
    drupal_set_message(t('Hiányzó paraméterek, ezért nem található a számla.'),'error');
  }
  elseif (!db_query_range('SELECT iid FROM {membership_invoices} WHERE iid = :iid AND hash = :hash', 0, 1, array(':iid' => trim(check_plain($_GET['iid'])), ':hash' => trim(check_plain($_GET['hash']))))) {
    drupal_set_message(t('Nincs ilyen számla.'),'error');
  } else {
    $iid = trim(check_plain($_GET['iid']));
    $hash = trim(check_plain($_GET['hash']));
    
    // Ha minden helyes, létrehozzuk az oldalt.  
    $link = membership_create_invoice($iid);
    
    $html = '';   
    $html .= '<p>A számládat innen töltheted le:</p>';
    $html .= '<p><a class="btn btn-primary" href="'.$link.'">Számla letöltése</a></p>';
    $html .= '<p>Ha a gombra kattintva nem jelenik meg a számla, kattints jobb egér gombbal rá és a felugró menüből válaszd a <em>Hivatkozás mentése másnéven...</em> pontot.</p>';
    
    $form = array();
    
    $form['text'] = array(
      '#type' => 'item',
      '#markup' => $html,
    );
    
    return $form;
  }
}
 
 
function membership_create_invoice($iid) {
  require_once 'tfpdf/tfpdf.php';

  $invoice = db_query_range('SELECT * FROM {membership_invoices} WHERE iid = :iid', 0, 1, array(':iid' => $iid))->fetchObject();
  $country = db_query_range('SELECT name FROM {membership_country} WHERE code = :code', 0, 1, array(':code'=> $invoice->country,))->fetchField();
  
  // A rendelés azonosító szám létrehozása.
  $identification = variable_get('membership_firm_invoice_prefix')."-$invoice->oid-$invoice->id";
  
  if ($invoice->cancellation==0) {
    // Ha normál számla.
    $header = 'Számla';
    $subheader = '';
    $prefix= '';
  } else {
    $header = 'Sztornó számla';
    $subheader = '(Sztornózott számla sorszáma: ' . variable_get('membership_firm_invoice_prefix') . '-' . $invoice->cancellation . ')';
    $prefix = '-';
  }
  
  $pdf=new tFPDF('P','mm','A4');
  $pdf->AddFont('DejaVu','','DejaVuSans.ttf',true);
  $pdf->AddFont('DejaVuB','','DejaVuSans-Bold.ttf',true);
  $pdf->AddFont('DejaVuI','','DejaVuSans-Oblique.ttf',true);
  $pdf->SetTopMargin(15);
  $pdf->AddPage();
  $pdf->SetFont('DejaVuB','',18);
  $pdf->Cell(190,10,$header, 0, 0 , 'C');
  $pdf->Ln(6);
  $pdf->SetFont('DejaVu','',14);
  $pdf->Cell(190,10,$subheader, 0, 0 , 'C');
  $pdf->Ln(16);
  $pdf->SetFont('DejaVuI','',12);
  $pdf->Cell(95,10,'Sorszáma: ' . variable_get('membership_firm_invoice_prefix') . '-' . $invoice->invoice_number, 0, 0 , 'L'); 
  $pdf->Cell(95,10,"Rendelésazonosító: $identification", 0, 0 , 'R'); 

  //----- Dobozok ----- //
  $pdf->SetFont('DejaVuB','',12);
  $pdf->SetXY(10,46);
  $pdf->Cell(95,10,"Kiállító:",0 ,0, 'L');
  $pdf->SetFont('DejaVu','',12);
  $pdf->Ln(10);
  $pdf->Cell(95,10,variable_get('membership_firm_name'),0 ,0, 'L');
  $pdf->Ln(6);
  $pdf->Cell(95,10,'H-'.
    variable_get('membership_firm_zip').' '.
    variable_get('membership_firm_city').' '.
    variable_get('membership_firm_street_name').' '.
    variable_get('membership_firm_street_type').' '.
    variable_get('membership_firm_street_no'),0 ,0, 'L');
  $pdf->Ln(6);
  $pdf->Cell(95,10,'Adószám: '.variable_get('membership_firm_taxid'),0 ,0, 'L');
  $pdf->Ln(10);
  $pdf->Cell(95,10,'Számlavezető: '.variable_get('membership_firm_account_holder'),0 ,0, 'L');
  $pdf->Ln(6);
  $pdf->Cell(95,10,variable_get('membership_firm_account'),0 ,0, 'L');
  $pdf->Ln(6);
  $pdf->Rect(10,46,95,50,'D');
  $pdf->Rect(105,46,95,50,'D');
  $pdf->SetXY(105,46);
  $pdf->SetFont('DejaVuB','',12);
  $pdf->Cell(95,10,"Vásárló:",0 ,0, 'L');
  $pdf->SetFont('DejaVu','',12);
  $pdf->Ln(10);
  // Ha magyarországról van szól, nem írjuk bele a címbe.
  if ($invoice->country='HU') $country = '';
  $pdf->SetX(105);
  $pdf->Cell(95,10,"$invoice->name",0 ,0, 'L');
  $pdf->Ln(6);
  $pdf->SetX(105);
  $pdf->Cell(95,10,"$invoice->zip $invoice->city",0 ,0, 'L');
  $pdf->Ln(6);
  $pdf->SetX(105);
  $pdf->Cell(95,10,$invoice->address,0 ,0, 'L');
  $pdf->Ln(6);
  $pdf->SetX(105);
  $pdf->Cell(95,10,$country,0 ,0, 'L');

  $pdf->Ln(29);
  if ($invoice->mode==1) {
    $mode = 'Készpénz';
  } else {
    $mode = 'Átutalás';
  }
  $header = array('Fizetés módja', 'Fizetés határidje', 'Számla kelte', 'Teljesítés dátuma');
  $data = array($mode, date('Y-m-d', $invoice->deadline), date('Y-m-d', $invoice->created), date('Y-m-d', $invoice->issued),);
  $cwidth = array(48,47,48,47);
  
  $pdf->SetFont('DejaVuB','',10);
  for($i=0; $i<count($header); $i++) {
    $pdf->Cell($cwidth[$i],7,$header[$i],1,0,'C');
  }
  $pdf->Ln();
  $pdf->SetFont('DejaVu','',10);
  for($i=0; $i<count($data); $i++) {
    $pdf->Cell($cwidth[$i],7,$data[$i],1,0,'C');
  }
  
  $pdf->Ln(15);

  $sku = $invoice->oid;
  $price = $invoice->amount;
  
  $vatplus = (100+$invoice->vat)/100;
  $net_price = number_format($price / $vatplus, 0, ',', ' ');
  $net_unit_price = $net_price;
  $vat = number_format($price - ($price / $vatplus), 0, ',', ' ');
  $price = number_format($price, 0, ',', ' ');
  
  $header = array("Cikkszám", "Megnevezés", "M.e.", "Menny", "Nettó egységár", "Nettó ár", "ÁFA %", "ÁFA érték", "Bruttó ár");
  $data = array ($sku, $invoice->product, "db", "1", "$prefix$net_unit_price Ft", "$prefix$net_price Ft", "$invoice->vat%", "$prefix$vat Ft", "$prefix$price Ft");
  $cwidth = array (20,34,9,16,32,22,15,21,21);

  $pdf->SetFont('DejaVuB','',10);
  for($i=0; $i<count($header); $i++) {
    $pdf->Cell($cwidth[$i],7,$header[$i],1,0,'C');
  }
  $pdf->Ln();
  $pdf->SetFont('DejaVu','',10);
  for($i=0; $i<count($data); $i++) {
    $pdf->Cell($cwidth[$i],10,$data[$i],1,0,'C');
  }
  $pdf->Ln(5);
  $pdf->setX(30);
  $pdf->SetFont('DejaVuI','',6);
  $pdf->Cell($cwidth[1], 7, 'VTSZ: 4901', 0, 0, 'C');
  
  $pdf->Ln(12);
  $pdf->SetFont('DejaVu','',10);
  $pdf->Cell(148, 7, 'Számlaérték ÁFA nélkül:', 0, 0, 'R');
  $pdf->SetFont('DejaVu','',10);
  $pdf->Cell(42, 7, "$prefix$net_price Ft", 1, 0, 'R');
  
  $pdf->Ln();
  //$pdf->SetFont('DejaVuB','',10);
  $pdf->Cell(148, 7, 'Az ÁFA összege:', 0, 0, 'R');
  $pdf->SetFont('DejaVu','',10);
  $pdf->Cell(42, 7, "$prefix$vat Ft", 1, 0, 'R');
  
  $pdf->Ln();
  $pdf->SetFont('DejaVuB','',10);
  $pdf->Cell(148, 7, 'A számla végösszege:', 0, 0, 'R');
  $pdf->Cell(42, 7, "$prefix$price Ft", 1, 0, 'R');
  
  if ($invoice->cancellation!=0) {
    // Ha stornószámla mínusszá alakítjuk a végösszeget.
    $invoice->amount = $invoice->amount * (-1);
  }
  
  $uri = 'public://invoice/' . variable_get('membership_firm_invoice_prefix') . '-' . $invoice->iid. '-' . $invoice->hash . '.pdf';
  $path = file_create_url($uri);
  $output = $pdf->Output("$uri" ,'F');
  
  return $path;
}
 
 
 
 
 /**
 * A megrendelők listázása.
 */
function membership_invoice_list_form($form, &$form_state) {
    // A paraméterek beolvasása.
  if (isset($_GET['invoice'])) $invoice = $_GET['invoice']; else $invoice = ''; 
  if (isset($_GET['name']))    $name    = $_GET['name'];    else $name    = ''; 
  if (isset($_GET['product'])) $product = $_GET['product']; else $product = ''; 
  if (isset($_GET['id']))      $id      = $_GET['id'];      else $id      = '';    
    
  $form = array();
  
  $form['invoice'] = array(
    '#type'        => 'textfield',
    '#title'       => 'Számla sorszáma',
    '#required'    => FALSE,
    '#size'        => 16,
    '#maxlength'   => 10, 
    '#prefix'      => '<table><tr><td>',
    '#suffix'      => '</td>',
    '#default_value' => $invoice,
  );
  
  $form['name'] = array(
    '#type'        => 'textfield',
    '#title'       => 'Neve vagy a cég neve',
    '#required'    => FALSE,
    '#size'        => 16,
    '#maxlength'   => 64,
    '#prefix'      => '<td>',
    '#suffix'      => '</td>',
    '#default_value' => $name,
  );
  
  $form['product'] = array(
    '#type'        => 'textfield',
    '#title'       => 'Termék neve',
    '#required'    => FALSE,
    '#size'        => 16,
    '#maxlength'   => 64,
    '#prefix'      => '<td>',
    '#suffix'      => '</td>',
    '#default_value' => $product,
  );
  
    $form['id'] = array(
    '#type'        => 'textfield',
    '#title'       => 'Felhasználó azonosító',
    '#required'    => FALSE,
    '#size'        => 16,
    '#maxlength'   => 254,
    '#prefix'      => '<td>',
    '#suffix'      => '</td></tr></table>',
    '#default_value' => $id,
  );

  $form['submit'] = array(
    '#type'       => 'submit',
    '#value'      => 'Keresés',
  );
  
  // Tábla elkészítése
  $header = array(
    array('data' => t('Számlaszám'), 'field' => 'invoice_number', 'sort' => 'desc'),
    array('data' => t('Név'), 'field' => 'name'),
    array('data' => t('Cím')),
    array('data' => t('Termék'), 'field' => 'product'),
    array('data' => t('Ára'), 'field' => 'amount'),
    array('data' => t('Kiállítás'), 'field' => 'created'),
    array('data' => t('Teljesítés'), 'field' => 'issued'),
    array('data' => t('Határidő'), 'field' => 'deadline'),
    array('data' => t('Típusa')),
    array('data' => t('Műveletek')),
  );
  
  $invoices = db_select('membership_invoices', 'i')
    ->extend('PagerDefault')
    ->limit(variable_get('membership_list_limit_invoices',10))
    ->extend('TableSort')
    ->orderByHeader($header)
    ->fields('i', array('iid','invoice_number', 'name', 'zip', 'city', 'address', 'country', 'product', 'amount', 'created', 'issued','deadline', 'cancellation', 'id', 'hash'))
    ->condition('invoice_number', "%$invoice%", 'LIKE')
    ->condition('name', "%$name%", 'LIKE')
    ->condition('product', "%$product%", 'LIKE')
    ->condition('id', "%$id%", 'LIKE')
    ->execute();
  
  $cancel_list = db_query('SELECT cancellation FROM {membership_invoices} WHERE cancellation !=0')->fetchCol();
    
  $rows = array();
    
  foreach ($invoices as $value) {
    $links ='';
    $links .= l(t('Megjelenítés'), 'szamla', array('query' => array('iid' => $value->iid, 'hash' => $value->hash))).'&nbsp;&nbsp;&nbsp;';
    
    if ($value->cancellation==0) {
      $cancellation = 'Normál';
      $prefix = '';
      if (!in_array($value->invoice_number, $cancel_list)) {
        // Ha a számla nincs lesztornózva már.
        $links .= l(t('Sztornózás'), 'admin/config/membership/invoices/cancel', array('query' => array('invoice' => $value->invoice_number))).'&nbsp;&nbsp;&nbsp;';
        $cancellation = 'Normál';
      } else {
        $cancellation = 'Stornózva';
      }
    } else {
      $cancellation = 'Stornó: ' .variable_get('membership_firm_invoice_prefix') . '-' . $value->cancellation;
      $prefix = '-';
    }
    $links .= l(t('Újraküldés'), 'admin/config/membership/invoices/re-send', array('query' => array('invoice' => $value->invoice_number))).'&nbsp;&nbsp;&nbsp;';
    
    $rows[]= array(
      'data' => array(
        variable_get('membership_firm_invoice_prefix') . '-' . $value->invoice_number,
        l($value->name, 'sajat-adatok', array('query' => array('id' => $value->id))),
        "$value->zip $value->city, $value->address",
        $value->product,
        "$prefix$value->amount Ft",
        date('Y-m-d', $value->created),
        date('Y-m-d', $value->issued),
        date('Y-m-d', $value->deadline),
        $cancellation,
        $links,
      )
    );
  }  
  
  $form['table'] = array(
    '#theme' => 'table',
    '#header' => $header,
    '#rows' => $rows,
    '#empty' => t('Nincsenek találatok.'),
    '#attributes' => array('class' => array('table table-striped table-bordered table-condensed')),
  );
  $form['pager'] = array('#markup' => theme('pager'));
  
  return $form;
}

function membership_invoice_list_form_submit($form, &$form_state) {
  $form_state['redirect'] = array('admin/config/membership/invoices',
    array('query' => array(
      'invoice' => $form_state['values']['invoice'],
      'name'    => $form_state['values']['name'],
      'product' => $form_state['values']['product'],
      'id'      => $form_state['values']['id'],
    ),
    'fragment' => '',),
  );
}

/**
 * Implements hook_form()
 * Sztornó számla.
 */
function membership_invoice_cancel_form($form, &$form_state) {
  $invoice_number = trim(check_plain($_GET['invoice']));
     
  $form = array();  
  $form['invoice'] = array(
    '#type' => 'value',
    '#value' => $invoice_number,
  );
  
  return confirm_form(
    $form,
    t('<em>"' . variable_get('membership_firm_invoice_prefix') . '-' . $invoice_number.'"</em> sorszámú számla biztosan stornózható?'),
    'admin/config/membership/invoices',
    t('Ez a művelet nem vonható vissza.'),
    t('Sztornózás'),
    t('Cancel')
  );
}

function membership_invoice_cancel_form_submit($form, &$form_state) {
  $invoice_number = $form_state['values']['invoice'];
    
  $result = db_query_range('SELECT * FROM {membership_invoices} WHERE invoice_number = :invoice_number', 0, 1, array(':invoice_number' => $invoice_number))->fetchObject();
  $max = db_query('SELECT MAX(invoice_number) FROM {membership_invoices}')->fetchField();
    
  $fields = array(
    'id' => $result->id,
    'oid' => $result->oid,
    'created' => REQUEST_TIME,
    'issued' => REQUEST_TIME,
    'invoice_number' => $max+1,
    'quantity' => $result->quantity,
    'amount' => $result->amount,
    'is_firm_invoice' => $result->is_firm_invoice,
    'cancellation' => $invoice_number,
    'error' => '',
    'name' => $result->name,
    'zip' => $result->zip,
    'city' => $result->city,
    'address' => $result->address,
    'country' => $result->country,
    'deadline' => REQUEST_TIME,
    'product' => $result->product,
    'hash' => _make_hash(32),
    'mode' => 2,
    'vat' => $result->vat,
  );
     
  $iid =db_insert('membership_invoices')->fields($fields)->execute(); 
  
  
  // Átirányítás a listázás oldalra.
  $form_state['redirect'] = array('admin/config/membership/invoices',
    array(
      'query' => array(),
      'fragment' => '',
    ),
  );
  
  // Üzenet kiírása az oldalon és az esemény rögzítése a watchdog-ba.
  drupal_set_message(t('A számla sikeresen stornózva.'));
}

function membership_invoice_add_form($form, &$form_state) {
  $form = array();
  
  if (empty($form_state['storage']['find_the_order'])) {
    $form['oid'] = array(
      '#title' => t('A rendelés azonosítója'),
      '#description' => t('A rendelésből az azonosító szöveg után is számsor. Vagyis a kiemelt rész: <em>1ev-<strong>3167</strong>-1230</em>.'),
      '#type' => 'textfield',
      '#required' => TRUE,
    );
    
    $form['search'] = array(
      '#type' => 'submit',
      '#value' => 'Keresés',
      '#validate' => array('membership_invoice_oid'),
    );
  } else {
    $user = $form_state['storage']['user'];
    $order = $form_state['storage']['order'];
    $product = db_query_range('SELECT name, proforma_name FROM {membership_products} WHERE pid = :pid', 0, 1, array(':pid' => $order->pid,))->fetchObject();
    
    $product_name  = $product->name;
    $proforma_name = $product->proforma_name;
    
    // Összeállítjuk a magánszemélynek szóló rendelését.
    $user_data = "$user->lastname $user->firstname, <em>$user->zip. $user->city, $user->address";
    if ($user->country!='HU') {
      // Ha nem magyarországi cím, akkor kiírjuk azt ország nevét is.
      $country = db_query('SELECT * FROM {membership_country} ORDER BY name ASC')->fetchAllKeyed();
      $user_data .= ', ' . $country[$user->country];
    }
    $user_data .= '</em>';
    $options = array(0 => $user_data,);
    
    // Ha céges számlát kért összeállítjuk a cégadatokat is.
    if ($user->is_firm_invoice) {
      $firm_data = "$user->firm_name, <em>$user->firm_zip. $user->firm_city, $user->firm_address (Adószám: $user->firm_taxid)</em>";
      $options[1] = $firm_data;
    }
    
    $form['order'] = array(
      '#type' => 'fieldset',
      '#title' => t("$product_name számlázása"),
      '#collapsible' => TRUE,
      '#collapsed' => FALSE,
    );
    
    $form['order']['is_firm_invoice'] = array(
      '#type' => 'radios',
      '#title' => t('Megrendelő adatai'),
      '#default_value' => $user->is_firm_invoice,
      '#options' => $options,
      '#required' => TRUE,
    );
    
    $form['order']['price'] = array(
      '#type' => 'textfield',
      '#title' => t('A fizetett összeg'),
      '#size' => 12,
      '#maxlength' => 9, 
      '#required' => TRUE,
      '#default_value' => $order->price,
     );

    $form['submit'] = array(
      '#type' => 'submit',
      '#value' => 'Aktiválás',
    );
    
    $form['id'] = array(
      '#type' => 'hidden',
      '#default_value' => $user->id,
    );

    $form['uid'] = array(
      '#type' => 'hidden',
      '#default_value' => $user->uid,
    );

    $form['nickname'] = array(
      '#type' => 'hidden',
      '#default_value' => $user->nickname,
    );

    $form['name'] = array(
      '#type' => 'hidden',
      '#default_value' => "$user->lastname $user->firstname",
    );

    $form['email'] = array(
      '#type' => 'hidden',
      '#default_value' => $user->email,
    );

    $form['oid'] = array(
      '#type' => 'hidden',
      '#default_value' => $order->oid,
    );

    $form['pid'] = array(
      '#type' => 'hidden',
      '#default_value' => $order->pid,
    );
    
    if ($user->is_firm_invoice==0) {
      // Normál számla
      $name    = "$user->lastname $user->firstname";  
      $zip     = $user->zip;
      $city    = $user->city;
      $address = $user->address;
    } else {
      // Céges számla.
      $name    = $user->firm_name;
      $zip     = $user->firm_zip;
      $city    = $user->firm_city;
      $address = $user->firm_address;
    }
    $country   = $user->country;
    
    $form['iname'] = array(
      '#type' => 'hidden',
      '#default_value' => $name, 
    );
    
    $form['izip'] = array(
      '#type' => 'hidden',
      '#default_value' => $zip,
    );
    $form['icity'] = array(
      '#type' => 'hidden',
      '#default_value' => $city,
    );
    $form['iaddress'] = array(
      '#type' => 'hidden',
      '#default_value' => $address,
    );
    $form['icountry'] = array(
      '#type' => 'hidden',
      '#default_value' => $country,
    );
    $form['iproduct'] = array(
      '#type' => 'hidden',
      '#default_value' => $proforma_name, 
    );
  }
  
  return $form;
}

function membership_invoice_oid($form, &$form_state) {
  $oid = trim($form_state['values']['oid']);
  // Megvizsgáljuk a megadott érték pozitív egész-e.
  if (!is_numeric($oid) || $oid < 1 || $oid != round($oid)) {
    // Ha nem pozitív egész hibaüzenetet adunk vissza.
    form_set_error('oid', t('A rendelés azonosítónak pozitív egész számnak kell lennie.'));
  } else {
    // Ha pozitív egész, akkor megnézzük, hogy létezik-e a rendelés azonosító.
    $order = db_query_range('SELECT * FROM {membership_orders} WHERE oid = :oid', 0, 1, array(':oid' => $oid,))->fetchObject();
    if (empty($order)) {
      form_set_error('oid', t('Ilyen sorszámmal nem létezik rendelés a rendszerben.'));
    } else {
      // Ha megtaláltuk, beolvassuk az user-t, átadjuk az adatokat és átlépünk az űrlap következő lépésére.
      $user = db_query_range('SELECT * FROM {membership_users} WHERE id = :id', 0, 1, array(':id' => $order->id,))->fetchObject();
      $form_state['storage']['order'] = $order;
      $form_state['storage']['user'] = $user;
      $form_state['storage']['find_the_order'] = TRUE;
      $form_state['rebuild'] = TRUE;
    }
  }
}

function membership_invoice_add_validate($form, &$form_state) {
  $price = trim($form_state['values']['price']);
  if (!is_numeric($price) || $price < 0 || $price != round($price)) {
    // Ha nem pozitív egész hibaüzenetet adunk vissza.
    form_set_error('price', t('A fizetendő összegnek pozitív egész számnak kell lennie.'));
  }
}

function membership_invoice_add_form_submit($form, &$form_state) {
  require_once 'membership.email.inc';
  
  $uid = $form_state['values']['uid'];
  $nickname = $form_state['values']['nickname'];
  $username = $form_state['values']['name'];
  $email = $form_state['values']['email'];
  
  $max = db_query('SELECT MAX(invoice_number) FROM {membership_invoices}')->fetchField();
  
  $invoice = array(
    'id' =>  $form_state['values']['id'],
    'oid' => $form_state['values']['oid'],
    'created' => REQUEST_TIME,
    'issued' => REQUEST_TIME,
    'invoice_number' => $max+1,
    'quantity' => 1,
    'amount' => (int) trim($form_state['values']['price']),
    'is_firm_invoice' => $form_state['values']['is_firm_invoice'],
    'cancellation' => NULL,
    'error' => '',
    'name' => $form_state['values']['iname'],
    'zip' => $form_state['values']['izip'],
    'city' => $form_state['values']['icity'],
    'address' => $form_state['values']['iaddress'],
    'country' => $form_state['values']['icountry'],
    'deadline' => REQUEST_TIME,
    'product' => $form_state['values']['iproduct'],
    'hash' => _make_hash(32),
    'mode' => 2,
    'vat' => variable_get('membership_firm_invoice_vat'),
  );
  
  if ($invoice['amount']!=0) {
    // Ha nagyobb a termnék értéke mint 0.     
    $iid = db_insert('membership_invoices')->fields($invoice)->execute();
  
    // Létrehozzuk a számlát.
    membership_create_invoice($iid);
    // Ha nagyobb a termnék értéke mint 0.  
    // E-mail küldés a számlázásról.
    _invoice_send($iid, $invoice['hash'], $email, $username);
  }
   // Átirányítás a listázás oldalra.
  $form_state['redirect'] = array('admin/config/membership/invoices',
    array(
      'query' => array(),
      'fragment' => '',
    ),
  );
  
  drupal_set_message(t($invoice['oid'] . '. sorszámú rendelés <em>('.$invoice['iname'].')</em> ki lett számlázva. Ez nem jelenti, hogy akitiválva lett vagy a sztornózva lett egy régi számlája. Azt sem jelenti, hogy ehhez a rendelséhez nem lett kiálltva már számla.'), 'status');  
}


function membership_bulk_invoices() {
  $result = db_query('SELECT iid FROM {membership_invoices} ORDER BY iid ASC')->fetchCol();
  $i=0;
  foreach ($result as $iid) {
    $path = $iid;
    $path = membership_create_invoice($iid);
    $i++;
  }
  drupal_set_message("$i számla kiállítva.");
}