<?php
/**
 * @file
 * Az e-mail küldés ideiglenes rutinjai ameddig nincs megírva a 
 * saját hírlevél küldő rendszer. Az email marketer api-ja 
 * megbízhatalan abból a szempontból, hogy amikor feliratunk
 * az api-val egy hírlevél listára valakit, ismeretlen oknál
 * fogva nem küldi ki az autorepondereket bizonyos esetekben.
 * Ezért a biztonság kedvéért a fontos e-maileket (megrendelés,
 * aktiválás, tagság létrehozása) egy saját e-mail küldő rutinnal
 * küldjük ki. Ezek a rutinok találhatók ebben a fájlban.
 */ 
 
/**
 * A megrendelés után küldött e-mail.
 *
 * @param string $name
 * A címzett neve.
 * 
 * @param string $email
 * A címzett e-mail címe.
 * 
 * @param string $product_name
 * A termék neve.
 * 
 * @param string $payment
 * A fizetés módja.
 * 
 * @param string $proforma_link
 * A proforma számla linkje.
 */
function _order_email_send($name, $email, $product_name, $payment, $proforma_link) {
  $subject = 'Fogadtuk a megrendelésedet.';
  $mail  = 'Szia,' . PHP_EOL . PHP_EOL;
  $mail .= 'Köszönjük, hogy megrendelted '. strtolower(_a_az($product_name)) . ' ' . $product_name . PHP_EOL;
  $mail .= 'nevű termékünket.' . PHP_EOL . PHP_EOL;
  $mail .= 'A következő lépésed az, hogy a rendelésed befizeted.' . PHP_EOL . PHP_EOL;
  switch ($payment) {
    case 2: 
      // Átutalás.
      $mail .= 'A fizetési adatokat a díjbekérő levélen találod, amit' . PHP_EOL;
      $mail .= 'ezen a linken érsz el:' . PHP_EOL;
      $mail .= $proforma_link . PHP_EOL . PHP_EOL;
      $mail .= 'Kérlek, a közleményben feltétlenül tüntesd fel a díjbekérő levél' . PHP_EOL;
      $mail .= 'alján található azonosítót. Ezzel nagyon megkönnyíted a munkánkat.' . PHP_EOL . PHP_EOL;
      break;
    case 3:
      // Sárga csekk. 
      $mail .= 'Rövidesen postára adjuk a sárga csekket, amin befizetheted a' . PHP_EOL;
      $mail .= 'rendelésed összegét. Addig is, elküldjük a díjbekérő levelet' . PHP_EOL;
      $mail .= 'amin megtalálod a rendelésed adatait:' . PHP_EOL;
      $mail .= $proforma_link . PHP_EOL . PHP_EOL;
      $mail .= 'Mivel időbe telik ameddig a posta értesít minket a befizetésedről,' . PHP_EOL;
      $mail .= 'megteheted, hogy a díjbekérő levél alapján befizeted egy bankban az' . PHP_EOL;
      $mail .= 'összeget. Így sokkal gyorsabban tudjuk aktiválni a hozzáférésed.' . PHP_EOL . PHP_EOL;
      break;
    case 4: 
      // Rózsaszín csekk.
      $mail .= 'Rövidesen postára adjuk a rózsaszín csekket, amin befizetheted a' . PHP_EOL;
      $mail .= 'rendelésed összegét. Addig is, elküldjük a díjbekérő levelet' . PHP_EOL;
      $mail .= 'amin megtalálod a rendelésed adatait:' . PHP_EOL;
      $mail .= $proforma_link . PHP_EOL . PHP_EOL;
      $mail .= 'Mivel időbe telik ameddig a posta értesít minket a befizetésedről,' . PHP_EOL;
      $mail .= 'megteheted, hogy a díjbekérő levél alapján befizeted egy bankban az' . PHP_EOL;
      $mail .= 'összeget. Így sokkal gyorsabban tudjuk aktiválni a hozzáférésed.' . PHP_EOL . PHP_EOL;
      break;
    case 6:
      // Futár szolgálat. 
      $mail .= 'A futárszolgálat pár napon belül felkeres, hogy ki tudd fizetni a' . PHP_EOL;
      $mail .= 'rendelésed összegét. Addig is, elküldjük a díjbekérő levelet' . PHP_EOL;
      $mail .= 'amin megtalálod a rendelésed adatait:' . PHP_EOL;
      $mail .= $proforma_link . PHP_EOL . PHP_EOL;
      $mail .= 'Kérlek figyelj arra, hogy a futár el tudjon érni.' . PHP_EOL . PHP_EOL;
      break;
  }
  $mail .= 'Ha bármilyen kérdésed vagy nehézséged van, válaszolj erre az e-mailre.' . PHP_EOL;
  $mail .= 'A barátságos munkatársaink szívesen segítenek neked.' . PHP_EOL . PHP_EOL;
  
  $mail .= 'Üdv,' . PHP_EOL;
  $mail .= 'Péter' . PHP_EOL . PHP_EOL; 

  _email_send($name, $email, $subject, $mail);
}

/**
 * Az aktiválás után küldött e-mail.
 *
 * @param string $name
 * A címzett neve.
 * 
 * @param string $email
 * A címzett e-mail címe.
 * 
 * @param string $product_name
 * A termék neve.
 */
function _activate_email_send($name, $email, $product_name) {
  $subject = 'Aktiváltuk a hozzáférésed';  
  $mail  = 'Szia,' . PHP_EOL . PHP_EOL;
  
  $mail .= _a_az($product_name) .' ' . $product_name . ' nevű termék' . PHP_EOL;
  $mail .= 'hozzáférése aktiválva lett.' . PHP_EOL . PHP_EOL;
  
  $mail .= 'Az oldalon a belépés után már hozzá fogsz férni. Ha bármilyen' . PHP_EOL;
  $mail .= 'nehézséged lenne ezzel kapcsolatban, válaszolj erre az e-mailre' . PHP_EOL;
  $mail .= 'és segítünk megoldani a problémádat.'. PHP_EOL. PHP_EOL;
  
  $mail .= 'Üdv,' . PHP_EOL;
  $mail .= 'Péter' . PHP_EOL . PHP_EOL; 
  
  _email_send($name, $email, $subject, $mail);
}
 
/**
 * Új felhasználó aktiválása.
 *
 * @param string $name
 * A címzett neve.
 * 
 * @param string $email
 * A címzett e-mail címe.
 * 
 * @param string $username
 * A felhasználó neve a Drupal rendszerében.
 * 
 * @param string $password
 * A jelszava a Drupal rendszerében. 
 */
function _new_user_email_send($name, $email, $username, $password) {
  global $base_url;
  
  $subject = 'Belépési adatok a weboldalra';
  $mail ='';
  $mail .= 'Szia,' . PHP_EOL . PHP_EOL;
  
  $mail .= 'Ezek a belépési adataid a ' . $base_url .' weboldalon:' . PHP_EOL . PHP_EOL;
  
  $mail .= "Felhasználónév: $username" . PHP_EOL;
  $mail .= "Jelszó: $password" . PHP_EOL . PHP_EOL;
  
  $mail .= 'A ' . $base_url .'/tagok oldalon tudsz belépni.' . PHP_EOL . PHP_EOL;
  
  $mail .= 'Kérlek figyelj arra, hogy pontosan add meg belépéskor. Ha nem tudsz' . PHP_EOL;
  $mail .= 'belépni az oldalra ezekkel az adatokkal, azt jelenti, hogy elgépelted' . PHP_EOL;
  $mail .= 'a felhasználó nevet vagy a jelszót. Figyelj arra, hogy mind a kettő' . PHP_EOL;
  $mail .= 'kis- és nagybetű érzékeny.' . PHP_EOL . PHP_EOL;
  
  $mail .= 'Ha bármilyen nehézséged lenne, írj nyugodtan nekünk, és segíteni fogunk.' . PHP_EOL . PHP_EOL;
  
  $mail .= 'Üdv,' . PHP_EOL;
  $mail .= 'Péter' . PHP_EOL . PHP_EOL; 
  
  _email_send($name, $email, $subject, $mail); 
}
 
 
 
/**
 * Számla elküldése.
 *
 * @param int $iid
 *   A számla azonosítója.
 * 
 * @param string $hash
 *   A számla hashkódja.
 *
 * @param string $name
 * A címzett neve.
 *
 * @param string $email
 *   A felhasználó e-mail címe.
 *   
 */
function _invoice_send($iid, $hash, $email, $name) {
  global $base_url;
  
  $subject = 'Számla...';
  $mail ='';
  $mail .= 'Szia,' . PHP_EOL . PHP_EOL;
  
  $mail .= 'A számládat itt tudod letölteni:' . PHP_EOL;
  $mail .= $base_url . "/szamla?iid=$iid&hash=$hash" . PHP_EOL . PHP_EOL;
  
//  $mail .= 'Később, miután beléptél az oldalon ezt a „Számlák” menüpont alatt' . PHP_EOL;
//  $mail .= 'is le tudod majd tölteni.' . PHP_EOL . PHP_EOL;
  
  $mail .= 'Üdv,' . PHP_EOL;
  $mail .= 'Péter' . PHP_EOL . PHP_EOL; 

  _email_send($name, $email, $subject, $mail); 
}

/**
 * Egy e-mailt küld a rendszerből a felhasználónak.
 *
 * @param string $name
 * A címzett neve.
 * 
 * @param string $email.
 * A címzett e-mail címe.
 * 
 * @param string $subject.
 * Az e-mail tárgya.
 * 
 * @param string $message
 * Az e-mail üzetnet.
 */
function _email_send($name, $email, $subject, $message) {
  $settings_mail_from_name = variable_get('membership_mail_from_name');
  $settings_mail_from_email = variable_get('membership_mail_from_email');

  $to = '"'. '=?UTF-8?B?'. base64_encode($name). '?=' .'" <'.$email.'>';

  $header  = 'MIME-Version: 1.0' . PHP_EOL;
  $header .= 'Content-type: text/plain; format=flowed; charset="UTF-8"' . PHP_EOL;
  $header .= 'Content-Transfer-Encoding: 8bit' .PHP_EOL;
  $header .= 'From: "'.'=?UTF-8?B?'. base64_encode($settings_mail_from_name). '?='.'" <'.$settings_mail_from_email.'>' . PHP_EOL;
  $header .= 'Reply-To: '. $settings_mail_from_email . PHP_EOL;
  $header .= 'Return-Path: '. $settings_mail_from_email . PHP_EOL;
  $header .= 'X-Mailer: PHP-' . phpversion() . PHP_EOL;
  
  mail($to, '=?UTF-8?B?'. base64_encode($subject). '?=', $message, $header);
}
