<?php

function callin_admin_settings_form($form, &$form_state) {
    $products = _callin_get_products();
    $form = array();

    $form['products'] = array(
        '#type' => 'fieldset',
        '#title' => t('Products'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['products']['callin_show_products'] = array(
        '#title' => t('Show these product'),
        '#description' => t('Only show these product on the callin add order page.'),
        '#type' => 'checkboxes',
        '#options' => $products,
        '#default_value' => variable_get('callin_show_products', array()),
        '#required' => TRUE,
    );


    foreach ($products as $key => $value) {
        $form['products']['commission'][$key] = array(
            '#type' => 'fieldset',
            '#title' => t($value),
            '#collapsible' => FALSE,
            '#collapsed' => FALSE,
            '#states' => array(
                'visible' => array(
                    ':input[name="callin_show_products[' . $key . ']"]' => array('checked' => true),
                ),
            ),
        );
        $form['products']['commission'][$key]['callin_product_commission_amount_' . $key] = array(
            '#title' => t('Commission amount'),
            '#description' => t('Commission amount in percentage.'),
            '#type' => 'textfield',
            '#default_value' => variable_get('callin_product_commission_amount_' . $key, 0),
            '#size' => 5,
            '#field_suffix' => '%',
            '#element_validate' => array('_callin_validate_commission'),
            '#required' => TRUE,
        );
    }

    return system_settings_form($form);
}
