/**
 * @file
 * Integration file for fancyBox module.
 */

(function($) {
  Drupal.behaviors.fancyBox = {
    attach: function(context, settings) {
      var selectors = ['.fancybox'];

      if (typeof settings.fancybox === 'undefined') {
        settings.fancybox = {};
      }

      if (typeof settings.fancybox.options === 'undefined') {
        settings.fancybox.options = {};
      }

      if (typeof settings.fancybox.callbacks !== 'undefined') {
        $.each(settings.fancybox.callbacks, function(i, cal) {
          settings.fancybox.options[i] = window[cal];
        });
      }

      if (typeof settings.fancybox.helpers !== 'undefined') {
        settings.fancybox.options.helpers = settings.fancybox.helpers;
        delete settings.fancybox.helpers;
      }

      if (typeof settings.fancybox.selectors !== 'undefined') {
        selectors = selectors.concat(settings.fancybox.selectors);
      }

      // Not needed because behaviors are reattached.
      settings.fancybox.options.live = false;

      $(selectors.join(',')).fancybox(settings.fancybox.options);
    }
  };
})(jQuery);
